/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.adobe.cc;

import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.adobe.cc.NuxeoAdobeConnectorService;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.directory.DirectoryException;
import org.nuxeo.ecm.directory.Session;
import org.nuxeo.ecm.directory.api.DirectoryService;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.DefaultComponent;

public class NuxeoAdobeConnectorServiceImpl
extends DefaultComponent
implements NuxeoAdobeConnectorService {
    private static Log log = LogFactory.getLog(NuxeoAdobeConnectorService.class);

    public void activate(ComponentContext context) {
        super.activate(context);
    }

    public void deactivate(ComponentContext context) {
        super.deactivate(context);
    }

    public void applicationStarted(ComponentContext context) {
        this.registerAdobeCCClient();
    }

    protected void registerAdobeCCClient() {
        DirectoryService ds = (DirectoryService)Framework.getService(DirectoryService.class);
        Framework.doPrivileged(() -> {
            try (Session session = ds.open("oauth2Clients");){
                HashMap<String, String> filter = new HashMap<String, String>();
                filter.put("clientId", "spiApp");
                DocumentModelList res = session.query(filter);
                if (res == null || res.size() == 0) {
                    HashMap<String, Object> data = new HashMap<String, Object>();
                    data.put("clientId", "spiApp");
                    data.put("name", "SPI");
                    data.put("redirectURIs", "https://siliconpublishing.com/c/spi_connect/connect.html");
                    data.put("autoGrant", true);
                    session.createEntry(data);
                }
            }
            catch (DirectoryException e) {
                log.error((Object)"Error during registering adobe cc app", (Throwable)e);
            }
        });
    }
}

