/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudfront.model.transform;

import com.amazonaws.services.cloudfront.model.ContentTypeProfile;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

public class ContentTypeProfileStaxUnmarshaller
implements Unmarshaller<ContentTypeProfile, StaxUnmarshallerContext> {
    private static ContentTypeProfileStaxUnmarshaller instance;

    public ContentTypeProfile unmarshall(StaxUnmarshallerContext context) throws Exception {
        ContentTypeProfile contentTypeProfile = new ContentTypeProfile();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return contentTypeProfile;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Format", targetDepth)) {
                    contentTypeProfile.setFormat(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ProfileId", targetDepth)) {
                    contentTypeProfile.setProfileId(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("ContentType", targetDepth)) continue;
                contentTypeProfile.setContentType(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return contentTypeProfile;
    }

    public static ContentTypeProfileStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new ContentTypeProfileStaxUnmarshaller();
        }
        return instance;
    }
}

