/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.blob.s3;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.BucketVersioningConfiguration;
import com.amazonaws.services.s3.model.CopyObjectRequest;
import com.amazonaws.services.s3.model.EncryptedPutObjectRequest;
import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.ListObjectsRequest;
import com.amazonaws.services.s3.model.ListVersionsRequest;
import com.amazonaws.services.s3.model.ObjectListing;
import com.amazonaws.services.s3.model.ObjectLockLegalHold;
import com.amazonaws.services.s3.model.ObjectLockLegalHoldStatus;
import com.amazonaws.services.s3.model.ObjectLockRetention;
import com.amazonaws.services.s3.model.ObjectLockRetentionMode;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import com.amazonaws.services.s3.model.S3VersionSummary;
import com.amazonaws.services.s3.model.SSEAwsKeyManagementParams;
import com.amazonaws.services.s3.model.SetObjectLegalHoldRequest;
import com.amazonaws.services.s3.model.SetObjectRetentionRequest;
import com.amazonaws.services.s3.model.VersionListing;
import com.amazonaws.services.s3.transfer.Copy;
import com.amazonaws.services.s3.transfer.Download;
import com.amazonaws.services.s3.transfer.Upload;
import com.amazonaws.services.s3.transfer.model.UploadResult;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.output.NullOutputStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.common.utils.RFC2231;
import org.nuxeo.ecm.blob.s3.S3BlobProvider;
import org.nuxeo.ecm.blob.s3.S3BlobStoreConfiguration;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.SystemPrincipal;
import org.nuxeo.ecm.core.blob.AbstractBlobGarbageCollector;
import org.nuxeo.ecm.core.blob.AbstractBlobStore;
import org.nuxeo.ecm.core.blob.BlobContext;
import org.nuxeo.ecm.core.blob.BlobManager;
import org.nuxeo.ecm.core.blob.BlobProvider;
import org.nuxeo.ecm.core.blob.BlobStore;
import org.nuxeo.ecm.core.blob.BlobUpdateContext;
import org.nuxeo.ecm.core.blob.BlobWriteContext;
import org.nuxeo.ecm.core.blob.KeyStrategy;
import org.nuxeo.ecm.core.blob.ManagedBlob;
import org.nuxeo.ecm.core.blob.binary.BinaryGarbageCollector;
import org.nuxeo.ecm.core.io.download.DownloadHelper;
import org.nuxeo.runtime.api.Framework;

public class S3BlobStore
extends AbstractBlobStore {
    private static final Logger log = LogManager.getLogger(S3BlobStore.class);
    protected static final char VER_SEP = '@';
    protected static final String USER_METADATA_USERNAME = "username";
    protected final S3BlobStoreConfiguration config;
    protected final AmazonS3 amazonS3;
    protected final String bucketName;
    protected final String bucketPrefix;
    protected final boolean useVersion;
    protected ObjectLockRetentionMode objectLockRetentionMode = ObjectLockRetentionMode.GOVERNANCE;
    protected final BinaryGarbageCollector gc;

    public S3BlobStore(String name, S3BlobStoreConfiguration config, KeyStrategy keyStrategy) {
        super(name, keyStrategy);
        this.config = config;
        this.amazonS3 = config.amazonS3;
        this.bucketName = config.bucketName;
        this.bucketPrefix = config.bucketPrefix;
        this.useVersion = this.isBucketVersioningEnabled() && !keyStrategy.useDeDuplication();
        this.gc = new S3BlobGarbageCollector();
    }

    public S3BlobStore getS3BinaryManager() {
        return this;
    }

    protected static boolean isMissingKey(AmazonServiceException e) {
        return e.getStatusCode() == 404 || "NoSuchKey".equals(e.getErrorCode()) || "Not Found".equals(e.getMessage());
    }

    protected boolean isBucketVersioningEnabled() {
        BucketVersioningConfiguration v = this.amazonS3.getBucketVersioningConfiguration(this.bucketName);
        return v.getStatus().equals("Enabled");
    }

    public boolean hasVersioning() {
        return this.useVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String writeBlob(BlobWriteContext blobWriteContext) throws IOException {
        BlobContext blobContext = blobWriteContext.blobContext;
        Blob blob = blobContext.blob;
        String copiedKey = this.copyBlob(blob);
        if (copiedKey != null) {
            return copiedKey;
        }
        Path tmp = null;
        try {
            String fileTraceSource;
            Path file;
            Path blobWriteContextFile = blobWriteContext.getFile();
            if (blobWriteContextFile != null) {
                file = blobWriteContextFile;
                fileTraceSource = "Nuxeo";
            } else {
                File blobFile = blob.getFile();
                if (blobFile != null) {
                    if (blobWriteContext.writeObserver != null) {
                        this.transfer(blobWriteContext, (OutputStream)NullOutputStream.NULL_OUTPUT_STREAM);
                    }
                    file = blobFile.toPath();
                    fileTraceSource = "Nuxeo";
                } else {
                    tmp = Files.createTempFile("bin_", ".tmp", new FileAttribute[0]);
                    this.logTrace(null, "->", "tmp", "write");
                    this.logTrace("hnote right: " + tmp.getFileName());
                    this.transfer(blobWriteContext, tmp);
                    file = tmp;
                    fileTraceSource = "tmp";
                }
            }
            String key = blobWriteContext.getKey();
            if (key == null) {
                throw new NuxeoException("Missing key");
            }
            if (key.indexOf(64) >= 0) {
                throw new NuxeoException("Invalid key '" + key + "', it contains the version separator '@'");
            }
            String versionId = this.writeFile(key, file, blobContext, fileTraceSource);
            String string = versionId == null ? key : key + "@" + versionId;
            return string;
        }
        finally {
            if (tmp != null) {
                try {
                    this.logTrace("tmp", "-->", "tmp", "delete");
                    this.logTrace("hnote right: " + tmp.getFileName());
                    Files.delete(tmp);
                }
                catch (IOException e) {
                    log.warn((Object)e, (Throwable)e);
                }
            }
        }
    }

    protected String writeFile(String key, Path file, BlobContext blobContext, String fileTraceSource) throws IOException {
        EncryptedPutObjectRequest putObjectRequest;
        String bucketKey = this.bucketPrefix + key;
        long t0 = 0L;
        if (log.isDebugEnabled()) {
            t0 = System.currentTimeMillis();
            log.debug("Writing s3://" + this.bucketName + "/" + bucketKey);
        }
        if (this.getKeyStrategy().useDeDuplication() && this.exists(bucketKey)) {
            return null;
        }
        ObjectMetadata objectMetadata = new ObjectMetadata();
        if (this.config.useClientSideEncryption) {
            putObjectRequest = new EncryptedPutObjectRequest(this.bucketName, bucketKey, file.toFile());
        } else {
            putObjectRequest = new PutObjectRequest(this.bucketName, bucketKey, file.toFile());
            if (this.config.useServerSideEncryption) {
                if (StringUtils.isNotBlank((CharSequence)this.config.serverSideKMSKeyID)) {
                    SSEAwsKeyManagementParams params = new SSEAwsKeyManagementParams(this.config.serverSideKMSKeyID);
                    putObjectRequest.setSSEAwsKeyManagementParams(params);
                } else {
                    objectMetadata.setSSEAlgorithm(ObjectMetadata.AES_256_SERVER_SIDE_ENCRYPTION);
                }
            }
        }
        this.setMetadata(objectMetadata, blobContext);
        putObjectRequest.setMetadata(objectMetadata);
        this.logTrace(fileTraceSource, "->", null, "write " + Files.size(file) + " bytes");
        this.logTrace("hnote right: " + bucketKey);
        Upload upload = this.config.transferManager.upload((PutObjectRequest)putObjectRequest);
        try {
            String versionId;
            UploadResult uploadResult = upload.waitForUploadResult();
            String string = versionId = this.useVersion ? uploadResult.getVersionId() : null;
            if (log.isDebugEnabled()) {
                long dtms = System.currentTimeMillis() - t0;
                log.debug("Wrote s3://" + this.bucketName + "/" + bucketKey + " in " + dtms + "ms");
            }
            if (versionId != null) {
                this.logTrace("<--", "v=" + versionId);
            }
            return versionId;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new NuxeoException((Throwable)e);
        }
    }

    protected void setMetadata(ObjectMetadata objectMetadata, BlobContext blobContext) {
        String username;
        NuxeoPrincipal principal;
        if (blobContext != null) {
            Blob blob = blobContext.blob;
            String filename = blob.getFilename();
            if (filename != null) {
                String contentDisposition = RFC2231.encodeContentDisposition((String)filename, (boolean)false, null);
                objectMetadata.setContentDisposition(contentDisposition);
            }
            String contentType = DownloadHelper.getContentTypeHeader((Blob)blob);
            objectMetadata.setContentType(contentType);
        }
        if (this.config.metadataAddUsername && (principal = NuxeoPrincipal.getCurrent()) != null && !(principal instanceof SystemPrincipal) && (username = principal.getActingUser()) != null) {
            Map<String, String> userMetadata = Collections.singletonMap(USER_METADATA_USERNAME, username);
            objectMetadata.setUserMetadata(userMetadata);
        }
    }

    public BlobStore.OptionalOrUnknown<Path> getFile(String key) {
        return BlobStore.OptionalOrUnknown.unknown();
    }

    public BlobStore.OptionalOrUnknown<InputStream> getStream(String key) throws IOException {
        return BlobStore.OptionalOrUnknown.unknown();
    }

    protected boolean exists(String bucketKey) {
        try {
            this.amazonS3.getObjectMetadata(this.bucketName, bucketKey);
            if (log.isDebugEnabled()) {
                log.debug("Blob s3://" + this.bucketName + "/" + bucketKey + " already exists");
            }
            this.logTrace("<--", "exists");
            this.logTrace("hnote right: " + bucketKey);
            return true;
        }
        catch (AmazonServiceException e) {
            if (S3BlobStore.isMissingKey(e)) {
                this.logTrace("<--", "missing");
                this.logTrace("hnote right: " + bucketKey);
                return false;
            }
            throw e;
        }
    }

    protected void clearBucket() {
        this.logTrace("group ClearBucket");
        ObjectListing list = null;
        long n = 0L;
        do {
            if (list == null) {
                this.logTrace("->", "listObjects");
                list = this.amazonS3.listObjects(this.bucketName);
            } else {
                list = this.amazonS3.listNextBatchOfObjects(list);
            }
            for (S3ObjectSummary summary : list.getObjectSummaries()) {
                this.amazonS3.deleteObject(this.bucketName, summary.getKey());
                ++n;
            }
        } while (list.isTruncated());
        if (n > 0L) {
            this.logTrace("loop " + n + " objects");
            this.logTrace("->", "deleteObject");
            this.logTrace("end");
        }
        VersionListing vlist = null;
        long vn = 0L;
        do {
            if (vlist == null) {
                this.logTrace("->", "listVersions");
                vlist = this.amazonS3.listVersions(new ListVersionsRequest().withBucketName(this.bucketName));
            } else {
                vlist = this.amazonS3.listNextBatchOfVersions(vlist);
            }
            for (S3VersionSummary vsummary : vlist.getVersionSummaries()) {
                this.amazonS3.deleteVersion(this.bucketName, vsummary.getKey(), vsummary.getVersionId());
                ++vn;
            }
        } while (vlist.isTruncated());
        if (vn > 0L) {
            this.logTrace("loop " + vn + " versions");
            this.logTrace("->", "deleteVersion");
            this.logTrace("end");
        }
        this.logTrace("end");
    }

    public boolean readBlob(String key, Path dest) throws IOException {
        String versionId;
        String objectKey;
        int seppos = key.indexOf(64);
        if (seppos < 0) {
            objectKey = key;
            versionId = null;
        } else {
            objectKey = key.substring(0, seppos);
            versionId = key.substring(seppos + 1);
        }
        String bucketKey = this.bucketPrefix + objectKey;
        long t0 = 0L;
        if (log.isDebugEnabled()) {
            t0 = System.currentTimeMillis();
            log.debug("Reading s3://" + this.bucketName + "/" + bucketKey);
        }
        try {
            GetObjectRequest getObjectRequest = new GetObjectRequest(this.bucketName, bucketKey, versionId);
            Download download = this.config.transferManager.download(getObjectRequest, dest.toFile());
            download.waitForCompletion();
            this.logTrace("<-", "read " + Files.size(dest) + " bytes");
            this.logTrace("hnote right: " + bucketKey + (String)(versionId == null ? "" : " v=" + versionId));
            if (log.isDebugEnabled()) {
                long dtms = System.currentTimeMillis() - t0;
                log.debug("Read s3://" + this.bucketName + "/" + bucketKey + " in " + dtms + "ms");
            }
            if (this.config.useClientSideEncryption) {
                return true;
            }
            String expectedDigest = this.getKeyStrategy().getDigestFromKey(objectKey);
            if (expectedDigest != null) {
                this.checkDigest(expectedDigest, download, dest);
            }
            return true;
        }
        catch (AmazonServiceException e) {
            if (S3BlobStore.isMissingKey(e)) {
                this.logTrace("<--", "missing");
                this.logTrace("hnote right: " + bucketKey + (String)(versionId == null ? "" : " v=" + versionId));
                if (log.isDebugEnabled()) {
                    log.debug("Blob s3://" + this.bucketName + "/" + bucketKey + " does not exist");
                }
                return false;
            }
            throw new IOException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new NuxeoException((Throwable)e);
        }
    }

    protected void checkDigest(String expectedDigest, Download download, Path file) throws IOException {
        String digest;
        if (!expectedDigest.equals(download.getObjectMetadata().getETag()) && !(digest = new DigestUtils(this.config.digestConfiguration.digestAlgorithm).digestAsHex(file.toFile())).equals(expectedDigest)) {
            String msg = "Invalid S3 object digest, expected=" + expectedDigest + " actual=" + digest;
            log.warn(msg);
            throw new IOException(msg);
        }
    }

    protected String copyBlob(Blob blob) throws IOException {
        if (!(blob instanceof ManagedBlob)) {
            return null;
        }
        ManagedBlob managedBlob = (ManagedBlob)blob;
        BlobProvider blobProvider = ((BlobManager)Framework.getService(BlobManager.class)).getBlobProvider(managedBlob.getProviderId());
        if (!this.getKeyStrategy().useDeDuplication()) {
            return null;
        }
        if (!(blobProvider instanceof S3BlobProvider)) {
            return null;
        }
        S3BlobStore sourceStore = (S3BlobStore)((S3BlobProvider)blobProvider).store.unwrap();
        if (!sourceStore.getKeyStrategy().equals(this.getKeyStrategy())) {
            return null;
        }
        String sourceKey = this.stripBlobKeyPrefix(managedBlob.getKey());
        String key = sourceKey;
        boolean found = this.copyBlob(key, sourceStore, sourceKey, false);
        if (!found) {
            throw new IOException("Cannot find source blob: " + sourceKey);
        }
        return key;
    }

    public boolean copyBlobIsOptimized(BlobStore sourceStore) {
        return sourceStore instanceof S3BlobStore;
    }

    public boolean copyBlob(String key, BlobStore sourceStore, String sourceKey, boolean atomicMove) throws IOException {
        BlobStore unwrappedSourceStore = sourceStore.unwrap();
        if (unwrappedSourceStore instanceof S3BlobStore) {
            S3BlobStore sourceS3BlobStore = (S3BlobStore)unwrappedSourceStore;
            try {
                boolean copied = this.copyBlob(key, sourceS3BlobStore, sourceKey, atomicMove);
                if (copied) {
                    return true;
                }
            }
            catch (AmazonServiceException e) {
                if (S3BlobStore.isMissingKey(e)) {
                    this.logTrace("<--", "missing");
                    return false;
                }
                throw new IOException(e);
            }
        }
        return this.copyBlobGeneric(key, sourceStore, sourceKey, atomicMove);
    }

    protected boolean copyBlob(String key, S3BlobStore sourceBlobStore, String sourceKey, boolean move) throws AmazonServiceException {
        String sourceBucketName = sourceBlobStore.bucketName;
        String sourceBucketKey = sourceBlobStore.bucketPrefix + sourceKey;
        String bucketKey = this.bucketPrefix + key;
        long t0 = 0L;
        if (log.isDebugEnabled()) {
            t0 = System.currentTimeMillis();
            log.debug("Copying s3://" + sourceBucketName + "/" + sourceBucketKey + " to s3://" + this.bucketName + "/" + bucketKey);
        }
        if (this.getKeyStrategy().useDeDuplication() && this.exists(bucketKey)) {
            return true;
        }
        this.logTrace("->", "getObjectMetadata");
        ObjectMetadata sourceMetadata = this.amazonS3.getObjectMetadata(sourceBucketName, sourceBucketKey);
        long length = sourceMetadata.getContentLength();
        this.logTrace("<-", length + " bytes");
        try {
            this.copyBlob(sourceBlobStore.config, sourceBucketKey, this.config, bucketKey, move);
            if (log.isDebugEnabled()) {
                long dtms = System.currentTimeMillis() - t0;
                log.debug("Copied s3://" + sourceBucketName + "/" + sourceBucketKey + " to s3://" + this.bucketName + "/" + bucketKey + " in " + dtms + "ms");
            }
            return true;
        }
        catch (AmazonServiceException e) {
            this.logTrace("<--", "ERROR");
            String message = "Direct copy failed from s3://" + sourceBucketName + "/" + sourceBucketKey + " to s3://" + this.bucketName + "/" + bucketKey + " (" + length + " bytes)";
            log.warn(message + ", falling back to slow copy: " + e.getMessage());
            log.debug(message, (Throwable)e);
            return false;
        }
    }

    protected void copyBlob(S3BlobStoreConfiguration sourceConfig, String sourceKey, S3BlobStoreConfiguration destinationConfig, String destinationKey, boolean move) {
        CopyObjectRequest copyObjectRequest = new CopyObjectRequest(sourceConfig.bucketName, sourceKey, destinationConfig.bucketName, destinationKey);
        if (destinationConfig.useServerSideEncryption) {
            if (StringUtils.isNotBlank((CharSequence)destinationConfig.serverSideKMSKeyID)) {
                SSEAwsKeyManagementParams params = new SSEAwsKeyManagementParams(destinationConfig.serverSideKMSKeyID);
                copyObjectRequest.setSSEAwsKeyManagementParams(params);
            } else {
                ObjectMetadata newObjectMetadata = new ObjectMetadata();
                newObjectMetadata.setSSEAlgorithm(ObjectMetadata.AES_256_SERVER_SIDE_ENCRYPTION);
                copyObjectRequest.setNewObjectMetadata(newObjectMetadata);
            }
        }
        this.logTrace("->", "copyObject");
        this.logTrace("hnote right: " + sourceKey + " to " + destinationKey);
        Copy copy = destinationConfig.transferManager.copy(copyObjectRequest, sourceConfig.amazonS3, null);
        try {
            copy.waitForCompletion();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new NuxeoException((Throwable)e);
        }
        this.logTrace("<--", "copied");
        if (move) {
            this.logTrace("->", "deleteObject");
            this.logTrace("hnote right: " + sourceKey);
            this.amazonS3.deleteObject(sourceConfig.bucketName, sourceKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean copyBlobGeneric(String key, BlobStore sourceStore, String sourceKey, boolean atomicMove) throws IOException {
        Path tmp = null;
        try {
            String fileTraceSource;
            Path file;
            BlobStore.OptionalOrUnknown fileOpt = sourceStore.getFile(sourceKey);
            if (fileOpt.isPresent()) {
                file = (Path)fileOpt.get();
                fileTraceSource = sourceStore.getName();
            } else {
                tmp = Files.createTempFile("bin_", ".tmp", new FileAttribute[0]);
                this.logTrace(null, "->", "tmp", "write");
                this.logTrace("hnote right: " + tmp.getFileName());
                boolean found = sourceStore.readBlob(sourceKey, tmp);
                if (!found) {
                    boolean bl = false;
                    return bl;
                }
                file = tmp;
                fileTraceSource = "tmp";
            }
            String versionId = this.writeFile(key, file, null, fileTraceSource);
            if (versionId != null) {
                throw new NuxeoException("Cannot copy blob if store has versioning");
            }
            if (atomicMove) {
                sourceStore.deleteBlob(sourceKey);
            }
            boolean bl = true;
            return bl;
        }
        finally {
            if (tmp != null) {
                try {
                    this.logTrace("tmp", "-->", "tmp", "delete");
                    this.logTrace("hnote right: " + tmp.getFileName());
                    Files.delete(tmp);
                }
                catch (IOException e) {
                    log.warn((Object)e, (Throwable)e);
                }
            }
        }
    }

    public void writeBlobProperties(BlobUpdateContext blobUpdateContext) throws IOException {
        String versionId;
        String objectKey;
        String key = blobUpdateContext.key;
        int seppos = key.indexOf(64);
        if (seppos < 0) {
            objectKey = key;
            versionId = null;
        } else {
            objectKey = key.substring(0, seppos);
            versionId = key.substring(seppos + 1);
        }
        String bucketKey = this.bucketPrefix + objectKey;
        try {
            SetObjectLegalHoldRequest request;
            if (blobUpdateContext.updateRetainUntil != null) {
                if (versionId == null) {
                    throw new IOException("Cannot set retention on non-versioned blob");
                }
                Calendar retainUntil = blobUpdateContext.updateRetainUntil.retainUntil;
                Date retainUntilDate = retainUntil == null ? null : retainUntil.getTime();
                ObjectLockRetention retention = new ObjectLockRetention();
                retention.withMode(this.objectLockRetentionMode).withRetainUntilDate(retainUntilDate);
                request = new SetObjectRetentionRequest();
                request.withBucketName(this.bucketName).withKey(bucketKey).withVersionId(versionId).withRetention(retention);
                this.logTrace("->", "setObjectRetention");
                this.logTrace("hnote right: " + bucketKey + "v=" + versionId);
                this.logTrace("rnote right: " + (retainUntil == null ? "null" : retainUntil.toInstant().toString()));
                this.amazonS3.setObjectRetention((SetObjectRetentionRequest)request);
            }
            if (blobUpdateContext.updateLegalHold != null) {
                if (versionId == null) {
                    throw new IOException("Cannot set legal hold on non-versioned blob");
                }
                boolean hold = blobUpdateContext.updateLegalHold.hold;
                ObjectLockLegalHoldStatus status = hold ? ObjectLockLegalHoldStatus.ON : ObjectLockLegalHoldStatus.OFF;
                ObjectLockLegalHold legalHold = new ObjectLockLegalHold().withStatus(status);
                request = new SetObjectLegalHoldRequest();
                request.withBucketName(this.bucketName).withKey(bucketKey).withVersionId(versionId).withLegalHold(legalHold);
                this.logTrace("->", "setObjectLegalHold");
                this.logTrace("hnote right: " + bucketKey + "v=" + versionId);
                this.logTrace("rnote right: " + status.toString());
                this.amazonS3.setObjectLegalHold(request);
            }
        }
        catch (AmazonServiceException e) {
            if (S3BlobStore.isMissingKey(e)) {
                this.logTrace("<--", "missing");
                if (log.isDebugEnabled()) {
                    log.debug("Blob s3://" + this.bucketName + "/" + bucketKey + " does not exist");
                }
            }
            throw new IOException(e);
        }
    }

    public void deleteBlob(String key) {
        String versionId;
        String objectKey;
        int seppos = key.indexOf(64);
        if (seppos < 0) {
            objectKey = key;
            versionId = null;
        } else {
            objectKey = key.substring(0, seppos);
            versionId = key.substring(seppos + 1);
        }
        String bucketKey = this.bucketPrefix + objectKey;
        try {
            if (versionId == null) {
                this.logTrace("->", "deleteObject");
                this.logTrace("hnote right: " + bucketKey);
                this.amazonS3.deleteObject(this.bucketName, bucketKey);
            } else {
                this.logTrace("->", "deleteVersion");
                this.logTrace("hnote right: " + bucketKey + " v=" + versionId);
                this.amazonS3.deleteVersion(this.bucketName, bucketKey, versionId);
            }
        }
        catch (AmazonServiceException e) {
            if (S3BlobStore.isMissingKey(e)) {
                this.logTrace("<--", "missing");
            }
            log.warn((Object)e, (Throwable)e);
        }
    }

    public BinaryGarbageCollector getBinaryGarbageCollector() {
        return this.gc;
    }

    public class S3BlobGarbageCollector
    extends AbstractBlobGarbageCollector {
        public String getId() {
            return "s3:" + S3BlobStore.this.bucketName + "/" + S3BlobStore.this.bucketPrefix;
        }

        public Set<String> getUnmarkedBlobsAndUpdateStatus() {
            boolean useDeDuplication = S3BlobStore.this.keyStrategy.useDeDuplication();
            HashSet<String> unmarked = new HashSet<String>();
            ObjectListing list = null;
            int prefixLength = S3BlobStore.this.bucketPrefix.length();
            S3BlobStore.this.logTrace("->", "listObjects");
            do {
                if (list == null) {
                    ListObjectsRequest listObjectsRequest = new ListObjectsRequest(S3BlobStore.this.bucketName, S3BlobStore.this.bucketPrefix, null, "/", null);
                    list = S3BlobStore.this.amazonS3.listObjects(listObjectsRequest);
                } else {
                    list = S3BlobStore.this.amazonS3.listNextBatchOfObjects(list);
                }
                for (S3ObjectSummary summary : list.getObjectSummaries()) {
                    String key = summary.getKey().substring(prefixLength);
                    if (useDeDuplication && !S3BlobStore.this.config.digestConfiguration.isValidDigest(key)) continue;
                    long length = summary.getSize();
                    if (this.marked.contains(key)) {
                        ++this.status.numBinaries;
                        this.status.sizeBinaries += length;
                        continue;
                    }
                    ++this.status.numBinariesGC;
                    this.status.sizeBinariesGC += length;
                    unmarked.add(key);
                }
            } while (list.isTruncated());
            S3BlobStore.this.logTrace("<--", this.status.numBinaries + this.status.numBinariesGC + " objects");
            return unmarked;
        }

        public void removeBlobs(Set<String> keys) {
            keys.forEach(S3BlobStore.this::deleteBlob);
        }
    }
}

