/*
 * Decompiled with CFR 0.152.
 */
package edu.yale.its.tp.cas.client;

import edu.yale.its.tp.cas.util.SecureURL;
import java.io.IOException;
import java.io.StringReader;
import java.util.HashMap;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.nuxeo.common.utils.URIUtils;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class ServiceTicketValidator {
    protected String casValidateUrl;
    protected String proxyCallbackUrl;
    protected String st;
    protected String service;
    protected String pgtIou;
    protected String user;
    protected String errorCode;
    protected String errorMessage;
    protected String entireResponse;
    protected boolean renew = false;
    protected boolean attemptedAuthentication;
    protected boolean successfulAuthentication;

    public void setCasValidateUrl(String x) {
        this.casValidateUrl = x;
    }

    public String getCasValidateUrl() {
        return this.casValidateUrl;
    }

    public void setProxyCallbackUrl(String x) {
        this.proxyCallbackUrl = x;
    }

    public void setRenew(boolean b) {
        this.renew = b;
    }

    public String getProxyCallbackUrl() {
        return this.proxyCallbackUrl;
    }

    public void setServiceTicket(String x) {
        this.st = x;
    }

    public void setService(String x) {
        this.service = x;
    }

    public String getUser() {
        return this.user;
    }

    public String getPgtIou() {
        return this.pgtIou;
    }

    public boolean isAuthenticationSuccesful() {
        return this.successfulAuthentication;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public String getResponse() {
        return this.entireResponse;
    }

    public void validate() throws IOException, SAXException, ParserConfigurationException {
        String response;
        if (this.casValidateUrl == null || this.st == null) {
            throw new IllegalStateException("must set validation URL and ticket");
        }
        this.clear();
        this.attemptedAuthentication = true;
        HashMap<String, String> urlParameters = new HashMap<String, String>();
        urlParameters.put("service", this.service);
        urlParameters.put("ticket", this.st);
        if (this.proxyCallbackUrl != null) {
            urlParameters.put("pgtUrl", this.proxyCallbackUrl);
        }
        if (this.renew) {
            urlParameters.put("renew", "true");
        }
        String url = URIUtils.addParametersToURIQuery((String)this.casValidateUrl, urlParameters);
        this.entireResponse = response = SecureURL.retrieve(url, false);
        if (response != null) {
            XMLReader r = SAXParserFactory.newInstance().newSAXParser().getXMLReader();
            r.setFeature("http://xml.org/sax/features/namespaces", false);
            r.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            r.setContentHandler(this.newHandler());
            r.parse(new InputSource(new StringReader(response)));
        }
    }

    protected DefaultHandler newHandler() {
        return new Handler();
    }

    protected void clear() {
        this.errorMessage = null;
        this.pgtIou = null;
        this.user = null;
        this.attemptedAuthentication = false;
        this.successfulAuthentication = false;
    }

    protected class Handler
    extends DefaultHandler {
        protected static final String AUTHENTICATION_SUCCESS = "cas:authenticationSuccess";
        protected static final String AUTHENTICATION_FAILURE = "cas:authenticationFailure";
        protected static final String PROXY_GRANTING_TICKET = "cas:proxyGrantingTicket";
        protected static final String USER = "cas:user";
        protected StringBuilder currentText = new StringBuilder();
        protected boolean authenticationSuccess = false;
        protected boolean authenticationFailure = false;
        protected String netid;
        protected String pgtIou;
        protected String errorCode;
        protected String errorMessage;

        protected Handler() {
        }

        @Override
        public void startElement(String ns, String ln, String qn, Attributes a) {
            this.currentText = new StringBuilder();
            if (qn.equals(AUTHENTICATION_SUCCESS)) {
                this.authenticationSuccess = true;
            } else if (qn.equals(AUTHENTICATION_FAILURE)) {
                this.authenticationFailure = true;
                this.errorCode = a.getValue("code");
                if (this.errorCode != null) {
                    this.errorCode = this.errorCode.trim();
                }
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) {
            this.currentText.append(ch, start, length);
        }

        @Override
        public void endElement(String ns, String ln, String qn) throws SAXException {
            if (this.authenticationSuccess) {
                if (qn.equals(USER)) {
                    ServiceTicketValidator.this.user = this.currentText.toString().trim();
                }
                if (qn.equals(PROXY_GRANTING_TICKET)) {
                    this.pgtIou = this.currentText.toString().trim();
                }
            } else if (this.authenticationFailure && qn.equals(AUTHENTICATION_FAILURE)) {
                this.errorMessage = this.currentText.toString().trim();
            }
        }

        @Override
        public void endDocument() throws SAXException {
            if (this.authenticationSuccess) {
                ServiceTicketValidator.this.user = ServiceTicketValidator.this.user;
                ServiceTicketValidator.this.pgtIou = this.pgtIou;
                ServiceTicketValidator.this.successfulAuthentication = true;
            } else if (this.authenticationFailure) {
                ServiceTicketValidator.this.errorMessage = this.errorMessage;
                ServiceTicketValidator.this.errorCode = this.errorCode;
                ServiceTicketValidator.this.successfulAuthentication = false;
            } else {
                throw new SAXException("no indication of success of failure from CAS");
            }
        }
    }
}

