/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.auth.cas2;

import java.io.IOException;
import java.util.HashMap;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.URIUtils;
import org.nuxeo.ecm.platform.ui.web.auth.cas2.Cas2Authenticator;
import org.nuxeo.ecm.platform.ui.web.auth.interfaces.NuxeoAuthenticationPlugin;
import org.nuxeo.ecm.platform.ui.web.auth.plugins.AnonymousAuthenticator;
import org.nuxeo.ecm.platform.ui.web.auth.service.PluggableAuthenticationService;
import org.nuxeo.runtime.api.Framework;

public class AnonymousAuthenticatorForCAS2
extends AnonymousAuthenticator {
    protected static final Log log = LogFactory.getLog(AnonymousAuthenticatorForCAS2.class);
    protected Cas2Authenticator casAuthenticator;

    public Boolean handleLogout(HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        Cookie[] cookies;
        boolean isRedirectionToCas = false;
        for (Cookie cookie : cookies = httpRequest.getCookies()) {
            if (!"sso.initial.url.request".equals(cookie.getName())) continue;
            isRedirectionToCas = true;
            break;
        }
        if (isRedirectionToCas) {
            String authURL = this.getCas2Authenticator().getServiceURL(httpRequest, "Login");
            String appURL = this.getCas2Authenticator().getAppURL(httpRequest);
            try {
                HashMap<String, String> urlParameters = new HashMap<String, String>();
                urlParameters.put("service", appURL);
                String location = URIUtils.addParametersToURIQuery((String)authURL, urlParameters);
                httpResponse.sendRedirect(location);
                return true;
            }
            catch (IOException e) {
                log.error((Object)"Unable to redirect to CAS logout screen:", (Throwable)e);
                return false;
            }
        }
        return super.handleLogout(httpRequest, httpResponse);
    }

    public Cas2Authenticator getCas2Authenticator() {
        if (this.casAuthenticator != null) {
            return this.casAuthenticator;
        }
        PluggableAuthenticationService service = (PluggableAuthenticationService)Framework.getService(PluggableAuthenticationService.class);
        if (service == null) {
            log.error((Object)"Can't get PluggableAuthenticationService");
            return null;
        }
        NuxeoAuthenticationPlugin plugin = service.getPlugin("CAS2_AUTH");
        if (plugin == null) {
            log.error((Object)"Can't get Cas Authenticator from PluggableAuthenticationService");
        }
        this.casAuthenticator = (Cas2Authenticator)plugin;
        return this.casAuthenticator;
    }
}

