/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.drive.listener;

import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.SystemPrincipal;
import org.nuxeo.ecm.core.api.repository.RepositoryManager;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventBundle;
import org.nuxeo.ecm.core.event.EventContext;
import org.nuxeo.ecm.core.event.EventService;
import org.nuxeo.ecm.core.event.PostCommitFilteringEventListener;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.core.query.sql.NXQL;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.api.login.LoginComponent;

public class NuxeoDriveGroupUpdateListener
implements PostCommitFilteringEventListener {
    protected static final Logger log = LogManager.getLogger(NuxeoDriveGroupUpdateListener.class);

    public boolean acceptEvent(Event event) {
        return event.getContext() != null && "userGroup".equals(event.getContext().getProperty("category"));
    }

    public void handleEvent(EventBundle events) {
        for (Event event : events) {
            String groupName;
            EventContext context = event.getContext();
            if (context == null || (groupName = (String)((Object)context.getProperty("id"))) == null) continue;
            Supplier[] supplierArray = new Supplier[2];
            supplierArray[0] = () -> ((Event)event).getName();
            supplierArray[1] = () -> groupName;
            log.debug("NuxeoDriveGroupUpdateListener handling {} event for group {}", supplierArray);
            List<String> groupNames = this.getAllGroupNames(groupName, context);
            this.handleUpdatedGroups(groupNames);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<String> getAllGroupNames(String groupName, EventContext context) {
        ArrayList<String> groupNames = new ArrayList<String>();
        groupNames.add(groupName);
        LoginComponent.pushPrincipal((Principal)new SystemPrincipal(null));
        try {
            List ancestorGroups = (List)((Object)context.getProperty("ancestorGroups"));
            if (ancestorGroups != null) {
                groupNames.addAll(ancestorGroups);
            } else {
                groupNames.addAll(((UserManager)Framework.getService(UserManager.class)).getAncestorGroups(groupName));
            }
        }
        finally {
            LoginComponent.popPrincipal();
        }
        return groupNames;
    }

    protected void handleUpdatedGroups(List<String> groupNames) {
        RepositoryManager repositoryManager = (RepositoryManager)Framework.getService(RepositoryManager.class);
        for (String repositoryName : repositoryManager.getRepositoryNames()) {
            CoreInstance.doPrivileged((String)repositoryName, session -> {
                DocumentModelList impactedDocuments = this.getImpactedDocuments((CoreSession)session, groupNames);
                impactedDocuments.forEach(doc -> this.fireGroupUpdatedEvent((CoreSession)session, (DocumentModel)doc));
            });
        }
    }

    protected DocumentModelList getImpactedDocuments(CoreSession session, List<String> groupNames) {
        String groups = groupNames.stream().map(NXQL::escapeString).collect(Collectors.joining(","));
        String query = "SELECT * FROM Document WHERE ecm:isTrashed = 0 AND ecm:isVersion = 0 AND ecm:acl/*/principal IN (" + groups + ")";
        return session.query(query);
    }

    protected void fireGroupUpdatedEvent(CoreSession session, DocumentModel source) {
        DocumentEventContext context = new DocumentEventContext(session, session.getPrincipal(), source);
        Event event = context.newEvent("groupUpdated");
        ((EventService)Framework.getService(EventService.class)).fireEvent(event);
    }
}

