/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.drive.service.impl;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.SerializationUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.nuxeo.drive.service.impl.ActiveFileSystemItemFactoriesDescriptor;
import org.nuxeo.drive.service.impl.ActiveFileSystemItemFactoryDescriptor;
import org.nuxeo.runtime.model.ContributionFragmentRegistry;

public class ActiveFileSystemItemFactoryRegistry
extends ContributionFragmentRegistry<ActiveFileSystemItemFactoriesDescriptor> {
    private static final Logger log = LogManager.getLogger(ActiveFileSystemItemFactoryRegistry.class);
    protected static final String CONTRIBUTION_ID = "activeFileSystemItemFactoriesContrib";
    protected Set<String> activeFactories = new HashSet<String>();

    public String getContributionId(ActiveFileSystemItemFactoriesDescriptor contrib) {
        return CONTRIBUTION_ID;
    }

    public void contributionUpdated(String id, ActiveFileSystemItemFactoriesDescriptor contrib, ActiveFileSystemItemFactoriesDescriptor newOrigContrib) {
        log.trace("Updating activeFileSystemItemFactories contribution {}.", (Object)contrib);
        if (contrib.isMerge()) {
            for (ActiveFileSystemItemFactoryDescriptor factory : contrib.getFactories()) {
                if (this.activeFactories.contains(factory.getName()) && !factory.isEnabled()) {
                    Supplier[] supplierArray = new Supplier[1];
                    supplierArray[0] = factory::getName;
                    log.trace("Removing factory {} from active factories.", supplierArray);
                    this.activeFactories.remove(factory.getName());
                }
                if (this.activeFactories.contains(factory.getName()) || !factory.isEnabled()) continue;
                Supplier[] supplierArray = new Supplier[1];
                supplierArray[0] = factory::getName;
                log.trace("Adding factory {} to active factories.", supplierArray);
                this.activeFactories.add(factory.getName());
            }
        } else {
            log.trace("Clearing active factories as contribution {} doesn't merge.", (Object)contrib);
            this.activeFactories.clear();
            for (ActiveFileSystemItemFactoryDescriptor factory : contrib.getFactories()) {
                if (!factory.isEnabled()) continue;
                Supplier[] supplierArray = new Supplier[1];
                supplierArray[0] = factory::getName;
                log.trace("Adding factory {} to active factories.", supplierArray);
                this.activeFactories.add(factory.getName());
            }
        }
    }

    public void contributionRemoved(String id, ActiveFileSystemItemFactoriesDescriptor origContrib) {
        log.trace("Clearing active factories.");
        this.activeFactories.clear();
    }

    public ActiveFileSystemItemFactoriesDescriptor clone(ActiveFileSystemItemFactoriesDescriptor orig) {
        log.trace("Cloning contribution {}.", (Object)orig);
        return (ActiveFileSystemItemFactoriesDescriptor)SerializationUtils.clone((Serializable)orig);
    }

    public void merge(ActiveFileSystemItemFactoriesDescriptor src, ActiveFileSystemItemFactoriesDescriptor dst) {
        log.trace("Merging contribution {} to contribution {}.", (Object)src, (Object)dst);
        if (src.isMerge() != dst.isMerge()) {
            dst.setMerge(src.isMerge());
        }
        for (ActiveFileSystemItemFactoryDescriptor factory : src.getFactories()) {
            int indexOfFactory = dst.getFactories().indexOf(factory);
            if (indexOfFactory > -1) {
                dst.getFactories().get(indexOfFactory).setEnabled(factory.isEnabled());
                continue;
            }
            dst.getFactories().add(factory);
        }
    }
}

