/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.drive.service.impl;

import org.apache.commons.collections.MapUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.drive.service.FileSystemChangeFinder;
import org.nuxeo.drive.service.impl.ChangeFinderDescriptor;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.runtime.model.ContributionFragmentRegistry;

public class ChangeFinderRegistry
extends ContributionFragmentRegistry<ChangeFinderDescriptor> {
    private static final Logger log = LogManager.getLogger(ChangeFinderRegistry.class);
    protected static final String CONTRIBUTION_ID = "changeFinderContrib";
    protected FileSystemChangeFinder changeFinder;

    public String getContributionId(ChangeFinderDescriptor contrib) {
        return CONTRIBUTION_ID;
    }

    public void contributionUpdated(String id, ChangeFinderDescriptor contrib, ChangeFinderDescriptor newOrigContrib) {
        try {
            log.trace("Updating change finder contribution {}.", (Object)contrib);
            this.changeFinder = contrib.getChangeFinder();
        }
        catch (ReflectiveOperationException e) {
            throw new NuxeoException("Cannot update changeFinder contribution.", (Throwable)e);
        }
    }

    public void contributionRemoved(String id, ChangeFinderDescriptor origContrib) {
        log.trace("Clearing change finder.");
        this.changeFinder = null;
    }

    public ChangeFinderDescriptor clone(ChangeFinderDescriptor orig) {
        log.trace("Cloning contribution {}.", (Object)orig);
        ChangeFinderDescriptor clone = new ChangeFinderDescriptor();
        clone.changeFinderClass = orig.changeFinderClass;
        clone.parameters = orig.parameters;
        return clone;
    }

    public void merge(ChangeFinderDescriptor src, ChangeFinderDescriptor dst) {
        log.trace("Merging contribution {} to contribution {}.", (Object)src, (Object)dst);
        if (src.getChangeFinderClass() != null && !src.getChangeFinderClass().equals(dst.getChangeFinderClass())) {
            dst.setChangeFinderClass(src.getChangeFinderClass());
        }
        if (!MapUtils.isEmpty(src.getParameters())) {
            for (String name : src.getParameters().keySet()) {
                dst.setParameter(name, src.getparameter(name));
            }
        }
    }
}

