/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.drive.service.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.SerializationUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.nuxeo.drive.service.impl.FileSystemItemFactoryDescriptor;
import org.nuxeo.drive.service.impl.FileSystemItemFactoryWrapper;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.runtime.model.ContributionFragmentRegistry;

public class FileSystemItemFactoryRegistry
extends ContributionFragmentRegistry<FileSystemItemFactoryDescriptor> {
    private static final Logger log = LogManager.getLogger(FileSystemItemFactoryRegistry.class);
    protected final Map<String, FileSystemItemFactoryDescriptor> factoryDescriptors = new HashMap<String, FileSystemItemFactoryDescriptor>();

    public String getContributionId(FileSystemItemFactoryDescriptor contrib) {
        String name = contrib.getName();
        if (StringUtils.isEmpty((CharSequence)name)) {
            throw new NuxeoException("Cannot register fileSystemItemFactory without a name.");
        }
        return name;
    }

    public void contributionUpdated(String id, FileSystemItemFactoryDescriptor contrib, FileSystemItemFactoryDescriptor newOrigContrib) {
        log.trace("Putting contribution {} with id {} in factory registry", (Object)contrib, (Object)id);
        this.factoryDescriptors.put(id, contrib);
    }

    public void contributionRemoved(String id, FileSystemItemFactoryDescriptor origContrib) {
        log.trace("Removing contribution with id {} from factory registry", (Object)id);
        this.factoryDescriptors.remove(id);
    }

    public FileSystemItemFactoryDescriptor clone(FileSystemItemFactoryDescriptor orig) {
        Supplier[] supplierArray = new Supplier[1];
        supplierArray[0] = orig::getName;
        log.trace("Cloning contribution with id {}", supplierArray);
        return (FileSystemItemFactoryDescriptor)SerializationUtils.clone((Serializable)orig);
    }

    public void merge(FileSystemItemFactoryDescriptor src, FileSystemItemFactoryDescriptor dst) {
        Supplier[] supplierArray = new Supplier[2];
        supplierArray[0] = src::getName;
        supplierArray[1] = dst::getName;
        log.trace("Merging contribution with id {} to contribution with id {}", supplierArray);
        int srcOrder = src.getOrder();
        if (srcOrder > 0 && srcOrder != dst.getOrder()) {
            dst.setOrder(srcOrder);
        }
        if (!StringUtils.isEmpty((CharSequence)src.getDocType()) && !src.getDocType().equals(dst.getDocType())) {
            dst.setDocType(src.getDocType());
        }
        if (!StringUtils.isEmpty((CharSequence)src.getFacet()) && !src.getFacet().equals(dst.getFacet())) {
            dst.setFacet(src.getFacet());
        }
        if (src.getFactoryClass() != null && !src.getFactoryClass().equals(dst.getFactoryClass())) {
            dst.setFactoryClass(src.getFactoryClass());
        }
        if (!MapUtils.isEmpty(src.getParameters())) {
            for (String name : src.getParameters().keySet()) {
                dst.setParameter(name, src.getParameter(name));
            }
        }
    }

    protected List<FileSystemItemFactoryWrapper> getOrderedActiveFactories(Set<String> activeFactories) {
        ArrayList<FileSystemItemFactoryWrapper> factories = new ArrayList<FileSystemItemFactoryWrapper>();
        ArrayList<FileSystemItemFactoryDescriptor> orderedFactoryDescriptors = new ArrayList<FileSystemItemFactoryDescriptor>(this.factoryDescriptors.values());
        Collections.sort(orderedFactoryDescriptors);
        for (FileSystemItemFactoryDescriptor factoryDesc : orderedFactoryDescriptors) {
            if (!activeFactories.contains(factoryDesc.getName())) continue;
            FileSystemItemFactoryWrapper factoryWrapper = new FileSystemItemFactoryWrapper(factoryDesc.getDocType(), factoryDesc.getFacet(), factoryDesc.getFactory());
            factories.add(factoryWrapper);
        }
        return factories;
    }
}

