/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.drive.service.impl;

import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.drive.adapter.FileItem;
import org.nuxeo.drive.adapter.FileSystemItem;
import org.nuxeo.drive.adapter.FolderItem;
import org.nuxeo.drive.adapter.RootlessItemException;
import org.nuxeo.drive.adapter.ScrollFileSystemItemList;
import org.nuxeo.drive.service.FileSystemItemAdapterService;
import org.nuxeo.drive.service.FileSystemItemManager;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.runtime.api.Framework;

public class FileSystemItemManagerImpl
implements FileSystemItemManager {
    private static final Logger log = LogManager.getLogger(FileSystemItemManagerImpl.class);

    @Override
    public FolderItem getTopLevelFolder(NuxeoPrincipal principal) {
        return this.getFileSystemItemAdapterService().getTopLevelFolderItemFactory().getTopLevelFolderItem(principal);
    }

    @Override
    public boolean exists(String id, NuxeoPrincipal principal) {
        return this.getFileSystemItemAdapterService().getFileSystemItemFactoryForId(id).exists(id, principal);
    }

    @Override
    public FileSystemItem getFileSystemItemById(String id, NuxeoPrincipal principal) {
        try {
            return this.getFileSystemItemAdapterService().getFileSystemItemFactoryForId(id).getFileSystemItemById(id, principal);
        }
        catch (RootlessItemException e) {
            log.debug("RootlessItemException thrown while trying to get file system item with id {}, returning null.", (Object)id);
            return null;
        }
    }

    @Override
    public FileSystemItem getFileSystemItemById(String id, String parentId, NuxeoPrincipal principal) {
        try {
            return this.getFileSystemItemAdapterService().getFileSystemItemFactoryForId(id).getFileSystemItemById(id, parentId, principal);
        }
        catch (RootlessItemException e) {
            log.debug("RootlessItemException thrown while trying to get file system item with id {} and parent id {}, returning null.", (Object)id, (Object)parentId);
            return null;
        }
    }

    @Override
    public List<FileSystemItem> getChildren(String id, NuxeoPrincipal principal) {
        FileSystemItem fileSystemItem = this.getFileSystemItemById(id, principal);
        if (fileSystemItem == null) {
            throw new NuxeoException(String.format("Cannot get the children of file system item with id %s because it doesn't exist.", id));
        }
        if (!(fileSystemItem instanceof FolderItem)) {
            throw new NuxeoException(String.format("Cannot get the children of file system item with id %s because it is not a folder.", id));
        }
        FolderItem folderItem = (FolderItem)fileSystemItem;
        return folderItem.getChildren();
    }

    @Override
    public ScrollFileSystemItemList scrollDescendants(String id, NuxeoPrincipal principal, String scrollId, int batchSize, long keepAlive) {
        FileSystemItem fileSystemItem = this.getFileSystemItemById(id, principal);
        if (fileSystemItem == null) {
            throw new NuxeoException(String.format("Cannot get the descendants of file system item with id %s because it doesn't exist.", id));
        }
        if (!(fileSystemItem instanceof FolderItem)) {
            throw new NuxeoException(String.format("Cannot get the descendants of file system item with id %s because it is not a folder.", id));
        }
        FolderItem folderItem = (FolderItem)fileSystemItem;
        return folderItem.scrollDescendants(scrollId, batchSize, keepAlive);
    }

    @Override
    public boolean canMove(String srcId, String destId, NuxeoPrincipal principal) {
        FileSystemItem srcFsItem = this.getFileSystemItemById(srcId, principal);
        if (srcFsItem == null) {
            return false;
        }
        FileSystemItem destFsItem = this.getFileSystemItemById(destId, principal);
        if (!(destFsItem instanceof FolderItem)) {
            return false;
        }
        return srcFsItem.canMove((FolderItem)destFsItem);
    }

    @Override
    public FolderItem createFolder(String parentId, String name, NuxeoPrincipal principal, boolean overwrite) {
        FileSystemItem parentFsItem = this.getFileSystemItemById(parentId, principal);
        if (parentFsItem == null) {
            throw new NuxeoException(String.format("Cannot create a folder in file system item with id %s because it doesn't exist.", parentId));
        }
        if (!(parentFsItem instanceof FolderItem)) {
            throw new NuxeoException(String.format("Cannot create a folder in file system item with id %s because it is not a folder but is: %s", parentId, parentFsItem));
        }
        FolderItem parentFolder = (FolderItem)parentFsItem;
        return parentFolder.createFolder(name, overwrite);
    }

    @Override
    public FileItem createFile(String parentId, Blob blob, NuxeoPrincipal principal, boolean overwrite) {
        FileSystemItem parentFsItem = this.getFileSystemItemById(parentId, principal);
        if (parentFsItem == null) {
            throw new NuxeoException(String.format("Cannot create a file in file system item with id %s because it doesn't exist.", parentId));
        }
        if (!(parentFsItem instanceof FolderItem)) {
            throw new NuxeoException(String.format("Cannot create a file in file system item with id %s because it is not a folder but is: %s", parentId, parentFsItem));
        }
        FolderItem parentFolder = (FolderItem)parentFsItem;
        return parentFolder.createFile(blob, overwrite);
    }

    @Override
    public FileItem updateFile(String id, Blob blob, NuxeoPrincipal principal) {
        FileSystemItem fsItem = this.getFileSystemItemById(id, principal);
        return this.updateFile(fsItem, blob);
    }

    @Override
    public FileItem updateFile(String id, String parentId, Blob blob, NuxeoPrincipal principal) {
        FileSystemItem fsItem = this.getFileSystemItemById(id, parentId, principal);
        return this.updateFile(fsItem, blob);
    }

    @Override
    public void delete(String id, NuxeoPrincipal principal) {
        FileSystemItem fsItem = this.getFileSystemItemById(id, principal);
        this.delete(fsItem);
    }

    @Override
    public void delete(String id, String parentId, NuxeoPrincipal principal) {
        FileSystemItem fsItem = this.getFileSystemItemById(id, parentId, principal);
        this.delete(fsItem);
    }

    @Override
    public FileSystemItem rename(String id, String name, NuxeoPrincipal principal) {
        FileSystemItem fsItem = this.getFileSystemItemById(id, principal);
        if (fsItem == null) {
            throw new NuxeoException(String.format("Cannot rename file system item with id %s because it doesn't exist.", id));
        }
        fsItem.rename(name);
        return fsItem;
    }

    @Override
    public FileSystemItem move(String srcId, String destId, NuxeoPrincipal principal) {
        FileSystemItem srcFsItem = this.getFileSystemItemById(srcId, principal);
        if (srcFsItem == null) {
            throw new NuxeoException(String.format("Cannot move file system item with id %s because it doesn't exist.", srcId));
        }
        FileSystemItem destFsItem = this.getFileSystemItemById(destId, principal);
        if (destFsItem == null) {
            throw new NuxeoException(String.format("Cannot move a file system item to file system item with id %s because it doesn't exist.", destId));
        }
        if (!(destFsItem instanceof FolderItem)) {
            throw new NuxeoException(String.format("Cannot move a file system item to file system item with id %s because it is not a folder.", destId));
        }
        return srcFsItem.move((FolderItem)destFsItem);
    }

    protected FileSystemItemAdapterService getFileSystemItemAdapterService() {
        return (FileSystemItemAdapterService)Framework.getService(FileSystemItemAdapterService.class);
    }

    protected FileItem updateFile(FileSystemItem fsItem, Blob blob) {
        if (fsItem == null) {
            throw new NuxeoException("Cannot update the content of file system item because it doesn't exist.");
        }
        if (!(fsItem instanceof FileItem)) {
            throw new NuxeoException(String.format("Cannot update the content of file system item with id %s because it is not a file.", fsItem.getId()));
        }
        FileItem file = (FileItem)fsItem;
        file.setBlob(blob);
        return file;
    }

    protected void delete(FileSystemItem fsItem) {
        if (fsItem == null) {
            throw new NuxeoException("Cannot delete file system item because it doesn't exist.");
        }
        fsItem.delete();
    }
}

