/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.drive.service.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeSet;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.nuxeo.common.utils.Path;
import org.nuxeo.drive.service.FileSystemChangeFinder;
import org.nuxeo.drive.service.FileSystemChangeSummary;
import org.nuxeo.drive.service.FileSystemItemChange;
import org.nuxeo.drive.service.NuxeoDriveManager;
import org.nuxeo.drive.service.SynchronizationRoots;
import org.nuxeo.drive.service.TooManyChangesException;
import org.nuxeo.drive.service.impl.ChangeFinderDescriptor;
import org.nuxeo.drive.service.impl.ChangeFinderRegistry;
import org.nuxeo.drive.service.impl.FileSystemChangeSummaryImpl;
import org.nuxeo.ecm.collections.api.CollectionManager;
import org.nuxeo.ecm.core.api.CloseableCoreSession;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentNotFoundException;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.DocumentSecurityException;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.IterableQueryResult;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.ecm.core.api.repository.RepositoryManager;
import org.nuxeo.ecm.core.cache.Cache;
import org.nuxeo.ecm.core.cache.CacheService;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventService;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.platform.query.api.PageProvider;
import org.nuxeo.ecm.platform.query.api.PageProviderService;
import org.nuxeo.ecm.platform.query.nxql.NXQLQueryBuilder;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;

public class NuxeoDriveManagerImpl
extends DefaultComponent
implements NuxeoDriveManager {
    private static final Logger log = LogManager.getLogger(NuxeoDriveManagerImpl.class);
    public static final String CHANGE_FINDER_EP = "changeFinder";
    public static final String NUXEO_DRIVE_FACET = "DriveSynchronized";
    public static final String DRIVE_SUBSCRIPTIONS_PROPERTY = "drv:subscriptions";
    public static final String DOCUMENT_CHANGE_LIMIT_PROPERTY = "org.nuxeo.drive.document.change.limit";
    public static final TimeZone UTC = TimeZone.getTimeZone("UTC");
    public static final String DRIVE_SYNC_ROOT_CACHE = "driveSyncRoot";
    public static final String DRIVE_COLLECTION_SYNC_ROOT_MEMBER_CACHE = "driveCollectionSyncRootMember";
    public static final String LOCALLY_EDITED_COLLECTION_NAME = "Locally Edited";
    protected static final long COLLECTION_CONTENT_PAGE_SIZE = 1000L;
    protected Cache syncRootCache;
    protected Cache collectionSyncRootMemberCache;
    protected ChangeFinderRegistry changeFinderRegistry;
    protected FileSystemChangeFinder changeFinder;

    protected Cache getSyncRootCache() {
        return this.syncRootCache;
    }

    protected Cache getCollectionSyncRootMemberCache() {
        return this.collectionSyncRootMemberCache;
    }

    protected void clearCache() {
        log.debug("Invalidating synchronization root cache and collection sync root member cache for all users");
        this.syncRootCache.invalidateAll();
        this.collectionSyncRootMemberCache.invalidateAll();
    }

    @Override
    public void invalidateSynchronizationRootsCache(String userName) {
        log.debug("Invalidating synchronization root cache for user: {}", (Object)userName);
        this.getSyncRootCache().invalidate(userName);
    }

    @Override
    public void invalidateCollectionSyncRootMemberCache(String userName) {
        log.debug("Invalidating collection sync root member cache for user: {}", (Object)userName);
        this.getCollectionSyncRootMemberCache().invalidate(userName);
    }

    @Override
    public void invalidateCollectionSyncRootMemberCache() {
        log.debug("Invalidating collection sync root member cache for all users");
        this.getCollectionSyncRootMemberCache().invalidateAll();
    }

    @Override
    public void registerSynchronizationRoot(NuxeoPrincipal principal, final DocumentModel newRootContainer, CoreSession session) {
        final String userName = principal.getName();
        log.debug("Registering synchronization root {} for {}", (Object)newRootContainer, (Object)userName);
        Map<String, SynchronizationRoots> syncRoots = this.getSynchronizationRoots(principal);
        SynchronizationRoots synchronizationRoots = syncRoots.get(session.getRepositoryName());
        if (!LOCALLY_EDITED_COLLECTION_NAME.equals(newRootContainer.getName())) {
            for (String string : synchronizationRoots.getPaths()) {
                String parentPathAsString;
                String syncRootPrefixedPath = string + "/";
                if (!newRootContainer.getPathAsString().startsWith(syncRootPrefixedPath)) continue;
                boolean rightInheritanceBlockedInTheHierarchy = false;
                Path parentPath = newRootContainer.getPath().removeLastSegments(1);
                while (!"/".equals(parentPath.toString()) && (parentPathAsString = parentPath.toString() + "/").startsWith(syncRootPrefixedPath)) {
                    PathRef parentRef = new PathRef(parentPathAsString);
                    if (!session.hasPermission(principal, (DocumentRef)parentRef, "Read")) {
                        rightInheritanceBlockedInTheHierarchy = true;
                        break;
                    }
                    parentPath = parentPath.removeLastSegments(1);
                }
                if (rightInheritanceBlockedInTheHierarchy) continue;
                return;
            }
        }
        this.checkCanUpdateSynchronizationRoot(newRootContainer);
        String newRootPrefixedPath = newRootContainer.getPathAsString() + "/";
        for (String existingRootPath : synchronizationRoots.getPaths()) {
            PathRef ref;
            if (existingRootPath.endsWith(LOCALLY_EDITED_COLLECTION_NAME) || !existingRootPath.startsWith(newRootPrefixedPath) || !session.exists((DocumentRef)(ref = new PathRef(existingRootPath)))) continue;
            DocumentModel subFolder = session.getDocument((DocumentRef)ref);
            this.unregisterSynchronizationRoot(principal, subFolder, session);
        }
        UnrestrictedSessionRunner unrestrictedSessionRunner = new UnrestrictedSessionRunner(session){

            public void run() {
                if (!newRootContainer.hasFacet(NuxeoDriveManagerImpl.NUXEO_DRIVE_FACET)) {
                    newRootContainer.addFacet(NuxeoDriveManagerImpl.NUXEO_DRIVE_FACET);
                }
                NuxeoDriveManagerImpl.this.fireEvent(newRootContainer, this.session, "aboutToRegisterRoot", userName);
                List subscriptions = (List)((Object)newRootContainer.getPropertyValue(NuxeoDriveManagerImpl.DRIVE_SUBSCRIPTIONS_PROPERTY));
                boolean updated = false;
                for (Map subscription : subscriptions) {
                    if (!userName.equals(subscription.get("username"))) continue;
                    subscription.put("enabled", Boolean.TRUE);
                    subscription.put("lastChangeDate", Calendar.getInstance(UTC));
                    updated = true;
                    break;
                }
                if (!updated) {
                    HashMap<String, Object> subscription = new HashMap<String, Object>();
                    subscription.put("username", userName);
                    subscription.put("enabled", Boolean.TRUE);
                    subscription.put("lastChangeDate", Calendar.getInstance(UTC));
                    subscriptions.add(subscription);
                }
                newRootContainer.setPropertyValue(NuxeoDriveManagerImpl.DRIVE_SUBSCRIPTIONS_PROPERTY, (Serializable)((Object)subscriptions));
                newRootContainer.putContextData("disableAuditLogger", (Serializable)Boolean.valueOf(true));
                newRootContainer.putContextData("disableNotificationService", (Serializable)Boolean.valueOf(true));
                newRootContainer.putContextData("source", (Serializable)((Object)"drive"));
                DocumentModel savedNewRootContainer = this.session.saveDocument(newRootContainer);
                newRootContainer.putContextData("disableAuditLogger", (Serializable)Boolean.valueOf(false));
                newRootContainer.putContextData("disableNotificationService", (Serializable)Boolean.valueOf(false));
                NuxeoDriveManagerImpl.this.fireEvent(savedNewRootContainer, this.session, "rootRegistered", userName);
                this.session.save();
            }
        };
        unrestrictedSessionRunner.runUnrestricted();
        this.invalidateSynchronizationRootsCache(userName);
        this.invalidateCollectionSyncRootMemberCache(userName);
    }

    @Override
    public void unregisterSynchronizationRoot(NuxeoPrincipal principal, final DocumentModel rootContainer, CoreSession session) {
        final String userName = principal.getName();
        log.debug("Unregistering synchronization root {} for {}", (Object)rootContainer, (Object)userName);
        this.checkCanUpdateSynchronizationRoot(rootContainer);
        UnrestrictedSessionRunner runner = new UnrestrictedSessionRunner(session){

            public void run() {
                if (!rootContainer.hasFacet(NuxeoDriveManagerImpl.NUXEO_DRIVE_FACET)) {
                    rootContainer.addFacet(NuxeoDriveManagerImpl.NUXEO_DRIVE_FACET);
                }
                NuxeoDriveManagerImpl.this.fireEvent(rootContainer, this.session, "aboutToUnregisterRoot", userName);
                List subscriptions = (List)((Object)rootContainer.getPropertyValue(NuxeoDriveManagerImpl.DRIVE_SUBSCRIPTIONS_PROPERTY));
                for (Map subscription : subscriptions) {
                    if (!userName.equals(subscription.get("username"))) continue;
                    subscription.put("enabled", Boolean.FALSE);
                    subscription.put("lastChangeDate", Calendar.getInstance(UTC));
                    break;
                }
                rootContainer.setPropertyValue(NuxeoDriveManagerImpl.DRIVE_SUBSCRIPTIONS_PROPERTY, (Serializable)((Object)subscriptions));
                rootContainer.putContextData("disableAuditLogger", (Serializable)Boolean.valueOf(true));
                rootContainer.putContextData("disableNotificationService", (Serializable)Boolean.valueOf(true));
                rootContainer.putContextData("source", (Serializable)((Object)"drive"));
                this.session.saveDocument(rootContainer);
                rootContainer.putContextData("disableAuditLogger", (Serializable)Boolean.valueOf(false));
                rootContainer.putContextData("disableNotificationService", (Serializable)Boolean.valueOf(false));
                NuxeoDriveManagerImpl.this.fireEvent(rootContainer, this.session, "rootUnregistered", userName);
                this.session.save();
            }
        };
        runner.runUnrestricted();
        this.invalidateSynchronizationRootsCache(userName);
        this.invalidateCollectionSyncRootMemberCache(userName);
    }

    @Override
    public Set<IdRef> getSynchronizationRootReferences(CoreSession session) {
        Map<String, SynchronizationRoots> syncRoots = this.getSynchronizationRoots(session.getPrincipal());
        return syncRoots.get(session.getRepositoryName()).getRefs();
    }

    @Override
    public void handleFolderDeletion(IdRef deleted) {
        this.clearCache();
    }

    protected void fireEvent(DocumentModel sourceDocument, CoreSession session, String eventName, String impactedUserName) {
        EventService eventService = (EventService)Framework.getService(EventService.class);
        DocumentEventContext ctx = new DocumentEventContext(session, session.getPrincipal(), sourceDocument);
        ctx.setProperty("repositoryName", (Serializable)((Object)session.getRepositoryName()));
        ctx.setProperty("sessionId", (Serializable)((Object)session.getSessionId()));
        ctx.setProperty("category", (Serializable)((Object)"NuxeoDrive"));
        ctx.setProperty("impactedUserName", (Serializable)((Object)impactedUserName));
        Event event = ctx.newEvent(eventName);
        eventService.fireEvent(event);
    }

    @Override
    public FileSystemChangeSummary getChangeSummary(NuxeoPrincipal principal, Map<String, Set<IdRef>> lastSyncRootRefs, long lowerBound) {
        Map<String, SynchronizationRoots> roots = this.getSynchronizationRoots(principal);
        Map<String, Set<String>> collectionSyncRootMemberIds = this.getCollectionSyncRootMemberIds(principal);
        ArrayList<FileSystemItemChange> allChanges = new ArrayList<FileSystemItemChange>();
        TreeSet<String> allRepositories = new TreeSet<String>();
        allRepositories.addAll(roots.keySet());
        allRepositories.addAll(lastSyncRootRefs.keySet());
        allRepositories.addAll(collectionSyncRootMemberIds.keySet());
        long upperBound = this.changeFinder.getUpperBound(allRepositories);
        long syncDate = System.currentTimeMillis();
        syncDate -= syncDate % 1000L;
        Boolean hasTooManyChanges = Boolean.FALSE;
        int limit = Integer.parseInt(Framework.getProperty((String)DOCUMENT_CHANGE_LIMIT_PROPERTY, (String)"1000"));
        if (!allRepositories.isEmpty() && lowerBound >= 0L && upperBound > lowerBound) {
            for (String string : allRepositories) {
                try {
                    CloseableCoreSession session = CoreInstance.openCoreSession((String)string, (NuxeoPrincipal)principal);
                    try {
                        Set<String> repoCollectionSyncRootMemberIds;
                        SynchronizationRoots activeRoots;
                        Set<Object> lastRefs = lastSyncRootRefs.get(string);
                        if (lastRefs == null) {
                            lastRefs = Collections.emptySet();
                        }
                        if ((activeRoots = roots.get(string)) == null) {
                            activeRoots = SynchronizationRoots.getEmptyRoots(string);
                        }
                        if ((repoCollectionSyncRootMemberIds = collectionSyncRootMemberIds.get(string)) == null) {
                            repoCollectionSyncRootMemberIds = Collections.emptySet();
                        }
                        Supplier[] supplierArray = new Supplier[5];
                        supplierArray[0] = () -> string;
                        supplierArray[1] = () -> principal.getName();
                        supplierArray[2] = () -> lowerBound;
                        supplierArray[3] = () -> upperBound;
                        supplierArray[4] = activeRoots::getPaths;
                        log.debug("Start: getting FileSystemItem changes for repository {} / user {} between {} and {} with activeRoots = {}", supplierArray);
                        List<FileSystemItemChange> changes = this.changeFinder.getFileSystemChanges((CoreSession)session, lastRefs, activeRoots, repoCollectionSyncRootMemberIds, lowerBound, upperBound, limit);
                        allChanges.addAll(changes);
                    }
                    finally {
                        if (session == null) continue;
                        session.close();
                    }
                }
                catch (TooManyChangesException e) {
                    hasTooManyChanges = Boolean.TRUE;
                    allChanges.clear();
                    break;
                }
            }
        }
        HashMap<String, Set<IdRef>> activeRootRefs = new HashMap<String, Set<IdRef>>();
        for (Map.Entry<String, SynchronizationRoots> rootsEntry : roots.entrySet()) {
            activeRootRefs.put(rootsEntry.getKey(), rootsEntry.getValue().getRefs());
        }
        FileSystemChangeSummaryImpl fileSystemChangeSummaryImpl = new FileSystemChangeSummaryImpl(allChanges, activeRootRefs, syncDate, upperBound, hasTooManyChanges);
        Supplier[] supplierArray = new Supplier[6];
        supplierArray[0] = allChanges::size;
        supplierArray[1] = () -> principal.getName();
        supplierArray[2] = () -> lowerBound;
        supplierArray[3] = () -> upperBound;
        supplierArray[4] = () -> roots;
        supplierArray[5] = () -> summary;
        log.debug("End: getting {} FileSystemItem changes for user {} between {} and {} with activeRoots = {} -> {}", supplierArray);
        return fileSystemChangeSummaryImpl;
    }

    @Override
    public Map<String, SynchronizationRoots> getSynchronizationRoots(NuxeoPrincipal principal) {
        String userName = principal.getName();
        Map<String, SynchronizationRoots> syncRoots = (Map<String, SynchronizationRoots>)((Object)this.getSyncRootCache().get(userName));
        if (syncRoots == null) {
            syncRoots = this.computeSynchronizationRoots(this.computeSyncRootsQuery(userName), principal);
            this.getSyncRootCache().put(userName, (Serializable)((Object)syncRoots));
        }
        return syncRoots;
    }

    @Override
    public Map<String, Set<String>> getCollectionSyncRootMemberIds(NuxeoPrincipal principal) {
        String userName = principal.getName();
        Map<String, Set<String>> collSyncRootMemberIds = (Map<String, Set<String>>)((Object)this.getCollectionSyncRootMemberCache().get(userName));
        if (collSyncRootMemberIds == null) {
            collSyncRootMemberIds = this.computeCollectionSyncRootMemberIds(principal);
            this.getCollectionSyncRootMemberCache().put(userName, (Serializable)((Object)collSyncRootMemberIds));
        }
        return collSyncRootMemberIds;
    }

    @Override
    public boolean isSynchronizationRoot(NuxeoPrincipal principal, DocumentModel doc) {
        String repoName = doc.getRepositoryName();
        SynchronizationRoots syncRoots = this.getSynchronizationRoots(principal).get(repoName);
        return syncRoots.getRefs().contains(doc.getRef());
    }

    protected Map<String, SynchronizationRoots> computeSynchronizationRoots(String query, NuxeoPrincipal principal) {
        HashMap<String, SynchronizationRoots> syncRoots = new HashMap<String, SynchronizationRoots>();
        RepositoryManager repositoryManager = (RepositoryManager)Framework.getService(RepositoryManager.class);
        for (String repositoryName : repositoryManager.getRepositoryNames()) {
            CloseableCoreSession session = CoreInstance.openCoreSession((String)repositoryName, (NuxeoPrincipal)principal);
            try {
                syncRoots.putAll(this.queryAndFetchSynchronizationRoots((CoreSession)session, query));
            }
            finally {
                if (session == null) continue;
                session.close();
            }
        }
        return syncRoots;
    }

    protected Map<String, SynchronizationRoots> queryAndFetchSynchronizationRoots(CoreSession session, String query) {
        HashMap<String, SynchronizationRoots> syncRoots = new HashMap<String, SynchronizationRoots>();
        LinkedHashSet<IdRef> references = new LinkedHashSet<IdRef>();
        LinkedHashSet<String> paths = new LinkedHashSet<String>();
        try (IterableQueryResult results = session.queryAndFetch(query, "NXQL", new Object[0]);){
            for (Map result : results) {
                IdRef docRef = new IdRef(((Serializable)result.get("ecm:uuid")).toString());
                try {
                    DocumentModel doc = session.getDocument((DocumentRef)docRef);
                    references.add(docRef);
                    paths.add(doc.getPathAsString());
                }
                catch (DocumentNotFoundException e) {
                    Supplier[] supplierArray = new Supplier[2];
                    supplierArray[0] = () -> docRef;
                    supplierArray[1] = () -> ((CoreSession)session).getPrincipal();
                    log.warn("Document {} not found, not adding it to the list of synchronization roots for user {}.", supplierArray);
                }
                catch (DocumentSecurityException e) {
                    Supplier[] supplierArray = new Supplier[2];
                    supplierArray[0] = () -> ((CoreSession)session).getPrincipal();
                    supplierArray[1] = () -> docRef;
                    log.warn("User {} cannot access document {}, not adding it to the list of synchronization roots.", supplierArray);
                }
            }
        }
        SynchronizationRoots repoSyncRoots = new SynchronizationRoots(session.getRepositoryName(), paths, references);
        syncRoots.put(session.getRepositoryName(), repoSyncRoots);
        return syncRoots;
    }

    protected Map<String, Set<String>> computeCollectionSyncRootMemberIds(NuxeoPrincipal principal) {
        HashMap<String, Set<String>> collectionSyncRootMemberIds = new HashMap<String, Set<String>>();
        PageProviderService pageProviderService = (PageProviderService)Framework.getService(PageProviderService.class);
        RepositoryManager repositoryManager = (RepositoryManager)Framework.getService(RepositoryManager.class);
        for (String repositoryName : repositoryManager.getRepositoryNames()) {
            HashSet<String> collectionMemberIds = new HashSet<String>();
            CloseableCoreSession session = CoreInstance.openCoreSession((String)repositoryName, (NuxeoPrincipal)principal);
            try {
                HashMap<String, Serializable> props = new HashMap<String, Serializable>();
                props.put("coreSession", (Serializable)session);
                PageProvider collectionPageProvider = pageProviderService.getPageProvider("all_collections", null, null, Long.valueOf(0L), props, new Object[0]);
                List collections = collectionPageProvider.getCurrentPage();
                for (DocumentModel collection : collections) {
                    if (!this.isSynchronizationRoot(principal, collection)) continue;
                    PageProvider collectionMemberPageProvider = pageProviderService.getPageProvider("default_content_collection", null, Long.valueOf(1000L), Long.valueOf(0L), props, new Object[]{collection.getId()});
                    List collectionMembers = collectionMemberPageProvider.getCurrentPage();
                    for (DocumentModel collectionMember : collectionMembers) {
                        collectionMemberIds.add(collectionMember.getId());
                    }
                }
                collectionSyncRootMemberIds.put(repositoryName, collectionMemberIds);
            }
            finally {
                if (session == null) continue;
                session.close();
            }
        }
        return collectionSyncRootMemberIds;
    }

    protected void checkCanUpdateSynchronizationRoot(DocumentModel newRootContainer) {
        if (newRootContainer.isProxy() || newRootContainer.isVersion()) {
            throw new NuxeoException(String.format("Document '%s' (%s) is not a suitable synchronization root as it is either a readonly proxy or an archived version.", newRootContainer.getTitle(), newRootContainer.getRef()));
        }
    }

    @Override
    public FileSystemChangeFinder getChangeFinder() {
        return this.changeFinder;
    }

    protected String computeSyncRootsQuery(String username) {
        return String.format("SELECT ecm:uuid FROM Document WHERE %s/*1/username = %s AND %s/*1/enabled = 1 AND ecm:isTrashed = 0 AND ecm:isVersion = 0 ORDER BY dc:title, dc:created DESC", DRIVE_SUBSCRIPTIONS_PROPERTY, NXQLQueryBuilder.prepareStringLiteral((String)username, (boolean)true, (boolean)true), DRIVE_SUBSCRIPTIONS_PROPERTY);
    }

    @Override
    public void addToLocallyEditedCollection(CoreSession session, DocumentModel doc) {
        CollectionManager cm = (CollectionManager)Framework.getService(CollectionManager.class);
        DocumentModel userCollections = cm.getUserDefaultCollections(session);
        PathRef locallyEditedCollectionRef = new PathRef(userCollections.getPath().toString(), LOCALLY_EDITED_COLLECTION_NAME);
        DocumentModel locallyEditedCollection = null;
        if (session.exists((DocumentRef)locallyEditedCollectionRef)) {
            locallyEditedCollection = session.getDocument((DocumentRef)locallyEditedCollectionRef);
            cm.addToCollection(locallyEditedCollection, doc, session);
        } else {
            cm.addToNewCollection(LOCALLY_EDITED_COLLECTION_NAME, "Documents locally edited with Nuxeo Drive", doc, session);
            locallyEditedCollection = session.getDocument((DocumentRef)locallyEditedCollectionRef);
        }
        Set<IdRef> syncRootRefs = this.getSynchronizationRootReferences(session);
        if (!syncRootRefs.contains(new IdRef(locallyEditedCollection.getId()))) {
            this.registerSynchronizationRoot(session.getPrincipal(), locallyEditedCollection, session);
        }
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (CHANGE_FINDER_EP.equals(extensionPoint)) {
            this.changeFinderRegistry.addContribution((ChangeFinderDescriptor)contribution);
        } else {
            log.error("Unknown extension point {}", (Object)extensionPoint);
        }
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (CHANGE_FINDER_EP.equals(extensionPoint)) {
            this.changeFinderRegistry.removeContribution((ChangeFinderDescriptor)contribution);
        } else {
            log.error("Unknown extension point {}", (Object)extensionPoint);
        }
    }

    public void activate(ComponentContext context) {
        super.activate(context);
        if (this.changeFinderRegistry == null) {
            this.changeFinderRegistry = new ChangeFinderRegistry();
        }
    }

    public void deactivate(ComponentContext context) {
        super.deactivate(context);
        this.changeFinderRegistry = null;
    }

    public int getApplicationStartedOrder() {
        ComponentInstance cacheComponent = Framework.getRuntime().getComponentInstance("org.nuxeo.ecm.core.cache.CacheService");
        if (cacheComponent == null || cacheComponent.getInstance() == null) {
            return super.getApplicationStartedOrder();
        }
        return ((DefaultComponent)cacheComponent.getInstance()).getApplicationStartedOrder() + 1;
    }

    public void start(ComponentContext context) {
        this.syncRootCache = ((CacheService)Framework.getService(CacheService.class)).getCache(DRIVE_SYNC_ROOT_CACHE);
        this.collectionSyncRootMemberCache = ((CacheService)Framework.getService(CacheService.class)).getCache(DRIVE_COLLECTION_SYNC_ROOT_MEMBER_CACHE);
        this.changeFinder = this.changeFinderRegistry.changeFinder;
    }

    public void stop(ComponentContext context) {
        this.syncRootCache = null;
        this.collectionSyncRootMemberCache = null;
        this.changeFinder = null;
    }
}

