/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.drive.operations.test;

import java.io.IOException;
import java.net.URL;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.drive.operations.test.NuxeoDriveIntegrationTestsHelper;
import org.nuxeo.drive.service.FileSystemItemAdapterService;
import org.nuxeo.drive.service.impl.FileSystemItemAdapterServiceImpl;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.runtime.api.Framework;

@Operation(id="NuxeoDrive.SetActiveFactories", category="Services", label="Nuxeo Drive: Activate or deactivate file system item factories")
public class NuxeoDriveSetActiveFactories {
    public static final String ID = "NuxeoDrive.SetActiveFactories";
    private static final Logger log = LogManager.getLogger(NuxeoDriveSetActiveFactories.class);
    @Param(name="profile")
    protected String profile;
    @Param(name="enable", required=false)
    protected boolean enable = true;

    @OperationMethod
    public boolean run() throws IOException {
        String contrib;
        NuxeoDriveIntegrationTestsHelper.checkOperationAllowed();
        if ("userworkspace".equals(this.profile)) {
            contrib = "/OSGI-INF/nuxeodrive-hierarchy-userworkspace-contrib.xml";
        } else if ("permission".equals(this.profile)) {
            contrib = "/OSGI-INF/nuxeodrive-hierarchy-permission-contrib.xml";
        } else {
            log.warn("No active file system item factory contribution for profile '{}'.", (Object)this.profile);
            return false;
        }
        URL url = NuxeoDriveSetActiveFactories.class.getResource(contrib);
        try {
            if (this.enable) {
                Framework.getRuntime().getContext().deploy(url);
            } else {
                Framework.getRuntime().getContext().undeploy(url);
            }
        }
        finally {
            Framework.getRuntime().getComponentManager().unstash();
        }
        FileSystemItemAdapterServiceImpl fileSystemItemAdapterService = (FileSystemItemAdapterServiceImpl)Framework.getService(FileSystemItemAdapterService.class);
        fileSystemItemAdapterService.setActiveFactories();
        return true;
    }
}

