/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.drive.operations;

import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.nuxeo.drive.adapter.RootlessItemException;
import org.nuxeo.drive.service.FileSystemItemManager;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.runtime.api.Framework;

@Deprecated
@Operation(id="NuxeoDrive.CanMove", category="Services", label="Nuxeo Drive: Can move", description="Check if the document backing the file system item with the given source id can be moved to the document backing the file system item with the given destination id. Return the result as a JSON blob.", deprecatedSince="10.3")
public class NuxeoDriveCanMove {
    private static final Logger log = LogManager.getLogger(NuxeoDriveCanMove.class);
    public static final String ID = "NuxeoDrive.CanMove";
    @Context
    protected OperationContext ctx;
    @Param(name="srcId", description="Id of the source file system item.")
    protected String srcId;
    @Param(name="destId", description="Id of the destination file system item.")
    protected String destId;

    @OperationMethod
    public Blob run() throws IOException {
        boolean canMove = false;
        try {
            FileSystemItemManager fileSystemItemManager = (FileSystemItemManager)Framework.getService(FileSystemItemManager.class);
            canMove = fileSystemItemManager.canMove(this.srcId, this.destId, this.ctx.getPrincipal());
        }
        catch (RootlessItemException e) {
            Supplier[] supplierArray = new Supplier[4];
            supplierArray[0] = () -> this.srcId;
            supplierArray[1] = () -> this.destId;
            supplierArray[2] = () -> ((RootlessItemException)e).getMessage();
            supplierArray[3] = () -> e;
            log.debug("Cannot move {} to {}: {}", supplierArray);
        }
        return Blobs.createJSONBlobFromValue((Object)canMove);
    }
}

