/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.drive.adapter.impl;

import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.drive.adapter.FileItem;
import org.nuxeo.drive.adapter.FolderItem;
import org.nuxeo.drive.adapter.impl.AbstractDocumentBackedFileSystemItem;
import org.nuxeo.drive.adapter.impl.FileSystemItemHelper;
import org.nuxeo.drive.service.FileSystemItemFactory;
import org.nuxeo.drive.service.NuxeoDriveManager;
import org.nuxeo.drive.service.VersioningFileSystemItemFactory;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.io.download.DownloadService;
import org.nuxeo.runtime.api.Framework;

public class DocumentBackedFileItem
extends AbstractDocumentBackedFileSystemItem
implements FileItem {
    protected String downloadURL;
    protected String digestAlgorithm;
    protected String digest;
    protected long size;
    protected boolean canUpdate;
    protected FileSystemItemFactory factory;

    public DocumentBackedFileItem(FileSystemItemFactory factory, DocumentModel doc) {
        this(factory, doc, false);
    }

    public DocumentBackedFileItem(FileSystemItemFactory factory, DocumentModel doc, boolean relaxSyncRootConstraint) {
        this(factory, doc, relaxSyncRootConstraint, true);
    }

    public DocumentBackedFileItem(FileSystemItemFactory factory, DocumentModel doc, boolean relaxSyncRootConstraint, boolean getLockInfo) {
        super(factory.getName(), doc, relaxSyncRootConstraint, getLockInfo);
        this.initialize(factory, doc);
    }

    public DocumentBackedFileItem(FileSystemItemFactory factory, FolderItem parentItem, DocumentModel doc) {
        this(factory, parentItem, doc, false);
    }

    public DocumentBackedFileItem(FileSystemItemFactory factory, FolderItem parentItem, DocumentModel doc, boolean relaxSyncRootConstraint) {
        this(factory, parentItem, doc, relaxSyncRootConstraint, true);
    }

    public DocumentBackedFileItem(FileSystemItemFactory factory, FolderItem parentItem, DocumentModel doc, boolean relaxSyncRootConstraint, boolean getLockInfo) {
        super(factory.getName(), parentItem, doc, relaxSyncRootConstraint, getLockInfo);
        this.initialize(factory, doc);
    }

    @Deprecated
    public DocumentBackedFileItem(VersioningFileSystemItemFactory factory, DocumentModel doc) {
        this(factory, doc, false);
    }

    @Deprecated
    public DocumentBackedFileItem(VersioningFileSystemItemFactory factory, DocumentModel doc, boolean relaxSyncRootConstraint) {
        this(factory, doc, relaxSyncRootConstraint, true);
    }

    @Deprecated
    public DocumentBackedFileItem(VersioningFileSystemItemFactory factory, DocumentModel doc, boolean relaxSyncRootConstraint, boolean getLockInfo) {
        super(factory.getName(), doc, relaxSyncRootConstraint, getLockInfo);
        this.initialize(factory, doc);
    }

    @Deprecated
    public DocumentBackedFileItem(VersioningFileSystemItemFactory factory, FolderItem parentItem, DocumentModel doc) {
        this(factory, parentItem, doc, false);
    }

    @Deprecated
    public DocumentBackedFileItem(VersioningFileSystemItemFactory factory, FolderItem parentItem, DocumentModel doc, boolean relaxSyncRootConstraint) {
        this(factory, parentItem, doc, relaxSyncRootConstraint, true);
    }

    @Deprecated
    public DocumentBackedFileItem(VersioningFileSystemItemFactory factory, FolderItem parentItem, DocumentModel doc, boolean relaxSyncRootConstraint, boolean getLockInfo) {
        super(factory.getName(), parentItem, doc, relaxSyncRootConstraint, getLockInfo);
        this.initialize(factory, doc);
    }

    protected DocumentBackedFileItem() {
    }

    @Override
    public void rename(String name) {
        CoreSession session = CoreInstance.getCoreSession((String)this.repositoryName, (NuxeoPrincipal)this.principal);
        DocumentModel doc = this.getDocument(session);
        BlobHolder bh = this.getBlobHolder(doc);
        Blob blob = this.getBlob(bh);
        blob.setFilename(name);
        bh.setBlob(blob);
        this.updateDocTitleIfNeeded(doc, name);
        doc.putContextData("source", (Serializable)((Object)"drive"));
        doc = session.saveDocument(doc);
        session.save();
        this.name = name;
        this.updateDownloadURL();
        this.updateLastModificationDate(doc);
    }

    @Override
    public Blob getBlob() {
        CoreSession session = CoreInstance.getCoreSession((String)this.repositoryName, (NuxeoPrincipal)this.principal);
        DocumentModel doc = this.getDocument(session);
        return this.getBlob(doc);
    }

    @Override
    public String getDownloadURL() {
        return this.downloadURL;
    }

    @Override
    public String getDigestAlgorithm() {
        return this.digestAlgorithm;
    }

    @Override
    public String getDigest() {
        return this.digest;
    }

    @Override
    public boolean getCanUpdate() {
        return this.canUpdate;
    }

    @Override
    public long getSize() {
        return this.size;
    }

    @Override
    public void setBlob(Blob blob) {
        CoreSession session = CoreInstance.getCoreSession((String)this.repositoryName, (NuxeoPrincipal)this.principal);
        DocumentModel doc = this.getDocument(session);
        String blobFileName = blob.getFilename();
        if (StringUtils.isEmpty((CharSequence)blobFileName)) {
            blob.setFilename(this.name);
        } else {
            this.updateDocTitleIfNeeded(doc, blobFileName);
            this.name = blobFileName;
            this.updateDownloadURL();
        }
        BlobHolder bh = this.getBlobHolder(doc);
        bh.setBlob(blob);
        doc.putContextData("source", (Serializable)((Object)"drive"));
        doc = session.saveDocument(doc);
        session.save();
        this.updateLastModificationDate(doc);
        this.updateDigest(this.getBlob(doc));
        this.updateSize(blob);
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Deprecated
    protected final void initialize(VersioningFileSystemItemFactory factory, DocumentModel doc) {
        this.initialize((FileSystemItemFactory)factory, doc);
    }

    protected final void initialize(FileSystemItemFactory factory, DocumentModel doc) {
        this.factory = factory;
        Blob blob = this.getBlob(doc);
        this.name = this.getFileName(blob, doc.getTitle());
        this.folder = false;
        this.updateDownloadURL();
        this.updateDigest(blob);
        this.updateSize(blob);
        if (this.digest == null) {
            this.digestAlgorithm = null;
        }
        this.canUpdate = this.canRename;
    }

    protected BlobHolder getBlobHolder(DocumentModel doc) {
        BlobHolder bh = (BlobHolder)doc.getAdapter(BlobHolder.class);
        if (bh == null) {
            throw new NuxeoException(String.format("Document %s is not a BlobHolder, it is not adaptable as a FileItem and therefore it cannot not be part of the items to synchronize.", doc.getId()));
        }
        return bh;
    }

    protected Blob getBlob(BlobHolder blobHolder) {
        Blob blob = blobHolder.getBlob();
        if (blob == null) {
            throw new NuxeoException("Document has no blob, it is not adaptable as a FileItem and therefore it cannot not be part of the items to synchronize.");
        }
        return blob;
    }

    protected Blob getBlob(DocumentModel doc) {
        BlobHolder bh = this.getBlobHolder(doc);
        return this.getBlob(bh);
    }

    protected String getFileName(Blob blob, String docTitle) {
        String filename = blob.getFilename();
        return filename != null ? filename : docTitle;
    }

    protected void updateDocTitleIfNeeded(DocumentModel doc, String name) {
        if (this.name.equals(this.docTitle)) {
            doc.setPropertyValue("dc:title", (Serializable)((Object)name));
            this.docTitle = name;
        }
    }

    protected void updateDownloadURL() {
        DownloadService downloadService = (DownloadService)Framework.getService(DownloadService.class);
        String escapedFilename = this.name.replaceAll("(/|\\\\|\\*|<|>|\\?|\"|:|\\|)", "-");
        this.downloadURL = downloadService.getDownloadUrl(this.repositoryName, this.docId, "blobholder:0", escapedFilename);
    }

    protected void updateDigest(Blob blob) {
        String blobDigest = blob.getDigest();
        if (StringUtils.isEmpty((CharSequence)blobDigest)) {
            this.digestAlgorithm = "MD5";
            this.digest = FileSystemItemHelper.getMD5Digest(blob);
        } else {
            this.digestAlgorithm = blob.getDigestAlgorithm();
            this.digest = blobDigest;
        }
    }

    protected void updateSize(Blob blob) {
        long length = blob.getLength();
        this.size = length > 0L ? length : 0L;
    }

    protected NuxeoDriveManager getNuxeoDriveManager() {
        return (NuxeoDriveManager)Framework.getService(NuxeoDriveManager.class);
    }

    protected void setDownloadURL(String downloadURL) {
        this.downloadURL = downloadURL;
    }

    protected void setDigestAlgorithm(String digestAlgorithm) {
        this.digestAlgorithm = digestAlgorithm;
    }

    protected void setDigest(String digest) {
        this.digest = digest;
    }

    protected void setCanUpdate(boolean canUpdate) {
        this.canUpdate = canUpdate;
    }

    protected void setSize(long size) {
        this.size = size;
    }
}

