/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.drive.adapter.impl;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Semaphore;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.nuxeo.drive.adapter.FileItem;
import org.nuxeo.drive.adapter.FileSystemItem;
import org.nuxeo.drive.adapter.FolderItem;
import org.nuxeo.drive.adapter.RootlessItemException;
import org.nuxeo.drive.adapter.ScrollFileSystemItemList;
import org.nuxeo.drive.adapter.impl.AbstractDocumentBackedFileSystemItem;
import org.nuxeo.drive.adapter.impl.ScrollDocumentModelList;
import org.nuxeo.drive.adapter.impl.ScrollFileSystemItemListImpl;
import org.nuxeo.drive.service.FileSystemItemAdapterService;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.DocumentSecurityException;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.IterableQueryResult;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.cache.Cache;
import org.nuxeo.ecm.core.cache.CacheService;
import org.nuxeo.ecm.core.query.sql.NXQL;
import org.nuxeo.ecm.platform.filemanager.api.FileImporterContext;
import org.nuxeo.ecm.platform.filemanager.api.FileManager;
import org.nuxeo.ecm.platform.query.api.PageProvider;
import org.nuxeo.ecm.platform.query.api.PageProviderService;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.services.config.ConfigurationService;

public class DocumentBackedFolderItem
extends AbstractDocumentBackedFileSystemItem
implements FolderItem {
    private static final Logger log = LogManager.getLogger(DocumentBackedFolderItem.class);
    private static final String FOLDER_ITEM_CHILDREN_PAGE_PROVIDER = "FOLDER_ITEM_CHILDREN";
    protected static final String DESCENDANTS_SCROLL_CACHE = "driveDescendantsScroll";
    protected static final String MAX_DESCENDANTS_BATCH_SIZE_PROPERTY = "org.nuxeo.drive.maxDescendantsBatchSize";
    protected static final int MAX_DESCENDANTS_BATCH_SIZE_DEFAULT = 1000;
    protected static final int VCS_CHUNK_SIZE = 100;
    protected boolean canCreateChild;
    protected boolean canScrollDescendants;

    public DocumentBackedFolderItem(String factoryName, DocumentModel doc) {
        this(factoryName, doc, false);
    }

    public DocumentBackedFolderItem(String factoryName, DocumentModel doc, boolean relaxSyncRootConstraint) {
        this(factoryName, doc, relaxSyncRootConstraint, true);
    }

    public DocumentBackedFolderItem(String factoryName, DocumentModel doc, boolean relaxSyncRootConstraint, boolean getLockInfo) {
        super(factoryName, doc, relaxSyncRootConstraint, getLockInfo);
        this.initialize(doc);
    }

    public DocumentBackedFolderItem(String factoryName, FolderItem parentItem, DocumentModel doc) {
        this(factoryName, parentItem, doc, false);
    }

    public DocumentBackedFolderItem(String factoryName, FolderItem parentItem, DocumentModel doc, boolean relaxSyncRootConstraint) {
        this(factoryName, parentItem, doc, relaxSyncRootConstraint, true);
    }

    public DocumentBackedFolderItem(String factoryName, FolderItem parentItem, DocumentModel doc, boolean relaxSyncRootConstraint, boolean getLockInfo) {
        super(factoryName, parentItem, doc, relaxSyncRootConstraint, getLockInfo);
        this.initialize(doc);
    }

    protected DocumentBackedFolderItem() {
    }

    @Override
    public void rename(String name) {
        CoreSession session = CoreInstance.getCoreSession((String)this.repositoryName, (NuxeoPrincipal)this.principal);
        DocumentModel doc = this.getDocument(session);
        doc.setPropertyValue("dc:title", (Serializable)((Object)name));
        doc.putContextData("source", (Serializable)((Object)"drive"));
        doc = session.saveDocument(doc);
        session.save();
        this.docTitle = name;
        this.name = name;
        this.updateLastModificationDate(doc);
    }

    @Override
    public List<FileSystemItem> getChildren() {
        CoreSession session = CoreInstance.getCoreSession((String)this.repositoryName, (NuxeoPrincipal)this.principal);
        PageProviderService pageProviderService = (PageProviderService)Framework.getService(PageProviderService.class);
        HashMap<String, Serializable> props = new HashMap<String, Serializable>();
        props.put("coreSession", (Serializable)session);
        PageProvider childrenPageProvider = pageProviderService.getPageProvider(FOLDER_ITEM_CHILDREN_PAGE_PROVIDER, null, null, Long.valueOf(0L), props, new Object[]{this.docId});
        long pageSize = childrenPageProvider.getPageSize();
        ArrayList<FileSystemItem> children = new ArrayList<FileSystemItem>();
        int nbChildren = 0;
        boolean reachedPageSize = false;
        boolean hasNextPage = true;
        while ((long)nbChildren < pageSize && hasNextPage) {
            List dmChildren = childrenPageProvider.getCurrentPage();
            for (DocumentModel dmChild : dmChildren) {
                FileSystemItem child = this.getFileSystemItemAdapterService().getFileSystemItem(dmChild, this, false, false, false);
                if (child == null) continue;
                children.add(child);
                if ((long)(++nbChildren) != pageSize) continue;
                reachedPageSize = true;
                break;
            }
            if (reachedPageSize || !(hasNextPage = childrenPageProvider.isNextPageAvailable())) continue;
            childrenPageProvider.nextPage();
        }
        return children;
    }

    @Override
    public boolean getCanScrollDescendants() {
        return this.canScrollDescendants;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ScrollFileSystemItemList scrollDescendants(String scrollId, int batchSize, long keepAlive) {
        ScrollFileSystemItemList scrollFileSystemItemList;
        Semaphore semaphore = ((FileSystemItemAdapterService)Framework.getService(FileSystemItemAdapterService.class)).getScrollBatchSemaphore();
        log.trace("Thread [{}] acquiring scroll batch semaphore", new Supplier[]{Thread::currentThread});
        semaphore.acquire();
        try {
            Supplier[] supplierArray = new Supplier[2];
            supplierArray[0] = Thread::currentThread;
            supplierArray[1] = semaphore::availablePermits;
            log.trace("Thread [{}] acquired scroll batch semaphore, available permits reduced to {}", supplierArray);
            scrollFileSystemItemList = this.doScrollDescendants(scrollId, batchSize, keepAlive);
            semaphore.release();
        }
        catch (Throwable throwable) {
            try {
                semaphore.release();
                Supplier[] supplierArray = new Supplier[2];
                supplierArray[0] = Thread::currentThread;
                supplierArray[1] = semaphore::availablePermits;
                log.trace("Thread [{}] released scroll batch semaphore, available permits increased to {}", supplierArray);
                throw throwable;
            }
            catch (InterruptedException cause) {
                Thread.currentThread().interrupt();
                throw new NuxeoException("Scroll batch interrupted", (Throwable)cause);
            }
        }
        Supplier[] supplierArray = new Supplier[2];
        supplierArray[0] = Thread::currentThread;
        supplierArray[1] = semaphore::availablePermits;
        log.trace("Thread [{}] released scroll batch semaphore, available permits increased to {}", supplierArray);
        return scrollFileSystemItemList;
    }

    protected ScrollFileSystemItemList doScrollDescendants(String scrollId, int batchSize, long keepAlive) {
        CoreSession session = CoreInstance.getCoreSession((String)this.repositoryName, (NuxeoPrincipal)this.principal);
        this.checkBatchSize(batchSize);
        ScrollDocumentModelList descendantDocsBatch = this.getScrollBatch(scrollId, batchSize, session, keepAlive);
        String newScrollId = descendantDocsBatch.getScrollId();
        if (descendantDocsBatch.isEmpty()) {
            return new ScrollFileSystemItemListImpl(newScrollId, 0);
        }
        List<FileSystemItem> descendants = this.adaptDocuments((DocumentModelList)descendantDocsBatch, session);
        Supplier[] supplierArray = new Supplier[3];
        supplierArray[0] = descendants::size;
        supplierArray[1] = () -> this.docPath;
        supplierArray[2] = () -> batchSize;
        log.debug("Retrieved {} descendants of FolderItem {} (batchSize = {})", supplierArray);
        return new ScrollFileSystemItemListImpl(newScrollId, descendants);
    }

    protected void checkBatchSize(int batchSize) {
        int maxDescendantsBatchSize = ((ConfigurationService)Framework.getService(ConfigurationService.class)).getInteger(MAX_DESCENDANTS_BATCH_SIZE_PROPERTY, 1000);
        if (batchSize > maxDescendantsBatchSize) {
            throw new NuxeoException(String.format("Batch size %d is greater than the maximum batch size allowed %d. If you need to increase this limit you can set the %s configuration property but this is not recommended for performance reasons.", batchSize, maxDescendantsBatchSize, MAX_DESCENDANTS_BATCH_SIZE_PROPERTY));
        }
    }

    protected ScrollDocumentModelList getScrollBatch(String scrollId, int batchSize, CoreSession session, long keepAlive) {
        String newScrollId;
        List<String> descendantIds;
        Cache scrollingCache = ((CacheService)Framework.getService(CacheService.class)).getCache(DESCENDANTS_SCROLL_CACHE);
        if (scrollingCache == null) {
            throw new NuxeoException("Cache not found: driveDescendantsScroll");
        }
        if (StringUtils.isEmpty((CharSequence)scrollId)) {
            descendantIds = new ArrayList();
            StringBuilder sb = new StringBuilder(String.format("SELECT ecm:uuid FROM Document WHERE ecm:ancestorId = '%s'", this.docId));
            sb.append(" AND ecm:isTrashed = 0");
            sb.append(" AND ecm:mixinType != 'HiddenInNavigation'");
            String query = sb.toString();
            log.debug("Executing initial query to scroll through the descendants of {}: {}", (Object)this.docPath, (Object)query);
            try (IterableQueryResult res = session.queryAndFetch(sb.toString(), "NXQL", new Object[0]);){
                Iterator it = res.iterator();
                while (it.hasNext()) {
                    descendantIds.add((String)((Map)it.next()).get("ecm:uuid"));
                }
            }
            newScrollId = UUID.randomUUID().toString();
            log.debug("Put initial query result list (search context) in the {} cache at key (scrollId) {}", (Object)DESCENDANTS_SCROLL_CACHE, (Object)newScrollId);
            scrollingCache.put(newScrollId, (Serializable)((Object)descendantIds));
        } else {
            descendantIds = (List)((Object)scrollingCache.get(scrollId));
            if (descendantIds == null) {
                throw new NuxeoException(String.format("No search context found in the %s cache for scrollId [%s]", DESCENDANTS_SCROLL_CACHE, scrollId));
            }
            newScrollId = scrollId;
        }
        if (descendantIds.isEmpty()) {
            return new ScrollDocumentModelList(newScrollId, 0);
        }
        List<String> descendantIdsBatch = this.getBatch(descendantIds, batchSize);
        scrollingCache.put(newScrollId, (Serializable)((Object)descendantIds));
        DocumentModelList descendantDocsBatch = this.fetchFromVCS(descendantIdsBatch, session);
        return new ScrollDocumentModelList(newScrollId, descendantDocsBatch);
    }

    protected List<String> getBatch(List<String> ids, int batchSize) {
        ArrayList<String> batch = new ArrayList<String>(batchSize);
        Iterator<String> it = ids.iterator();
        for (int idCount = 0; it.hasNext() && idCount < batchSize; ++idCount) {
            batch.add(it.next());
            it.remove();
        }
        return batch;
    }

    protected DocumentModelList fetchFromVCS(List<String> ids, CoreSession session) {
        DocumentModelList res = null;
        int size = ids.size();
        int start = 0;
        int end = Math.min(100, size);
        boolean done = false;
        while (!done) {
            DocumentModelList docs = this.fetchFromVcsChunk(ids.subList(start, end), session);
            if (res == null) {
                res = docs;
            } else {
                res.addAll((Collection)docs);
            }
            if (end >= ids.size()) {
                done = true;
                continue;
            }
            start = end;
            end = Math.min(start + 100, size);
        }
        return res;
    }

    protected DocumentModelList fetchFromVcsChunk(List<String> ids, CoreSession session) {
        int docCount = ids.size();
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT * FROM Document WHERE ecm:uuid IN (");
        for (int i = 0; i < docCount; ++i) {
            sb.append(NXQL.escapeString((String)ids.get(i)));
            if (i >= docCount - 1) continue;
            sb.append(", ");
        }
        sb.append(")");
        String query = sb.toString();
        log.debug("Fetching {} documents from VCS: {}", (Object)docCount, (Object)query);
        return session.query(query);
    }

    protected List<FileSystemItem> adaptDocuments(DocumentModelList docs, CoreSession session) {
        HashMap<DocumentRef, FolderItem> ancestorCache = new HashMap<DocumentRef, FolderItem>();
        log.trace("Caching current FolderItem for doc {}: {}", new Supplier[]{() -> this.docPath, this::getPath});
        ancestorCache.put((DocumentRef)new IdRef(this.docId), this);
        ArrayList<FileSystemItem> descendants = new ArrayList<FileSystemItem>(docs.size());
        for (DocumentModel doc : docs) {
            FolderItem parent = this.populateAncestorCache(ancestorCache, doc, session, false);
            if (parent == null) {
                Supplier[] supplierArray = new Supplier[1];
                supplierArray[0] = () -> ((DocumentModel)doc).getPathAsString();
                log.debug("Cannot adapt parent document of {} as a FileSystemItem, skipping descendant document", supplierArray);
                continue;
            }
            FileSystemItem descendant = this.getFileSystemItemAdapterService().getFileSystemItem(doc, parent, false, false, false);
            if (descendant == null) continue;
            if (descendant.isFolder()) {
                Supplier[] supplierArray = new Supplier[2];
                supplierArray[0] = () -> ((DocumentModel)doc).getPathAsString();
                supplierArray[1] = descendant::getPath;
                log.trace("Caching descendant FolderItem for doc {}: {}", supplierArray);
                ancestorCache.put(doc.getRef(), (FolderItem)descendant);
            }
            descendants.add(descendant);
        }
        return descendants;
    }

    protected FolderItem populateAncestorCache(Map<DocumentRef, FolderItem> cache, DocumentModel doc, CoreSession session, boolean cacheItem) {
        DocumentRef parentDocRef = session.getParentDocumentRef(doc.getRef());
        if (parentDocRef == null) {
            throw new RootlessItemException("Reached repository root");
        }
        FolderItem parentItem = cache.get(parentDocRef);
        if (parentItem != null) {
            Supplier[] supplierArray = new Supplier[2];
            supplierArray[0] = () -> ((DocumentModel)doc).getPathAsString();
            supplierArray[1] = parentItem::getPath;
            log.trace("Found parent FolderItem in cache for doc {}: {}", supplierArray);
            return this.getFolderItem(cache, doc, parentItem, cacheItem);
        }
        Supplier[] supplierArray = new Supplier[1];
        supplierArray[0] = () -> ((DocumentModel)doc).getPathAsString();
        log.trace("No parent FolderItem found in cache for doc {}, computing ancestor cache", supplierArray);
        DocumentModel parentDoc = null;
        try {
            parentDoc = session.getDocument(parentDocRef);
        }
        catch (DocumentSecurityException e) {
            Supplier[] supplierArray2 = new Supplier[4];
            supplierArray2[0] = () -> this.principal.getName();
            supplierArray2[1] = () -> ((DocumentModel)doc).getPathAsString();
            supplierArray2[2] = () -> ((DocumentModel)doc).getId();
            supplierArray2[3] = () -> e;
            log.debug("User {} has no READ access on parent of document {} ({}).", supplierArray2);
            return null;
        }
        parentItem = this.populateAncestorCache(cache, parentDoc, session, true);
        if (parentItem == null) {
            return null;
        }
        return this.getFolderItem(cache, doc, parentItem, cacheItem);
    }

    protected FolderItem getFolderItem(Map<DocumentRef, FolderItem> cache, DocumentModel doc, FolderItem parentItem, boolean cacheItem) {
        if (cacheItem) {
            FileSystemItem fsItem = this.getFileSystemItemAdapterService().getFileSystemItem(doc, parentItem, true, false, false);
            if (fsItem == null) {
                Supplier[] supplierArray = new Supplier[1];
                supplierArray[0] = () -> ((DocumentModel)doc).getPathAsString();
                log.debug("Reached document {} that cannot be  adapted as a (possibly virtual) descendant of the top level folder item.", supplierArray);
                return null;
            }
            FolderItem folderItem = (FolderItem)fsItem;
            Supplier[] supplierArray = new Supplier[2];
            supplierArray[0] = () -> ((DocumentModel)doc).getPathAsString();
            supplierArray[1] = folderItem::getPath;
            log.trace("Caching FolderItem for doc {}: {}", supplierArray);
            cache.put(doc.getRef(), folderItem);
            return folderItem;
        }
        return parentItem;
    }

    @Override
    public boolean getCanCreateChild() {
        return this.canCreateChild;
    }

    @Override
    public FolderItem createFolder(String name, boolean overwrite) {
        try {
            CoreSession session = CoreInstance.getCoreSession((String)this.repositoryName, (NuxeoPrincipal)this.principal);
            DocumentModel folder = this.getFileManager().createFolder(session, name, this.docPath, overwrite);
            if (folder == null) {
                throw new NuxeoException(String.format("Cannot create folder named '%s' as a child of doc %s. Probably because of the allowed sub-types for this doc type, please check them.", name, this.docPath));
            }
            return (FolderItem)this.getFileSystemItemAdapterService().getFileSystemItem(folder, this);
        }
        catch (NuxeoException e) {
            e.addInfo(String.format("Error while trying to create folder %s as a child of doc %s", name, this.docPath));
            throw e;
        }
        catch (IOException e) {
            throw new NuxeoException(String.format("Error while trying to create folder %s as a child of doc %s", name, this.docPath), (Throwable)e);
        }
    }

    @Override
    public FileItem createFile(Blob blob, boolean overwrite) {
        String fileName = blob.getFilename();
        try {
            CoreSession session = CoreInstance.getCoreSession((String)this.repositoryName, (NuxeoPrincipal)this.principal);
            FileImporterContext context = FileImporterContext.builder((CoreSession)session, (Blob)blob, (String)this.docPath).overwrite(overwrite).excludeOneToMany(true).build();
            DocumentModel file = this.getFileManager().createOrUpdateDocument(context);
            if (file == null) {
                throw new NuxeoException(String.format("Cannot create file '%s' as a child of doc %s. Probably because there are no file importers registered, please check the contributions to the <extension target=\"org.nuxeo.ecm.platform.filemanager.service.FileManagerService\" point=\"plugins\"> extension point.", fileName, this.docPath));
            }
            return (FileItem)this.getFileSystemItemAdapterService().getFileSystemItem(file, this);
        }
        catch (NuxeoException e) {
            e.addInfo(String.format("Error while trying to create file %s as a child of doc %s", fileName, this.docPath));
            throw e;
        }
        catch (IOException e) {
            throw new NuxeoException(String.format("Error while trying to create file %s as a child of doc %s", fileName, this.docPath), (Throwable)e);
        }
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    protected void initialize(DocumentModel doc) {
        this.name = this.docTitle;
        this.folder = true;
        boolean bl = this.canCreateChild = !doc.hasFacet("PublishSpace");
        if (this.canCreateChild) {
            this.canCreateChild = ((ConfigurationService)Framework.getService(ConfigurationService.class)).isBooleanTrue("org.nuxeo.drive.permissionCheckOptimized") ? this.canRename : doc.getCoreSession().hasPermission(doc.getRef(), "AddChildren");
        }
        this.canScrollDescendants = true;
    }

    protected FileManager getFileManager() {
        return (FileManager)Framework.getService(FileManager.class);
    }

    protected void setCanCreateChild(boolean canCreateChild) {
        this.canCreateChild = canCreateChild;
    }

    protected void setCanScrollDescendants(boolean canScrollDescendants) {
        this.canScrollDescendants = canScrollDescendants;
    }
}

