/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.drive.hierarchy.permission.adapter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.nuxeo.drive.adapter.FileSystemItem;
import org.nuxeo.drive.adapter.impl.AbstractVirtualFolderItem;
import org.nuxeo.drive.service.NuxeoDriveManager;
import org.nuxeo.drive.service.SynchronizationRoots;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.runtime.api.Framework;

public class SharedSyncRootParentFolderItem
extends AbstractVirtualFolderItem {
    private static final Logger log = LogManager.getLogger(SharedSyncRootParentFolderItem.class);

    public SharedSyncRootParentFolderItem(String factoryName, NuxeoPrincipal principal, String parentId, String parentPath, String folderName) {
        super(factoryName, principal, parentId, parentPath, folderName);
    }

    protected SharedSyncRootParentFolderItem() {
    }

    @Override
    public List<FileSystemItem> getChildren() {
        ArrayList<FileSystemItem> children = new ArrayList<FileSystemItem>();
        Map<String, SynchronizationRoots> syncRootsByRepo = ((NuxeoDriveManager)Framework.getService(NuxeoDriveManager.class)).getSynchronizationRoots(this.principal);
        for (Map.Entry<String, SynchronizationRoots> entry : syncRootsByRepo.entrySet()) {
            CoreSession session = CoreInstance.getCoreSession((String)entry.getKey(), (NuxeoPrincipal)this.principal);
            Set<IdRef> syncRootRefs = entry.getValue().getRefs();
            for (IdRef idRef : syncRootRefs) {
                if (!session.hasPermission((DocumentRef)idRef, "Read")) {
                    Supplier[] supplierArray = new Supplier[2];
                    supplierArray[0] = () -> ((CoreSession)session).getPrincipal();
                    supplierArray[1] = () -> idRef;
                    log.debug("User {} has no READ access on synchronization root {}, not including it in children.", supplierArray);
                    continue;
                }
                DocumentModel doc = session.getDocument((DocumentRef)idRef);
                if (session.getPrincipal().getName().equals(doc.getPropertyValue("dc:creator"))) continue;
                FileSystemItem child = this.getFileSystemItemAdapterService().getFileSystemItem(doc, this, false, false, false);
                if (child == null) {
                    Supplier[] supplierArray = new Supplier[2];
                    supplierArray[0] = () -> idRef;
                    supplierArray[1] = () -> ((CoreSession)session).getPrincipal();
                    log.debug("Synchronization root {} cannot be adapted as a FileSystemItem, maybe because user {} doesn't have the required permission on it (default required permission is ReadWrite). Not including it in children.", supplierArray);
                    continue;
                }
                log.debug("Including synchronization root {} in children.", (Object)idRef);
                children.add(child);
            }
        }
        Collections.sort(children);
        return children;
    }
}

