/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.drive.hierarchy.permission.factory;

import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.nuxeo.drive.adapter.FileSystemItem;
import org.nuxeo.drive.adapter.FolderItem;
import org.nuxeo.drive.hierarchy.permission.adapter.UserSyncRootParentFolderItem;
import org.nuxeo.drive.hierarchy.userworkspace.adapter.UserWorkspaceHelper;
import org.nuxeo.drive.service.FileSystemItemManager;
import org.nuxeo.drive.service.VirtualFolderItemFactory;
import org.nuxeo.drive.service.impl.AbstractFileSystemItemFactory;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.repository.RepositoryManager;
import org.nuxeo.ecm.platform.userworkspace.api.UserWorkspaceService;
import org.nuxeo.runtime.api.Framework;

public class UserSyncRootParentFactory
extends AbstractFileSystemItemFactory
implements VirtualFolderItemFactory {
    private static final Logger log = LogManager.getLogger(UserSyncRootParentFactory.class);
    protected static final String FOLDER_NAME_PARAM = "folderName";
    protected String folderName;

    @Override
    public void handleParameters(Map<String, String> parameters) {
        String folderNameParam = parameters.get(FOLDER_NAME_PARAM);
        if (StringUtils.isEmpty((CharSequence)folderNameParam)) {
            throw new NuxeoException(String.format("Factory %s has no %s parameter, please provide one.", this.getName(), FOLDER_NAME_PARAM));
        }
        this.folderName = folderNameParam;
    }

    @Override
    public boolean isFileSystemItem(DocumentModel doc, boolean includeDeleted, boolean relaxSyncRootConstraint) {
        boolean isUserWorkspace = UserWorkspaceHelper.isUserWorkspace(doc);
        if (!isUserWorkspace) {
            Supplier[] supplierArray = new Supplier[1];
            supplierArray[0] = () -> ((DocumentModel)doc).getId();
            log.trace("Document {} is not a user workspace, it cannot be adapted as a FileSystemItem.", supplierArray);
            return false;
        }
        if (!includeDeleted && doc.isTrashed()) {
            Supplier[] supplierArray = new Supplier[1];
            supplierArray[0] = () -> ((DocumentModel)doc).getId();
            log.debug("Document {} is in the trash, it cannot be adapted as a FileSystemItem.", supplierArray);
            return false;
        }
        return true;
    }

    @Override
    protected FileSystemItem adaptDocument(DocumentModel doc, boolean forceParentItem, FolderItem parentItem, boolean relaxSyncRootConstraint, boolean getLockInfo) {
        return new UserSyncRootParentFolderItem(this.getName(), doc, parentItem, this.folderName, relaxSyncRootConstraint, getLockInfo);
    }

    @Override
    public FileSystemItem getFileSystemItem(DocumentModel doc, boolean includeDeleted) {
        NuxeoPrincipal principal = doc.getPrincipal();
        return this.getFileSystemItem(doc, this.getTopLevelFolderItem(principal), includeDeleted);
    }

    @Override
    public FileSystemItem getFileSystemItem(DocumentModel doc, boolean includeDeleted, boolean relaxSyncRootConstraint) {
        NuxeoPrincipal principal = doc.getPrincipal();
        return this.getFileSystemItem(doc, this.getTopLevelFolderItem(principal), includeDeleted, relaxSyncRootConstraint);
    }

    @Override
    public FileSystemItem getFileSystemItem(DocumentModel doc, boolean includeDeleted, boolean relaxSyncRootConstraint, boolean getLockInfo) {
        NuxeoPrincipal principal = doc.getPrincipal();
        return this.getFileSystemItem(doc, this.getTopLevelFolderItem(principal), includeDeleted, relaxSyncRootConstraint, getLockInfo);
    }

    @Override
    public FolderItem getVirtualFolderItem(NuxeoPrincipal principal) {
        RepositoryManager repositoryManager = (RepositoryManager)Framework.getService(RepositoryManager.class);
        CoreSession session = CoreInstance.getCoreSession((String)repositoryManager.getDefaultRepositoryName(), (NuxeoPrincipal)principal);
        UserWorkspaceService userWorkspaceService = (UserWorkspaceService)Framework.getService(UserWorkspaceService.class);
        DocumentModel userWorkspace = userWorkspaceService.getCurrentUserPersonalWorkspace(session);
        if (userWorkspace == null) {
            throw new NuxeoException(String.format("No personal workspace found for user %s.", principal.getName()));
        }
        return (FolderItem)this.getFileSystemItem(userWorkspace);
    }

    @Override
    public String getFolderName() {
        return this.folderName;
    }

    @Override
    public void setFolderName(String folderName) {
        this.folderName = folderName;
    }

    protected FolderItem getTopLevelFolderItem(NuxeoPrincipal principal) {
        FolderItem topLevelFolder = ((FileSystemItemManager)Framework.getService(FileSystemItemManager.class)).getTopLevelFolder(principal);
        if (topLevelFolder == null) {
            throw new NuxeoException("Found no top level folder item. Please check your contribution to the following extension point: <extension target=\"org.nuxeo.drive.service.FileSystemItemAdapterService\" point=\"topLevelFolderItemFactory\">.");
        }
        return topLevelFolder;
    }
}

