/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.drive.listener;

import java.io.Serializable;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventContext;
import org.nuxeo.ecm.core.event.EventListener;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.core.query.sql.NXQL;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.services.config.ConfigurationService;

public class NuxeoDriveSyncRootCopyListener
implements EventListener {
    public static final String RESET_SYNC_ROOTS_ON_COPY_CONFIGURATION_PROPERTY = "org.nuxeo.drive.resetSyncRootsOnCopy";

    public void handleEvent(Event event) {
        if (((ConfigurationService)Framework.getService(ConfigurationService.class)).isBooleanFalse(RESET_SYNC_ROOTS_ON_COPY_CONFIGURATION_PROPERTY)) {
            return;
        }
        EventContext context = event.getContext();
        if (!(context instanceof DocumentEventContext)) {
            return;
        }
        DocumentModel doc = ((DocumentEventContext)context).getSourceDocument();
        CoreSession session = context.getCoreSession();
        DocumentModelList syncRoots = this.getSyncRoots(doc, session);
        for (DocumentModel syncRoot : syncRoots) {
            syncRoot.setPropertyValue("drv:subscriptions", null);
            syncRoot.putContextData("source", (Serializable)((Object)"drive"));
            syncRoot.putContextData("source", (Serializable)((Object)"drive"));
            session.saveDocument(syncRoot);
        }
    }

    protected DocumentModelList getSyncRoots(DocumentModel doc, CoreSession session) {
        String nxql = "SELECT * FROM Document WHERE ecm:mixinType = 'DriveSynchronized' AND ecm:isVersion = 0 AND ecm:path STARTSWITH " + NXQL.escapeString((String)doc.getPathAsString());
        DocumentModelList syncRoots = session.query(nxql);
        if (doc.hasFacet("DriveSynchronized")) {
            syncRoots.add((Object)doc);
        }
        return syncRoots;
    }
}

