/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.drive.service.impl;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.nuxeo.drive.adapter.FileSystemItem;
import org.nuxeo.drive.adapter.FolderItem;
import org.nuxeo.drive.service.FileSystemItemAdapterService;
import org.nuxeo.drive.service.FileSystemItemFactory;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentNotFoundException;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.DocumentSecurityException;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.runtime.api.Framework;

public abstract class AbstractFileSystemItemFactory
implements FileSystemItemFactory {
    private static final Logger log = LogManager.getLogger(AbstractFileSystemItemFactory.class);
    protected String name;

    protected abstract FileSystemItem adaptDocument(DocumentModel var1, boolean var2, FolderItem var3, boolean var4, boolean var5);

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public boolean isFileSystemItem(DocumentModel doc) {
        return this.isFileSystemItem(doc, false);
    }

    @Override
    public boolean isFileSystemItem(DocumentModel doc, boolean includeDeleted) {
        return this.isFileSystemItem(doc, includeDeleted, false);
    }

    @Override
    public FileSystemItem getFileSystemItem(DocumentModel doc) {
        return this.getFileSystemItem(doc, false);
    }

    @Override
    public FileSystemItem getFileSystemItem(DocumentModel doc, boolean includeDeleted) {
        return this.getFileSystemItem(doc, false, null, includeDeleted, false, true);
    }

    @Override
    public FileSystemItem getFileSystemItem(DocumentModel doc, boolean includeDeleted, boolean relaxSyncRootConstraint) {
        return this.getFileSystemItem(doc, false, null, includeDeleted, relaxSyncRootConstraint, true);
    }

    @Override
    public FileSystemItem getFileSystemItem(DocumentModel doc, boolean includeDeleted, boolean relaxSyncRootConstraint, boolean getLockInfo) {
        return this.getFileSystemItem(doc, false, null, includeDeleted, relaxSyncRootConstraint, getLockInfo);
    }

    @Override
    public FileSystemItem getFileSystemItem(DocumentModel doc, FolderItem parentItem) {
        return this.getFileSystemItem(doc, parentItem, false);
    }

    @Override
    public FileSystemItem getFileSystemItem(DocumentModel doc, FolderItem parentItem, boolean includeDeleted) {
        return this.getFileSystemItem(doc, true, parentItem, includeDeleted, false, true);
    }

    @Override
    public FileSystemItem getFileSystemItem(DocumentModel doc, FolderItem parentItem, boolean includeDeleted, boolean relaxSyncRootConstraint) {
        return this.getFileSystemItem(doc, true, parentItem, includeDeleted, relaxSyncRootConstraint, true);
    }

    @Override
    public FileSystemItem getFileSystemItem(DocumentModel doc, FolderItem parentItem, boolean includeDeleted, boolean relaxSyncRootConstraint, boolean getLockInfo) {
        return this.getFileSystemItem(doc, true, parentItem, includeDeleted, relaxSyncRootConstraint, getLockInfo);
    }

    @Override
    public boolean canHandleFileSystemItemId(String id) {
        try {
            this.parseFileSystemId(id);
        }
        catch (IllegalArgumentException e) {
            log.trace(e::getMessage);
            return false;
        }
        return true;
    }

    @Override
    public boolean exists(String id, NuxeoPrincipal principal) {
        String[] idFragments = this.parseFileSystemId(id);
        String repositoryName = idFragments[1];
        String docId = idFragments[2];
        try {
            CoreSession session = CoreInstance.getCoreSession((String)repositoryName, (NuxeoPrincipal)principal);
            DocumentModel doc = this.getDocumentById(docId, session);
            return this.isFileSystemItem(doc);
        }
        catch (DocumentNotFoundException e) {
            log.debug("No doc related to id {}, returning false.", (Object)docId);
            return false;
        }
        catch (DocumentSecurityException e) {
            log.debug("User {} cannot access doc {}, returning false.", (Object)principal, (Object)docId);
            return false;
        }
    }

    @Override
    public FileSystemItem getFileSystemItemById(String id, NuxeoPrincipal principal) {
        String[] idFragments = this.parseFileSystemId(id);
        String repositoryName = idFragments[1];
        String docId = idFragments[2];
        try {
            CoreSession session = CoreInstance.getCoreSession((String)repositoryName, (NuxeoPrincipal)principal);
            DocumentModel doc = this.getDocumentById(docId, session);
            return this.getFileSystemItem(doc);
        }
        catch (DocumentNotFoundException e) {
            log.debug("No doc related to id {}, returning null.", (Object)docId);
            return null;
        }
        catch (DocumentSecurityException e) {
            log.debug("User {} cannot access doc {}, returning null.", (Object)principal, (Object)docId);
            return null;
        }
    }

    @Override
    public FileSystemItem getFileSystemItemById(String id, String parentId, NuxeoPrincipal principal) {
        String[] idFragments = this.parseFileSystemId(id);
        String repositoryName = idFragments[1];
        String docId = idFragments[2];
        try {
            CoreSession session = CoreInstance.getCoreSession((String)repositoryName, (NuxeoPrincipal)principal);
            FileSystemItem parentItem = ((FileSystemItemAdapterService)Framework.getService(FileSystemItemAdapterService.class)).getFileSystemItemFactoryForId(parentId).getFileSystemItemById(parentId, principal);
            if (!(parentItem instanceof FolderItem)) {
                throw new NuxeoException(String.format("FileSystemItem with id %s should be a FolderItem", parentId));
            }
            DocumentModel doc = this.getDocumentById(docId, session);
            return this.getFileSystemItem(doc, (FolderItem)parentItem);
        }
        catch (DocumentNotFoundException e) {
            log.debug("No doc related to id {}, returning null.", (Object)docId);
            return null;
        }
        catch (DocumentSecurityException e) {
            log.debug("User {} cannot access doc {}, returning null.", (Object)principal, (Object)docId);
            return null;
        }
    }

    protected FileSystemItem adaptDocument(DocumentModel doc, boolean forceParentItem, FolderItem parentItem) {
        return this.adaptDocument(doc, forceParentItem, parentItem, false, true);
    }

    protected FileSystemItem getFileSystemItem(DocumentModel doc, boolean forceParentItem, FolderItem parentItem, boolean includeDeleted, boolean relaxSyncRootConstraint, boolean getLockInfo) {
        if (!this.isFileSystemItem(doc, includeDeleted, relaxSyncRootConstraint)) {
            Supplier[] supplierArray = new Supplier[1];
            supplierArray[0] = () -> ((DocumentModel)doc).getId();
            log.trace("Document {} cannot be adapted as a FileSystemItem => returning null.", supplierArray);
            return null;
        }
        return this.adaptDocument(doc, forceParentItem, parentItem, relaxSyncRootConstraint, getLockInfo);
    }

    protected String[] parseFileSystemId(String id) {
        String[] idFragments = id.split("#");
        if (idFragments.length != 3) {
            throw new IllegalArgumentException(String.format("FileSystemItem id %s cannot be handled by factory named %s. Should match the 'fileSystemItemFactoryName#repositoryName#docId' pattern.", id, this.name));
        }
        String factoryName = idFragments[0];
        if (!this.name.equals(factoryName)) {
            throw new IllegalArgumentException(String.format("Factoy name [%s] parsed from id %s does not match the actual factory name [%s].", factoryName, id, this.name));
        }
        return idFragments;
    }

    protected DocumentModel getDocumentById(String docId, CoreSession session) {
        return session.getDocument((DocumentRef)new IdRef(docId));
    }
}

