/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.drive.service.impl;

import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.nuxeo.drive.adapter.FileSystemItem;
import org.nuxeo.drive.adapter.FolderItem;
import org.nuxeo.drive.service.NuxeoDriveManager;
import org.nuxeo.drive.service.impl.AbstractFileSystemItemFactory;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.runtime.api.Framework;

public abstract class AbstractSyncRootFolderItemFactory
extends AbstractFileSystemItemFactory {
    private static final Logger log = LogManager.getLogger(AbstractSyncRootFolderItemFactory.class);

    protected abstract FolderItem getParentItem(DocumentModel var1);

    @Override
    public void handleParameters(Map<String, String> parameters) {
        if (!parameters.isEmpty()) {
            throw new IllegalArgumentException("Parameter map is not empty whereas no parameters are contributed to the factory.");
        }
        log.debug("Factory {} has no parameters to handle.", new Supplier[]{this::getName});
    }

    @Override
    public boolean isFileSystemItem(DocumentModel doc, boolean includeDeleted, boolean relaxSyncRootConstraint) {
        NuxeoPrincipal principal;
        NuxeoDriveManager nuxeoDriveManager;
        boolean isSyncRoot;
        if (!doc.isFolder()) {
            Supplier[] supplierArray = new Supplier[1];
            supplierArray[0] = () -> ((DocumentModel)doc).getId();
            log.debug("Document {} is not Folderish, it cannot be adapted as a FileSystemItem.", supplierArray);
            return false;
        }
        if (doc.isVersion()) {
            Supplier[] supplierArray = new Supplier[1];
            supplierArray[0] = () -> ((DocumentModel)doc).getId();
            log.debug("Document {} is a version, it cannot be adapted as a FileSystemItem.", supplierArray);
            return false;
        }
        if (doc.isProxy()) {
            Supplier[] supplierArray = new Supplier[1];
            supplierArray[0] = () -> ((DocumentModel)doc).getId();
            log.debug("Document {} is a proxy, it cannot be adapted as a FileSystemItem.", supplierArray);
            return false;
        }
        if (doc.hasFacet("HiddenInNavigation")) {
            Supplier[] supplierArray = new Supplier[1];
            supplierArray[0] = () -> ((DocumentModel)doc).getId();
            log.debug("Document {} is HiddenInNavigation, it cannot be adapted as a FileSystemItem.", supplierArray);
            return false;
        }
        if (!includeDeleted && doc.isTrashed()) {
            Supplier[] supplierArray = new Supplier[1];
            supplierArray[0] = () -> ((DocumentModel)doc).getId();
            log.debug("Document {} is in the trash, it cannot be adapted as a FileSystemItem.", supplierArray);
            return false;
        }
        if (!relaxSyncRootConstraint && !(isSyncRoot = (nuxeoDriveManager = (NuxeoDriveManager)Framework.getService(NuxeoDriveManager.class)).isSynchronizationRoot(principal = doc.getPrincipal(), doc))) {
            Supplier[] supplierArray = new Supplier[2];
            supplierArray[0] = () -> ((DocumentModel)doc).getId();
            supplierArray[1] = () -> principal.getName();
            log.debug("Document {} is not a registered synchronization root for user {}, it cannot be adapted as a FileSystemItem.", supplierArray);
            return false;
        }
        return true;
    }

    @Override
    public FileSystemItem getFileSystemItem(DocumentModel doc, boolean includeDeleted) {
        return this.getFileSystemItem(doc, this.getParentItem(doc), includeDeleted);
    }

    @Override
    public FileSystemItem getFileSystemItem(DocumentModel doc, boolean includeDeleted, boolean relaxSyncRootConstraint) {
        return this.getFileSystemItem(doc, this.getParentItem(doc), includeDeleted, relaxSyncRootConstraint);
    }

    @Override
    public FileSystemItem getFileSystemItem(DocumentModel doc, boolean includeDeleted, boolean relaxSyncRootConstraint, boolean getLockInfo) {
        return this.getFileSystemItem(doc, this.getParentItem(doc), includeDeleted, relaxSyncRootConstraint, getLockInfo);
    }
}

