/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.drive.service.impl;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.nuxeo.drive.adapter.FileSystemItem;
import org.nuxeo.drive.adapter.FolderItem;
import org.nuxeo.drive.adapter.impl.CollectionSyncRootFolderItem;
import org.nuxeo.drive.service.NuxeoDriveManager;
import org.nuxeo.drive.service.impl.DefaultSyncRootFolderItemFactory;
import org.nuxeo.ecm.collections.api.CollectionManager;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.runtime.api.Framework;

public class CollectionSyncRootFolderItemFactory
extends DefaultSyncRootFolderItemFactory {
    private static final Logger log = LogManager.getLogger(CollectionSyncRootFolderItemFactory.class);
    public static final String FACTORY_NAME = "collectionSyncRootFolderItemFactory";

    @Override
    public boolean isFileSystemItem(DocumentModel doc, boolean includeDeleted, boolean relaxSyncRootConstraint) {
        NuxeoPrincipal principal;
        NuxeoDriveManager nuxeoDriveManager;
        boolean isSyncRoot;
        if (!((CollectionManager)Framework.getService(CollectionManager.class)).isCollection(doc)) {
            Supplier[] supplierArray = new Supplier[1];
            supplierArray[0] = () -> ((DocumentModel)doc).getId();
            log.debug("Document {} is not a Collection, it cannot be adapted as a FileSystemItem.", supplierArray);
            return false;
        }
        if (doc.hasFacet("HiddenInNavigation")) {
            Supplier[] supplierArray = new Supplier[1];
            supplierArray[0] = () -> ((DocumentModel)doc).getId();
            log.debug("Document {} is HiddenInNavigation, it cannot be adapted as a FileSystemItem.", supplierArray);
            return false;
        }
        if (!includeDeleted && doc.isTrashed()) {
            Supplier[] supplierArray = new Supplier[1];
            supplierArray[0] = () -> ((DocumentModel)doc).getId();
            log.debug("Document {} is in the trash, it cannot be adapted as a FileSystemItem.", supplierArray);
            return false;
        }
        if (!relaxSyncRootConstraint && !(isSyncRoot = (nuxeoDriveManager = (NuxeoDriveManager)Framework.getService(NuxeoDriveManager.class)).isSynchronizationRoot(principal = doc.getPrincipal(), doc))) {
            Supplier[] supplierArray = new Supplier[2];
            supplierArray[0] = () -> ((DocumentModel)doc).getId();
            supplierArray[1] = () -> principal.getName();
            log.debug("Document {} is not a registered synchronization root for user {}, it cannot be adapted as a FileSystemItem.", supplierArray);
            return false;
        }
        return true;
    }

    @Override
    protected FileSystemItem adaptDocument(DocumentModel doc, boolean forceParentItem, FolderItem parentItem, boolean relaxSyncRootConstraint, boolean getLockInfo) {
        return new CollectionSyncRootFolderItem(this.name, parentItem, doc, relaxSyncRootConstraint, getLockInfo);
    }
}

