/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.drive.service.impl;

import java.util.Calendar;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.nuxeo.drive.adapter.FileSystemItem;
import org.nuxeo.drive.adapter.FolderItem;
import org.nuxeo.drive.adapter.impl.DocumentBackedFileItem;
import org.nuxeo.drive.adapter.impl.DocumentBackedFolderItem;
import org.nuxeo.drive.service.NuxeoDriveManager;
import org.nuxeo.drive.service.VersioningFileSystemItemFactory;
import org.nuxeo.drive.service.impl.AbstractFileSystemItemFactory;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.VersioningOption;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.blob.BlobManager;
import org.nuxeo.ecm.core.blob.BlobProvider;
import org.nuxeo.runtime.api.Framework;

public class DefaultFileSystemItemFactory
extends AbstractFileSystemItemFactory
implements VersioningFileSystemItemFactory {
    private static final Logger log = LogManager.getLogger(DefaultFileSystemItemFactory.class);
    @Deprecated
    protected static final String VERSIONING_DELAY_PARAM = "versioningDelay";
    @Deprecated
    protected static final String VERSIONING_OPTION_PARAM = "versioningOption";
    @Deprecated
    protected double versioningDelay = 3600.0;
    @Deprecated
    protected VersioningOption versioningOption = VersioningOption.MINOR;

    @Override
    public void handleParameters(Map<String, String> parameters) {
        String versioningOptionParam;
        String versioningDelayParam = parameters.get(VERSIONING_DELAY_PARAM);
        if (!StringUtils.isEmpty((CharSequence)versioningDelayParam)) {
            this.versioningDelay = Double.parseDouble(versioningDelayParam);
        }
        if (!StringUtils.isEmpty((CharSequence)(versioningOptionParam = parameters.get(VERSIONING_OPTION_PARAM)))) {
            this.versioningOption = VersioningOption.valueOf((String)versioningOptionParam);
        }
    }

    @Override
    public boolean isFileSystemItem(DocumentModel doc, boolean includeDeleted, boolean relaxSyncRootConstraint) {
        NuxeoPrincipal principal;
        NuxeoDriveManager nuxeoDriveManager;
        boolean isSyncRoot;
        if (doc.isVersion()) {
            Supplier[] supplierArray = new Supplier[1];
            supplierArray[0] = () -> ((DocumentModel)doc).getId();
            log.debug("Document {} is a version, it cannot be adapted as a FileSystemItem.", supplierArray);
            return false;
        }
        if ("Collections".equals(doc.getType())) {
            Supplier[] supplierArray = new Supplier[3];
            supplierArray[0] = () -> ((DocumentModel)doc).getId();
            supplierArray[1] = () -> "Collections";
            supplierArray[2] = () -> ((DocumentModel)doc).getPathAsString();
            log.debug("Document {} is the collection root folder (type={}, path={}), it cannot be adapted as a FileSystemItem.", supplierArray);
            return false;
        }
        if (doc.hasFacet("HiddenInNavigation")) {
            Supplier[] supplierArray = new Supplier[1];
            supplierArray[0] = () -> ((DocumentModel)doc).getId();
            log.debug("Document {} is HiddenInNavigation, it cannot be adapted as a FileSystemItem.", supplierArray);
            return false;
        }
        if (!includeDeleted && doc.isTrashed()) {
            Supplier[] supplierArray = new Supplier[1];
            supplierArray[0] = () -> ((DocumentModel)doc).getId();
            log.debug("Document {} is trashed, it cannot be adapted as a FileSystemItem.", supplierArray);
            return false;
        }
        Blob blob = null;
        try {
            blob = this.getBlob(doc);
        }
        catch (NuxeoException e) {
            Supplier[] supplierArray = new Supplier[2];
            supplierArray[0] = () -> ((DocumentModel)doc).getId();
            supplierArray[1] = () -> e;
            log.error("Error while fetching blob for document {}, it cannot be adapted as a FileSystemItem.", supplierArray);
            return false;
        }
        if (!doc.isFolder()) {
            if (blob == null) {
                Supplier[] supplierArray = new Supplier[1];
                supplierArray[0] = () -> ((DocumentModel)doc).getId();
                log.debug("Document {} is not Folderish nor a BlobHolder with a blob, it cannot be adapted as a FileSystemItem.", supplierArray);
                return false;
            }
            BlobManager blobManager = (BlobManager)Framework.getService(BlobManager.class);
            BlobProvider blobProvider = blobManager.getBlobProvider(blob);
            if (blobProvider != null && !blobProvider.supportsSync()) {
                Supplier[] supplierArray = new Supplier[1];
                supplierArray[0] = () -> ((DocumentModel)doc).getId();
                log.debug("Blob for Document {} is backed by a BlobProvider preventing sync, it cannot be adapted as a FileSystemItem.", supplierArray);
                return false;
            }
            if (blobProvider == null && !doc.getType().equals("Note")) {
                Supplier[] supplierArray = new Supplier[1];
                supplierArray[0] = () -> ((DocumentModel)doc).getId();
                log.debug("Document {} has no BlobProvider and is not a Note, it cannot be adapted as a FileSystemItem.", supplierArray);
                return false;
            }
        }
        if (!relaxSyncRootConstraint && doc.isFolder() && (isSyncRoot = (nuxeoDriveManager = (NuxeoDriveManager)Framework.getService(NuxeoDriveManager.class)).isSynchronizationRoot(principal = doc.getPrincipal(), doc))) {
            Supplier[] supplierArray = new Supplier[2];
            supplierArray[0] = () -> ((DocumentModel)doc).getId();
            supplierArray[1] = () -> principal.getName();
            log.debug("Document {} is a registered synchronization root for user {}, it cannot be adapted as a DefaultFileSystemItem.", supplierArray);
            return false;
        }
        return true;
    }

    @Override
    protected FileSystemItem adaptDocument(DocumentModel doc, boolean forceParentItem, FolderItem parentItem, boolean relaxSyncRootConstraint, boolean getLockInfo) {
        if (doc.isFolder()) {
            if (forceParentItem) {
                return new DocumentBackedFolderItem(this.name, parentItem, doc, relaxSyncRootConstraint, getLockInfo);
            }
            return new DocumentBackedFolderItem(this.name, doc, relaxSyncRootConstraint, getLockInfo);
        }
        if (forceParentItem) {
            return new DocumentBackedFileItem(this, parentItem, doc, relaxSyncRootConstraint, getLockInfo);
        }
        return new DocumentBackedFileItem((VersioningFileSystemItemFactory)this, doc, relaxSyncRootConstraint, getLockInfo);
    }

    @Override
    @Deprecated
    public boolean needsVersioning(DocumentModel doc) {
        long versioningDelayMillis;
        boolean contributorChanged;
        String lastContributor = (String)((Object)doc.getPropertyValue("dc:lastContributor"));
        NuxeoPrincipal principal = doc.getPrincipal();
        boolean bl = contributorChanged = !principal.getName().equals(lastContributor);
        if (contributorChanged) {
            log.debug("Contributor {} is different from the last contributor {} => will create a version of the document.", (Object)principal, (Object)lastContributor);
            return true;
        }
        Calendar lastModificationDate = (Calendar)doc.getPropertyValue("dc:modified");
        if (lastModificationDate == null) {
            log.debug("Last modification date is null => will create a version of the document.");
            return true;
        }
        long lastModified = System.currentTimeMillis() - lastModificationDate.getTimeInMillis();
        if (lastModified > (versioningDelayMillis = (long)this.getVersioningDelay() * 1000L)) {
            log.debug("Last modification was done {} milliseconds ago, this is more than the versioning delay {} milliseconds => will create a version of the document.", (Object)lastModified, (Object)versioningDelayMillis);
            return true;
        }
        log.debug("Contributor {} is the last contributor and last modification was done {} milliseconds ago, this is less than the versioning delay {} milliseconds => will not create a version of the document.", (Object)principal, (Object)lastModified, (Object)versioningDelayMillis);
        return false;
    }

    @Override
    @Deprecated
    public double getVersioningDelay() {
        return this.versioningDelay;
    }

    @Override
    @Deprecated
    public void setVersioningDelay(double versioningDelay) {
        this.versioningDelay = versioningDelay;
    }

    @Override
    @Deprecated
    public VersioningOption getVersioningOption() {
        return this.versioningOption;
    }

    @Override
    @Deprecated
    public void setVersioningOption(VersioningOption versioningOption) {
        this.versioningOption = versioningOption;
    }

    protected Blob getBlob(DocumentModel doc) {
        BlobHolder bh = (BlobHolder)doc.getAdapter(BlobHolder.class);
        if (bh == null) {
            Supplier[] supplierArray = new Supplier[1];
            supplierArray[0] = () -> ((DocumentModel)doc).getId();
            log.debug("Document {} is not a BlobHolder.", supplierArray);
            return null;
        }
        Blob blob = bh.getBlob();
        if (blob == null) {
            Supplier[] supplierArray = new Supplier[1];
            supplierArray[0] = () -> ((DocumentModel)doc).getId();
            log.debug("Document {} is a BlobHolder without a blob.", supplierArray);
        }
        return blob;
    }
}

