/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.liveconnect.onedrive;

import com.google.api.client.auth.oauth2.Credential;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.nuxeo.ecm.core.blob.BlobManager;
import org.nuxeo.ecm.core.blob.ManagedBlob;
import org.nuxeo.ecm.core.blob.apps.AppLink;
import org.nuxeo.ecm.liveconnect.core.AbstractLiveConnectBlobProvider;
import org.nuxeo.ecm.liveconnect.core.LiveConnectFile;
import org.nuxeo.ecm.liveconnect.core.LiveConnectFileInfo;
import org.nuxeo.ecm.liveconnect.onedrive.OneDriveLiveConnectFile;
import org.nuxeo.ecm.liveconnect.onedrive.OneDriveOAuth2ServiceProvider;
import org.nuxeo.ecm.platform.web.common.vh.VirtualHostHelper;
import org.nuxeo.onedrive.client.OneDriveAPI;
import org.nuxeo.onedrive.client.OneDriveExpand;
import org.nuxeo.onedrive.client.OneDriveFile;
import org.nuxeo.onedrive.client.OneDriveSharingLink;
import org.nuxeo.onedrive.client.OneDriveThumbnailSize;
import org.nuxeo.runtime.api.Framework;

public class OneDriveBlobProvider
extends AbstractLiveConnectBlobProvider<OneDriveOAuth2ServiceProvider> {
    private static final String CACHE_NAME = "onedrive";
    private static final String ONEDRIVE_DOCUMENT_TO_BE_UPDATED_PP = "onedrive_document_to_be_updated";

    protected String getCacheName() {
        return CACHE_NAME;
    }

    protected String getPageProviderNameForUpdate() {
        return ONEDRIVE_DOCUMENT_TO_BE_UPDATED_PP;
    }

    public URI getURI(ManagedBlob blob, BlobManager.UsageHint usage, HttpServletRequest servletRequest) throws IOException {
        LiveConnectFileInfo fileInfo = this.toFileInfo(blob);
        String url = null;
        switch (usage) {
            case STREAM: 
            case DOWNLOAD: {
                url = this.prepareOneDriveFile(fileInfo).getMetadata(new OneDriveExpand[0]).getDownloadUrl();
                break;
            }
            case VIEW: 
            case EDIT: {
                url = this.prepareOneDriveFile(fileInfo).createSharedLink(OneDriveSharingLink.Type.EDIT).getLink().getWebUrl();
            }
        }
        return url == null ? null : this.asURI(url);
    }

    public InputStream getStream(ManagedBlob blob) throws IOException {
        return this.prepareOneDriveFile(this.toFileInfo(blob)).download();
    }

    public InputStream getThumbnail(ManagedBlob blob) throws IOException {
        return this.prepareOneDriveFile(this.toFileInfo(blob)).downloadThumbnail(OneDriveThumbnailSize.LARGE);
    }

    public List<AppLink> getAppLinks(String username, ManagedBlob blob) throws IOException {
        if (!blob.getMimeType().contains("officedocument")) {
            return Collections.emptyList();
        }
        LiveConnectFileInfo fileInfo = this.toFileInfo(blob);
        if (fileInfo.getRevisionId().isPresent()) {
            return Collections.emptyList();
        }
        String baseUrl = Framework.getProperty((String)"nuxeo.url", (String)VirtualHostHelper.getContextPathProperty());
        AppLink appLink = new AppLink();
        String appUrl = this.prepareOneDriveFile(fileInfo).createSharedLink(OneDriveSharingLink.Type.EDIT).getLink().getWebUrl();
        appLink.setLink(appUrl);
        appLink.setAppName("Microsoft OneDrive");
        appLink.setIcon(baseUrl + "/icons/OneDrive.png");
        return Collections.singletonList(appLink);
    }

    protected OneDriveAPI getOneDriveAPI(LiveConnectFileInfo fileInfo) throws IOException {
        return this.getOneDriveAPI(this.getCredential(fileInfo));
    }

    protected OneDriveAPI getOneDriveAPI(Credential credential) {
        return ((OneDriveOAuth2ServiceProvider)this.getOAuth2Provider()).getAPIInitializer().apply(credential.getAccessToken());
    }

    protected LiveConnectFile retrieveFile(LiveConnectFileInfo fileInfo) throws IOException {
        return new OneDriveLiveConnectFile(fileInfo, this.retrieveOneDriveFileMetadata(fileInfo));
    }

    protected OneDriveFile.Metadata retrieveOneDriveFileMetadata(LiveConnectFileInfo fileInfo) throws IOException {
        return this.prepareOneDriveFile(fileInfo).getMetadata(new OneDriveExpand[0]);
    }

    protected OneDriveFile prepareOneDriveFile(LiveConnectFileInfo fileInfo) throws IOException {
        OneDriveAPI api = this.getOneDriveAPI(fileInfo);
        return new OneDriveFile(api, fileInfo.getFileId());
    }
}

