/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.files;

import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.dropbox.core.util.LangUtil;
import com.dropbox.core.v2.files.FileSharingInfo;
import com.dropbox.core.v2.files.MediaInfo;
import com.dropbox.core.v2.files.Metadata;
import com.dropbox.core.v2.properties.PropertyGroup;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.regex.Pattern;

public class FileMetadata
extends Metadata {
    protected final String id;
    protected final Date clientModified;
    protected final Date serverModified;
    protected final String rev;
    protected final long size;
    protected final MediaInfo mediaInfo;
    protected final FileSharingInfo sharingInfo;
    protected final List<PropertyGroup> propertyGroups;
    protected final Boolean hasExplicitSharedMembers;

    public FileMetadata(String name, String id, Date clientModified, Date serverModified, String rev, long size, String pathLower, String pathDisplay, String parentSharedFolderId, MediaInfo mediaInfo, FileSharingInfo sharingInfo, List<PropertyGroup> propertyGroups, Boolean hasExplicitSharedMembers) {
        super(name, pathLower, pathDisplay, parentSharedFolderId);
        if (id == null) {
            throw new IllegalArgumentException("Required value for 'id' is null");
        }
        if (id.length() < 1) {
            throw new IllegalArgumentException("String 'id' is shorter than 1");
        }
        this.id = id;
        if (clientModified == null) {
            throw new IllegalArgumentException("Required value for 'clientModified' is null");
        }
        this.clientModified = LangUtil.truncateMillis(clientModified);
        if (serverModified == null) {
            throw new IllegalArgumentException("Required value for 'serverModified' is null");
        }
        this.serverModified = LangUtil.truncateMillis(serverModified);
        if (rev == null) {
            throw new IllegalArgumentException("Required value for 'rev' is null");
        }
        if (rev.length() < 9) {
            throw new IllegalArgumentException("String 'rev' is shorter than 9");
        }
        if (!Pattern.matches("[0-9a-f]+", rev)) {
            throw new IllegalArgumentException("String 'rev' does not match pattern");
        }
        this.rev = rev;
        this.size = size;
        this.mediaInfo = mediaInfo;
        this.sharingInfo = sharingInfo;
        if (propertyGroups != null) {
            for (PropertyGroup x : propertyGroups) {
                if (x != null) continue;
                throw new IllegalArgumentException("An item in list 'propertyGroups' is null");
            }
        }
        this.propertyGroups = propertyGroups;
        this.hasExplicitSharedMembers = hasExplicitSharedMembers;
    }

    public FileMetadata(String name, String id, Date clientModified, Date serverModified, String rev, long size) {
        this(name, id, clientModified, serverModified, rev, size, null, null, null, null, null, null, null);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getId() {
        return this.id;
    }

    public Date getClientModified() {
        return this.clientModified;
    }

    public Date getServerModified() {
        return this.serverModified;
    }

    public String getRev() {
        return this.rev;
    }

    public long getSize() {
        return this.size;
    }

    @Override
    public String getPathLower() {
        return this.pathLower;
    }

    @Override
    public String getPathDisplay() {
        return this.pathDisplay;
    }

    @Override
    public String getParentSharedFolderId() {
        return this.parentSharedFolderId;
    }

    public MediaInfo getMediaInfo() {
        return this.mediaInfo;
    }

    public FileSharingInfo getSharingInfo() {
        return this.sharingInfo;
    }

    public List<PropertyGroup> getPropertyGroups() {
        return this.propertyGroups;
    }

    public Boolean getHasExplicitSharedMembers() {
        return this.hasExplicitSharedMembers;
    }

    public static Builder newBuilder(String name, String id, Date clientModified, Date serverModified, String rev, long size) {
        return new Builder(name, id, clientModified, serverModified, rev, size);
    }

    @Override
    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.id, this.clientModified, this.serverModified, this.rev, this.size, this.mediaInfo, this.sharingInfo, this.propertyGroups, this.hasExplicitSharedMembers});
        hash = 31 * super.hashCode() + hash;
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj.getClass().equals(this.getClass())) {
            FileMetadata other = (FileMetadata)obj;
            return !(this.name != other.name && !this.name.equals(other.name) || this.id != other.id && !this.id.equals(other.id) || this.clientModified != other.clientModified && !this.clientModified.equals(other.clientModified) || this.serverModified != other.serverModified && !this.serverModified.equals(other.serverModified) || this.rev != other.rev && !this.rev.equals(other.rev) || this.size != other.size || this.pathLower != other.pathLower && (this.pathLower == null || !this.pathLower.equals(other.pathLower)) || this.pathDisplay != other.pathDisplay && (this.pathDisplay == null || !this.pathDisplay.equals(other.pathDisplay)) || this.parentSharedFolderId != other.parentSharedFolderId && (this.parentSharedFolderId == null || !this.parentSharedFolderId.equals(other.parentSharedFolderId)) || this.mediaInfo != other.mediaInfo && (this.mediaInfo == null || !this.mediaInfo.equals(other.mediaInfo)) || this.sharingInfo != other.sharingInfo && (this.sharingInfo == null || !this.sharingInfo.equals(other.sharingInfo)) || this.propertyGroups != other.propertyGroups && (this.propertyGroups == null || !this.propertyGroups.equals(other.propertyGroups)) || this.hasExplicitSharedMembers != other.hasExplicitSharedMembers && (this.hasExplicitSharedMembers == null || !this.hasExplicitSharedMembers.equals(other.hasExplicitSharedMembers)));
        }
        return false;
    }

    @Override
    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    @Override
    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<FileMetadata> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(FileMetadata value, JsonGenerator g, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g.writeStartObject();
            }
            this.writeTag("file", g);
            g.writeFieldName("name");
            StoneSerializers.string().serialize(value.name, g);
            g.writeFieldName("id");
            StoneSerializers.string().serialize(value.id, g);
            g.writeFieldName("client_modified");
            StoneSerializers.timestamp().serialize(value.clientModified, g);
            g.writeFieldName("server_modified");
            StoneSerializers.timestamp().serialize(value.serverModified, g);
            g.writeFieldName("rev");
            StoneSerializers.string().serialize(value.rev, g);
            g.writeFieldName("size");
            StoneSerializers.uInt64().serialize((Long)value.size, g);
            if (value.pathLower != null) {
                g.writeFieldName("path_lower");
                StoneSerializers.nullable(StoneSerializers.string()).serialize(value.pathLower, g);
            }
            if (value.pathDisplay != null) {
                g.writeFieldName("path_display");
                StoneSerializers.nullable(StoneSerializers.string()).serialize(value.pathDisplay, g);
            }
            if (value.parentSharedFolderId != null) {
                g.writeFieldName("parent_shared_folder_id");
                StoneSerializers.nullable(StoneSerializers.string()).serialize(value.parentSharedFolderId, g);
            }
            if (value.mediaInfo != null) {
                g.writeFieldName("media_info");
                StoneSerializers.nullable(MediaInfo.Serializer.INSTANCE).serialize(value.mediaInfo, g);
            }
            if (value.sharingInfo != null) {
                g.writeFieldName("sharing_info");
                StoneSerializers.nullable(FileSharingInfo.Serializer.INSTANCE).serialize(value.sharingInfo, g);
            }
            if (value.propertyGroups != null) {
                g.writeFieldName("property_groups");
                StoneSerializers.nullable(StoneSerializers.list(PropertyGroup.Serializer.INSTANCE)).serialize(value.propertyGroups, g);
            }
            if (value.hasExplicitSharedMembers != null) {
                g.writeFieldName("has_explicit_shared_members");
                StoneSerializers.nullable(StoneSerializers.boolean_()).serialize(value.hasExplicitSharedMembers, g);
            }
            if (!collapse) {
                g.writeEndObject();
            }
        }

        @Override
        public FileMetadata deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            Boolean f_hasExplicitSharedMembers;
            List<PropertyGroup> f_propertyGroups;
            FileSharingInfo f_sharingInfo;
            MediaInfo f_mediaInfo;
            String f_parentSharedFolderId;
            String f_pathDisplay;
            String f_pathLower;
            Long f_size;
            String f_rev;
            Date f_serverModified;
            Date f_clientModified;
            String f_id;
            String f_name;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
                if ("file".equals(tag)) {
                    tag = null;
                }
            }
            if (tag == null) {
                f_name = null;
                f_id = null;
                f_clientModified = null;
                f_serverModified = null;
                f_rev = null;
                f_size = null;
                f_pathLower = null;
                f_pathDisplay = null;
                f_parentSharedFolderId = null;
                f_mediaInfo = null;
                f_sharingInfo = null;
                f_propertyGroups = null;
                f_hasExplicitSharedMembers = null;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("name".equals(field)) {
                        f_name = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    if ("id".equals(field)) {
                        f_id = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    if ("client_modified".equals(field)) {
                        f_clientModified = StoneSerializers.timestamp().deserialize(p);
                        continue;
                    }
                    if ("server_modified".equals(field)) {
                        f_serverModified = StoneSerializers.timestamp().deserialize(p);
                        continue;
                    }
                    if ("rev".equals(field)) {
                        f_rev = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    if ("size".equals(field)) {
                        f_size = StoneSerializers.uInt64().deserialize(p);
                        continue;
                    }
                    if ("path_lower".equals(field)) {
                        f_pathLower = StoneSerializers.nullable(StoneSerializers.string()).deserialize(p);
                        continue;
                    }
                    if ("path_display".equals(field)) {
                        f_pathDisplay = StoneSerializers.nullable(StoneSerializers.string()).deserialize(p);
                        continue;
                    }
                    if ("parent_shared_folder_id".equals(field)) {
                        f_parentSharedFolderId = StoneSerializers.nullable(StoneSerializers.string()).deserialize(p);
                        continue;
                    }
                    if ("media_info".equals(field)) {
                        f_mediaInfo = StoneSerializers.nullable(MediaInfo.Serializer.INSTANCE).deserialize(p);
                        continue;
                    }
                    if ("sharing_info".equals(field)) {
                        f_sharingInfo = StoneSerializers.nullable(FileSharingInfo.Serializer.INSTANCE).deserialize(p);
                        continue;
                    }
                    if ("property_groups".equals(field)) {
                        f_propertyGroups = StoneSerializers.nullable(StoneSerializers.list(PropertyGroup.Serializer.INSTANCE)).deserialize(p);
                        continue;
                    }
                    if ("has_explicit_shared_members".equals(field)) {
                        f_hasExplicitSharedMembers = StoneSerializers.nullable(StoneSerializers.boolean_()).deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                if (f_name == null) {
                    throw new JsonParseException(p, "Required field \"name\" missing.");
                }
                if (f_id == null) {
                    throw new JsonParseException(p, "Required field \"id\" missing.");
                }
                if (f_clientModified == null) {
                    throw new JsonParseException(p, "Required field \"client_modified\" missing.");
                }
                if (f_serverModified == null) {
                    throw new JsonParseException(p, "Required field \"server_modified\" missing.");
                }
                if (f_rev == null) {
                    throw new JsonParseException(p, "Required field \"rev\" missing.");
                }
                if (f_size == null) {
                    throw new JsonParseException(p, "Required field \"size\" missing.");
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            FileMetadata value = new FileMetadata(f_name, f_id, f_clientModified, f_serverModified, f_rev, f_size, f_pathLower, f_pathDisplay, f_parentSharedFolderId, f_mediaInfo, f_sharingInfo, f_propertyGroups, f_hasExplicitSharedMembers);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }

    public static class Builder
    extends Metadata.Builder {
        protected final String id;
        protected final Date clientModified;
        protected final Date serverModified;
        protected final String rev;
        protected final long size;
        protected MediaInfo mediaInfo;
        protected FileSharingInfo sharingInfo;
        protected List<PropertyGroup> propertyGroups;
        protected Boolean hasExplicitSharedMembers;

        protected Builder(String name, String id, Date clientModified, Date serverModified, String rev, long size) {
            super(name);
            if (id == null) {
                throw new IllegalArgumentException("Required value for 'id' is null");
            }
            if (id.length() < 1) {
                throw new IllegalArgumentException("String 'id' is shorter than 1");
            }
            this.id = id;
            if (clientModified == null) {
                throw new IllegalArgumentException("Required value for 'clientModified' is null");
            }
            this.clientModified = LangUtil.truncateMillis(clientModified);
            if (serverModified == null) {
                throw new IllegalArgumentException("Required value for 'serverModified' is null");
            }
            this.serverModified = LangUtil.truncateMillis(serverModified);
            if (rev == null) {
                throw new IllegalArgumentException("Required value for 'rev' is null");
            }
            if (rev.length() < 9) {
                throw new IllegalArgumentException("String 'rev' is shorter than 9");
            }
            if (!Pattern.matches("[0-9a-f]+", rev)) {
                throw new IllegalArgumentException("String 'rev' does not match pattern");
            }
            this.rev = rev;
            this.size = size;
            this.mediaInfo = null;
            this.sharingInfo = null;
            this.propertyGroups = null;
            this.hasExplicitSharedMembers = null;
        }

        public Builder withMediaInfo(MediaInfo mediaInfo) {
            this.mediaInfo = mediaInfo;
            return this;
        }

        public Builder withSharingInfo(FileSharingInfo sharingInfo) {
            this.sharingInfo = sharingInfo;
            return this;
        }

        public Builder withPropertyGroups(List<PropertyGroup> propertyGroups) {
            if (propertyGroups != null) {
                for (PropertyGroup x : propertyGroups) {
                    if (x != null) continue;
                    throw new IllegalArgumentException("An item in list 'propertyGroups' is null");
                }
            }
            this.propertyGroups = propertyGroups;
            return this;
        }

        public Builder withHasExplicitSharedMembers(Boolean hasExplicitSharedMembers) {
            this.hasExplicitSharedMembers = hasExplicitSharedMembers;
            return this;
        }

        @Override
        public Builder withPathLower(String pathLower) {
            super.withPathLower(pathLower);
            return this;
        }

        @Override
        public Builder withPathDisplay(String pathDisplay) {
            super.withPathDisplay(pathDisplay);
            return this;
        }

        @Override
        public Builder withParentSharedFolderId(String parentSharedFolderId) {
            super.withParentSharedFolderId(parentSharedFolderId);
            return this;
        }

        @Override
        public FileMetadata build() {
            return new FileMetadata(this.name, this.id, this.clientModified, this.serverModified, this.rev, this.size, this.pathLower, this.pathDisplay, this.parentSharedFolderId, this.mediaInfo, this.sharingInfo, this.propertyGroups, this.hasExplicitSharedMembers);
        }
    }
}

