/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.onedrive.client;

import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import com.eclipsesource.json.ParseException;
import org.nuxeo.onedrive.client.OneDriveIdentity;
import org.nuxeo.onedrive.client.OneDriveJsonObject;
import org.nuxeo.onedrive.client.OneDriveRuntimeException;

public class OneDriveSharingLink
extends OneDriveJsonObject {
    private boolean edit;
    private String webUrl;
    private OneDriveIdentity application;

    public OneDriveSharingLink(JsonObject json) {
        super(json);
    }

    public boolean isEdit() {
        return this.edit;
    }

    public String getWebUrl() {
        return this.webUrl;
    }

    public OneDriveIdentity getApplication() {
        return this.application;
    }

    @Override
    protected void parseMember(JsonObject.Member member) {
        super.parseMember(member);
        try {
            JsonValue value = member.getValue();
            String memberName = member.getName();
            if ("type".equals(memberName)) {
                this.edit = Type.EDIT.name().equalsIgnoreCase(value.asString());
            } else if ("webUrl".equals(memberName)) {
                this.webUrl = value.asString();
            } else if ("application".equals(memberName)) {
                this.application = new OneDriveIdentity(value.asObject());
            }
        }
        catch (ParseException e) {
            throw new OneDriveRuntimeException("Parse failed, maybe a bug in client.", e);
        }
    }

    public static enum Type {
        VIEW("view"),
        EDIT("edit");

        private String type;

        private Type(String type) {
            this.type = type;
        }

        public String getType() {
            return this.type;
        }
    }
}

