/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.multi.tenant;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.SystemPrincipal;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.runtime.api.Framework;

public class MultiTenantHelper {
    protected static final Integer CACHE_CONCURRENCY_LEVEL = 10;
    protected static final Integer CACHE_MAXIMUM_SIZE = 1000;
    protected static final Integer CACHE_TIMEOUT = 10;
    protected static final String NO_TENANT = "NO_TENANT";
    protected static final Cache<String, String> pathCache = CacheBuilder.newBuilder().concurrencyLevel(CACHE_CONCURRENCY_LEVEL.intValue()).maximumSize((long)CACHE_MAXIMUM_SIZE.intValue()).expireAfterWrite((long)CACHE_TIMEOUT.intValue(), TimeUnit.MINUTES).build();
    protected static final Cache<String, String> tenantBinding = CacheBuilder.newBuilder().concurrencyLevel(CACHE_CONCURRENCY_LEVEL.intValue()).maximumSize((long)CACHE_MAXIMUM_SIZE.intValue()).expireAfterWrite((long)CACHE_TIMEOUT.intValue(), TimeUnit.MINUTES).build();

    private MultiTenantHelper() {
    }

    public static String computeTenantAdministratorsGroup(String tenantId) {
        return "tenant-" + tenantId + "_tenantAdministrators";
    }

    public static String computeTenantMembersGroup(String tenantId) {
        return "tenant-" + tenantId + "_tenantMembers";
    }

    public static String getCurrentTenantId(Principal principal) {
        if (principal instanceof SystemPrincipal) {
            String originatingUser = ((SystemPrincipal)principal).getOriginatingUser();
            if (originatingUser != null) {
                return MultiTenantHelper.getTenantId(originatingUser);
            }
            return null;
        }
        return NuxeoPrincipal.getCurrent().getTenantId();
    }

    public static String getTenantId(String username) {
        UserManager userManager = (UserManager)Framework.getService(UserManager.class);
        String tenantId = null;
        DocumentModel userModel = userManager.getUserModel(username);
        if (userModel != null) {
            tenantId = (String)((Object)userModel.getPropertyValue("user:tenantId"));
        }
        return tenantId;
    }

    public static String getTenantDocumentPath(CoreSession session, final String tenantId) {
        final ArrayList paths = new ArrayList();
        String path = (String)pathCache.getIfPresent((Object)tenantId);
        if (path == null) {
            new UnrestrictedSessionRunner(session){

                public void run() {
                    String query = String.format("SELECT * FROM Document WHERE tenantconfig:tenantId = '%s'", tenantId);
                    DocumentModelList docs = this.session.query(query);
                    if (!docs.isEmpty()) {
                        paths.add(((DocumentModel)docs.get(0)).getPathAsString());
                    }
                }
            }.runUnrestricted();
            String string = path = paths.isEmpty() ? null : (String)paths.get(0);
            if (path != null) {
                pathCache.put((Object)tenantId, (Object)path);
            }
        }
        return path;
    }

    public static String getOwningTenantId(DocumentModel doc) {
        String tenantId = (String)tenantBinding.getIfPresent((Object)doc.getId());
        if (NO_TENANT.equals(tenantId)) {
            return null;
        }
        if (tenantId == null) {
            TenantIdFinder finder = new TenantIdFinder(doc);
            finder.runUnrestricted();
            tenantId = finder.getTenantId();
            if (tenantId == null) {
                tenantBinding.put((Object)doc.getId(), (Object)NO_TENANT);
            } else {
                tenantBinding.put((Object)doc.getId(), (Object)tenantId);
            }
        }
        return tenantId;
    }

    protected static class TenantIdFinder
    extends UnrestrictedSessionRunner {
        protected String tenantId;
        protected final DocumentModel target;

        protected TenantIdFinder(DocumentModel target) {
            super(target.getCoreSession());
            this.target = target;
        }

        public void run() {
            List parents = this.session.getParentDocuments(this.target.getRef());
            for (int i = parents.size() - 1; i >= 0; --i) {
                DocumentModel parent = (DocumentModel)parents.get(i);
                if (!parent.hasFacet("TenantConfig")) continue;
                this.tenantId = (String)((Object)parent.getPropertyValue("tenantconfig:tenantId"));
                return;
            }
        }

        public String getTenantId() {
            return this.tenantId;
        }
    }
}

