/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.multi.tenant.userworkspace;

import org.apache.commons.lang3.StringUtils;
import org.nuxeo.common.utils.Path;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.multi.tenant.MultiTenantHelper;
import org.nuxeo.ecm.multi.tenant.MultiTenantService;
import org.nuxeo.ecm.platform.userworkspace.core.service.DefaultUserWorkspaceServiceImpl;
import org.nuxeo.runtime.api.Framework;

public class MultiTenantUserWorkspaceService
extends DefaultUserWorkspaceServiceImpl {
    private static final long serialVersionUID = 1L;

    protected String getTenantId(CoreSession userCoreSession, String userName) {
        MultiTenantService multiTenantService;
        String tenantId = null;
        if (userName == null) {
            userName = userCoreSession.getPrincipal().getName();
        }
        if ((multiTenantService = (MultiTenantService)Framework.getService(MultiTenantService.class)).isTenantIsolationEnabled(userCoreSession)) {
            tenantId = MultiTenantHelper.getTenantId(userName);
        }
        return tenantId;
    }

    protected String computePathUserWorkspaceRoot(CoreSession userCoreSession, String userName) {
        String tenantId = this.getTenantId(userCoreSession, userName);
        if (StringUtils.isBlank((CharSequence)tenantId)) {
            return super.computePathUserWorkspaceRoot(userCoreSession, userName);
        }
        return this.computePathUserWorkspaceRootForTenant(userCoreSession, tenantId);
    }

    protected String computePathUserWorkspaceRootForTenant(CoreSession session, String tenantId) {
        String tenantDocumentPath = MultiTenantHelper.getTenantDocumentPath(session, tenantId);
        Path path = new Path(tenantDocumentPath);
        path = path.append("UserWorkspaces");
        return path.toString();
    }
}

