/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.scanimporter.listener;

import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventListener;
import org.nuxeo.ecm.platform.scanimporter.processor.ScannedFileImporter;

public class IngestionTrigger
implements EventListener {
    private static final Log log = LogFactory.getLog(IngestionTrigger.class);
    private static volatile boolean ingestionInProgress = false;
    public static final String START_EVENT = "ScanIngestionStart";

    public void handleEvent(Event event) {
        if (!START_EVENT.equals(event.getName())) {
            return;
        }
        if (ingestionInProgress) {
            log.info((Object)"Ingestion already in progress, waiting for next wake up");
            return;
        }
        log.info((Object)"Start injection process");
        ingestionInProgress = true;
        try {
            ScannedFileImporter importer = new ScannedFileImporter();
            if (event.getContext().getProperty("Testing") != null) {
                event.getContext().setProperty("Tested", (Serializable)Boolean.valueOf(true));
            } else {
                importer.doImport();
            }
        }
        finally {
            ingestionInProgress = false;
        }
    }
}

