/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.scanimporter.processor;

import java.io.IOException;
import java.util.HashMap;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.platform.importer.factories.DefaultDocumentModelFactory;
import org.nuxeo.ecm.platform.importer.factories.ImporterDocumentModelFactory;
import org.nuxeo.ecm.platform.importer.source.SourceNode;
import org.nuxeo.ecm.platform.scanimporter.processor.ScanedFileSourceNode;
import org.nuxeo.ecm.platform.scanimporter.processor.ScannedFileImporter;
import org.nuxeo.ecm.platform.scanimporter.service.ImporterConfig;
import org.nuxeo.ecm.platform.scanimporter.service.ScanFileBlobHolder;
import org.nuxeo.ecm.platform.scanimporter.service.ScannedFileMapperService;
import org.nuxeo.runtime.api.Framework;

public class ScanedFileFactory
extends DefaultDocumentModelFactory
implements ImporterDocumentModelFactory {
    protected static String targetContainerType = null;
    protected ImporterConfig config;

    public ScanedFileFactory(ImporterConfig config) {
        this.config = config;
    }

    protected String getTargetContainerType() {
        if (targetContainerType == null) {
            ScannedFileMapperService service = (ScannedFileMapperService)Framework.getService(ScannedFileMapperService.class);
            targetContainerType = service.getTargetContainerType();
        }
        return targetContainerType;
    }

    public DocumentModel createFolderishNode(CoreSession session, DocumentModel parent, SourceNode node) {
        DocumentModel doc;
        String docType = this.getTargetContainerType();
        Object name = this.getValidNameFromFileName(node.getName());
        boolean isUpdateDocument = false;
        PathRef ref = new PathRef(parent.getPathAsString(), (String)name);
        if (parent.getPathAsString().equals(this.config.getTargetPath()) && node.getSourcePath().equals(this.config.getSourcePath())) {
            if (!this.config.isCreateInitialFolder()) {
                return parent;
            }
            if (this.config.isMergeInitialFolder()) {
                if (session.exists((DocumentRef)ref)) {
                    return session.getDocument((DocumentRef)ref);
                }
            } else if (session.exists((DocumentRef)ref)) {
                if (this.config.isUpdate()) {
                    isUpdateDocument = true;
                } else {
                    name = (String)name + "-" + System.currentTimeMillis();
                }
            }
        } else if (session.exists((DocumentRef)ref) && this.config.isUpdate()) {
            isUpdateDocument = true;
        }
        HashMap options = new HashMap();
        if (isUpdateDocument) {
            doc = session.getDocument((DocumentRef)ref);
        } else {
            doc = session.createDocumentModel(docType, options);
            doc.setPathInfo(parent.getPathAsString(), (String)name);
            doc.setProperty("dublincore", "title", (Object)node.getName());
            doc = session.createDocument(doc);
        }
        return doc;
    }

    public DocumentModel createLeafNode(CoreSession session, DocumentModel parent, SourceNode node) throws IOException {
        BlobHolder bh = node.getBlobHolder();
        if (bh instanceof ScanFileBlobHolder) {
            ScanFileBlobHolder scanBH = (ScanFileBlobHolder)bh;
            String docType = scanBH.getTargetType();
            this.setLeafType(docType);
        }
        DocumentModel doc = this.defaultCreateLeafNode(session, parent, node);
        if (node instanceof ScanedFileSourceNode) {
            ScanedFileSourceNode scanNode = (ScanedFileSourceNode)node;
            ScannedFileImporter.addProcessedDescriptor(scanNode.getDescriptorFileName());
        }
        return doc;
    }

    protected DocumentModel defaultCreateLeafNode(CoreSession session, DocumentModel parent, SourceNode node) throws IOException {
        DocumentModel doc;
        BlobHolder bh = node.getBlobHolder();
        String name = this.getValidNameFromFileName(node.getName());
        node.getName();
        PathRef docRef = new PathRef(parent.getPathAsString(), name);
        boolean docExists = session.exists((DocumentRef)docRef);
        if (docExists && this.config.isUpdate()) {
            doc = session.getDocument((DocumentRef)docRef);
        } else {
            HashMap options = new HashMap();
            doc = session.createDocumentModel(this.leafType, options);
            doc.setPathInfo(parent.getPathAsString(), name);
            doc.setProperty("dublincore", "title", (Object)node.getName());
        }
        doc.setProperty("file", "content", (Object)bh.getBlob());
        doc = docExists && this.config.isUpdate() ? session.saveDocument(doc) : session.createDocument(doc);
        doc = this.setDocumentProperties(session, bh.getProperties(), doc);
        return doc;
    }
}

