/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.scanimporter.processor;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.api.blobholder.SimpleBlobHolder;
import org.nuxeo.ecm.platform.importer.source.FileSourceNode;
import org.nuxeo.ecm.platform.importer.source.SourceNode;
import org.nuxeo.ecm.platform.scanimporter.processor.XmlMetaDataFileFilter;
import org.nuxeo.ecm.platform.scanimporter.service.ScanFileBlobHolder;
import org.nuxeo.ecm.platform.scanimporter.service.ScannedFileMapperService;
import org.nuxeo.runtime.api.Framework;

public class ScanedFileSourceNode
extends FileSourceNode {
    private static final Log log = LogFactory.getLog(ScanedFileSourceNode.class);
    protected Map<String, Serializable> properties;
    protected ScanFileBlobHolder bh;
    protected static boolean useXMLMapping = true;

    public ScanedFileSourceNode(File file) {
        super(file);
    }

    public ScanedFileSourceNode(File file, ScanFileBlobHolder bh) {
        super(file);
        this.bh = bh;
    }

    public ScanedFileSourceNode(File file, Map<String, Serializable> properties) {
        super(file);
        this.properties = properties;
    }

    public BlobHolder getBlobHolder() throws IOException {
        if (this.bh == null) {
            return new SimpleBlobHolder(Blobs.createBlob((File)this.file));
        }
        return this.bh;
    }

    public List<SourceNode> getChildren() throws IOException {
        ArrayList<SourceNode> children = new ArrayList<SourceNode>();
        ScannedFileMapperService sfms = (ScannedFileMapperService)Framework.getService(ScannedFileMapperService.class);
        for (File child : this.file.listFiles()) {
            ScanFileBlobHolder bh;
            if (child.getName().endsWith(".xml") && useXMLMapping) {
                try {
                    bh = sfms.parseMetaData(child);
                    if (bh != null) {
                        children.add((SourceNode)new ScanedFileSourceNode(child, bh));
                        continue;
                    }
                    log.error((Object)(child.getAbsolutePath() + " can not be parsed "));
                }
                catch (IOException e) {
                    log.error((Object)"Error during properties parsing", (Throwable)e);
                }
                continue;
            }
            if (child.isDirectory()) {
                if (child.listFiles(new DirectoryFilter()).length > 0) {
                    children.add((SourceNode)new ScanedFileSourceNode(child));
                    continue;
                }
                if (useXMLMapping) {
                    if (child.list(new XmlMetaDataFileFilter()).length <= 0) continue;
                    children.add((SourceNode)new ScanedFileSourceNode(child));
                    continue;
                }
                if (child.list().length <= 0) continue;
                children.add((SourceNode)new ScanedFileSourceNode(child));
                continue;
            }
            if (useXMLMapping) continue;
            bh = new ScanFileBlobHolder(Blobs.createBlob((File)child), sfms.getTargetLeafType());
            children.add((SourceNode)new ScanedFileSourceNode(child, bh));
        }
        return children;
    }

    public String getName() {
        Blob blob;
        if (this.bh != null && (blob = this.bh.getBlob()) != null && blob.getFilename() != null) {
            return blob.getFilename();
        }
        return this.file.getName();
    }

    public String getDescriptorFileName() {
        return this.file.getAbsolutePath();
    }

    private class DirectoryFilter
    implements FileFilter {
        private DirectoryFilter() {
        }

        @Override
        public boolean accept(File file) {
            return file.isDirectory();
        }
    }
}

