/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.scanimporter.processor;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.platform.importer.base.GenericMultiThreadedImporter;
import org.nuxeo.ecm.platform.importer.factories.ImporterDocumentModelFactory;
import org.nuxeo.ecm.platform.importer.log.BasicLogger;
import org.nuxeo.ecm.platform.importer.log.ImporterLogger;
import org.nuxeo.ecm.platform.importer.service.DefaultImporterService;
import org.nuxeo.ecm.platform.importer.source.FileSourceNode;
import org.nuxeo.ecm.platform.importer.source.SourceNode;
import org.nuxeo.ecm.platform.scanimporter.processor.ScanedFileSourceNode;
import org.nuxeo.ecm.platform.scanimporter.service.ImporterConfig;
import org.nuxeo.ecm.platform.scanimporter.service.ScannedFileMapperService;
import org.nuxeo.runtime.api.Framework;

public class ScannedFileImporter {
    private static final Log log = LogFactory.getLog(ScannedFileImporter.class);
    protected static List<String> processedDescriptors;
    protected static ReentrantReadWriteLock processedLock;

    public ScannedFileImporter() {
        processedDescriptors = new ArrayList<String>();
    }

    public static void addProcessedDescriptor(String fileDesc) {
        processedLock.writeLock().lock();
        try {
            processedDescriptors.add(fileDesc);
            if (processedDescriptors.size() % 100 == 0) {
                ScannedFileImporter.doCleanUp();
            }
        }
        finally {
            processedLock.writeLock().unlock();
        }
    }

    protected static void doCleanUp() {
        String outPath;
        ScannedFileMapperService sfms = (ScannedFileMapperService)Framework.getService(ScannedFileMapperService.class);
        ImporterConfig config = sfms.getImporterConfig();
        File outDir = null;
        if (config != null && (outPath = config.getProcessedPath()) != null && !(outDir = new File(outPath)).exists()) {
            outDir = null;
        }
        for (String fileDesc : processedDescriptors) {
            File file = new File(fileDesc);
            if (!file.exists()) continue;
            if (outDir == null) {
                file.delete();
                continue;
            }
            Path source = file.toPath();
            Path target = outDir.toPath().resolve(file.getName());
            try {
                Files.move(source, target, new CopyOption[0]);
            }
            catch (IOException e) {
                log.error((Object)("An exception occured while moving " + source.getFileName()), (Throwable)e);
            }
        }
        processedDescriptors = new ArrayList<String>();
    }

    public void doImport() {
        ScannedFileMapperService sfms = (ScannedFileMapperService)Framework.getService(ScannedFileMapperService.class);
        ImporterConfig config = sfms.getImporterConfig();
        if (config == null) {
            log.error((Object)"No configuration can be found, exit importer");
            return;
        }
        File folder = new File(config.getSourcePath());
        this.doImport(folder, config);
    }

    public void doImport(File folder, ImporterConfig config) {
        if (folder == null || !folder.exists()) {
            throw new NuxeoException("Unable to access source folder " + folder);
        }
        if (config.getTargetPath() == null) {
            throw new NuxeoException("target path must be set");
        }
        if (folder.listFiles().length == 0) {
            log.info((Object)"Nothing to import exiting");
            return;
        }
        log.info((Object)("Starting import process on path " + config.getTargetPath() + " from source " + folder.getAbsolutePath()));
        SourceNode src = this.initSourceNode(folder);
        ScanedFileSourceNode.useXMLMapping = config.useXMLMapping();
        GenericMultiThreadedImporter importer = new GenericMultiThreadedImporter(src, config.getTargetPath(), Boolean.valueOf(!config.isCreateInitialFolder()), config.getBatchSize(), config.getNbThreads(), (ImporterLogger)new BasicLogger(log));
        ImporterDocumentModelFactory factory = this.initDocumentModelFactory(config);
        importer.setEnablePerfLogging(((DefaultImporterService)Framework.getService(DefaultImporterService.class)).getEnablePerfLogging());
        importer.setFactory(factory);
        importer.setTransactionTimeout(config.getTransactionTimeout().intValue());
        importer.run();
        log.info((Object)"Fininish moving files");
        ScannedFileImporter.doCleanUp();
        log.info((Object)"Ending import process");
    }

    private ImporterDocumentModelFactory initDocumentModelFactory(ImporterConfig config) {
        Class factoryClass = ((DefaultImporterService)Framework.getService(DefaultImporterService.class)).getDocModelFactoryClass();
        Constructor cst = null;
        try {
            try {
                cst = factoryClass.getConstructor(ImporterConfig.class);
                return (ImporterDocumentModelFactory)cst.newInstance(config);
            }
            catch (NoSuchMethodException e) {
                return (ImporterDocumentModelFactory)factoryClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
        }
        catch (ReflectiveOperationException e) {
            throw new NuxeoException((Throwable)e);
        }
    }

    private SourceNode initSourceNode(File file) {
        Class srcClass = ((DefaultImporterService)Framework.getService(DefaultImporterService.class)).getSourceNodeClass();
        if (!FileSourceNode.class.isAssignableFrom(srcClass)) {
            throw new NuxeoException("Waiting source node extending FileSourceNode for Scan Importer");
        }
        try {
            return (SourceNode)srcClass.getConstructor(File.class).newInstance(file);
        }
        catch (ReflectiveOperationException e) {
            throw new NuxeoException((Throwable)e);
        }
    }

    static {
        processedLock = new ReentrantReadWriteLock();
    }
}

