/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.scanimporter.service;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeList;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.ecm.platform.scanimporter.processor.DocumentTypeMapper;
import org.nuxeo.ecm.platform.scanimporter.service.ScanFileBlobMapping;
import org.nuxeo.ecm.platform.scanimporter.service.ScanFileFieldMapping;

@XObject(value="mapping")
public class ScanFileMappingDescriptor
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String DEFAULT_CONTAINER_TYPE = "Folder";
    public static final String DEFAULT_LEAF_TYPE = "File";
    private static final Log log = LogFactory.getLog(ScanFileMappingDescriptor.class);
    @XNode(value="targetContainerType")
    protected String targetContainerType = "Folder";
    @XNode(value="targetLeafType")
    protected String targetLeafType = "File";
    @XNode(value="targetLeafTypeMapper")
    protected Class<DocumentTypeMapper> mapperClass;
    protected DocumentTypeMapper leafTypeMapper = null;
    @XNodeList(value="fieldMappings/fieldMapping", type=ArrayList.class, componentType=ScanFileFieldMapping.class)
    private List<ScanFileFieldMapping> fieldMappings;
    @XNodeList(value="blobMappings/blobMapping", type=ArrayList.class, componentType=ScanFileBlobMapping.class)
    private List<ScanFileBlobMapping> blobMappings;

    public List<ScanFileFieldMapping> getFieldMappings() {
        return this.fieldMappings;
    }

    public List<ScanFileBlobMapping> getBlobMappings() {
        return this.blobMappings;
    }

    public String getTargetContainerType() {
        return this.targetContainerType;
    }

    public String getTargetLeafType() {
        return this.targetLeafType;
    }

    public DocumentTypeMapper getTargetLeafTypeMapper() {
        if (this.mapperClass == null) {
            return null;
        }
        if (this.leafTypeMapper == null) {
            try {
                this.leafTypeMapper = this.mapperClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ReflectiveOperationException e) {
                log.error((Object)"Unable to instanciate mapper class", (Throwable)e);
            }
        }
        return this.leafTypeMapper;
    }
}

