/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.scanimporter.service;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.tree.DefaultElement;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.platform.scanimporter.processor.DocumentTypeMapper;
import org.nuxeo.ecm.platform.scanimporter.service.ImporterConfig;
import org.nuxeo.ecm.platform.scanimporter.service.ScanFileBlobHolder;
import org.nuxeo.ecm.platform.scanimporter.service.ScanFileBlobMapping;
import org.nuxeo.ecm.platform.scanimporter.service.ScanFileFieldMapping;
import org.nuxeo.ecm.platform.scanimporter.service.ScanFileMappingDescriptor;
import org.nuxeo.ecm.platform.scanimporter.service.ScannedFileMapperService;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;

public class ScannedFileMapperComponent
extends DefaultComponent
implements ScannedFileMapperService {
    private static final Log log = LogFactory.getLog(ScannedFileMapperComponent.class);
    public static final String MAPPING_EP = "mapping";
    public static final String CONFIG_EP = "config";
    protected ScanFileMappingDescriptor mappingDesc = null;
    protected ImporterConfig config = null;

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (MAPPING_EP.equals(extensionPoint)) {
            this.mappingDesc = (ScanFileMappingDescriptor)contribution;
        } else if (CONFIG_EP.equals(extensionPoint)) {
            this.config = (ImporterConfig)contribution;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ScanFileBlobHolder parseMetaData(File xmlFile) throws IOException {
        void var6_11;
        Document xmlDoc;
        HashMap<String, Serializable> data = new HashMap<String, Serializable>();
        if (this.mappingDesc == null) {
            return null;
        }
        String xmlData = FileUtils.readFileToString((File)xmlFile, (Charset)StandardCharsets.UTF_8);
        try {
            xmlDoc = DocumentHelper.parseText((String)xmlData);
        }
        catch (DocumentException e) {
            throw new IOException(e);
        }
        for (ScanFileFieldMapping scanFileFieldMapping : this.mappingDesc.getFieldMappings()) {
            List nodes = xmlDoc.selectNodes(scanFileFieldMapping.getSourceXPath());
            if (nodes.size() == 1) {
                DefaultElement elem = (DefaultElement)nodes.get(0);
                String value = "TEXT".equals(scanFileFieldMapping.getSourceAttribute()) ? elem.getText() : elem.attribute(scanFileFieldMapping.getSourceAttribute()).getValue();
                String target = scanFileFieldMapping.getTargetXPath();
                if ("string".equalsIgnoreCase(scanFileFieldMapping.getTargetType())) {
                    data.put(target, (Serializable)((Object)value));
                    continue;
                }
                if ("integer".equalsIgnoreCase(scanFileFieldMapping.getTargetType())) {
                    data.put(target, Integer.valueOf(value));
                    continue;
                }
                if ("double".equalsIgnoreCase(scanFileFieldMapping.getTargetType())) {
                    data.put(target, Double.valueOf(value));
                    continue;
                }
                if ("date".equalsIgnoreCase(scanFileFieldMapping.getTargetType())) {
                    try {
                        data.put(target, scanFileFieldMapping.getDateFormat().parse(value));
                        continue;
                    }
                    catch (ParseException e) {
                        throw new IOException(e);
                    }
                }
                if ("boolean".equalsIgnoreCase(scanFileFieldMapping.getTargetType())) {
                    data.put(target, Boolean.valueOf(value));
                    continue;
                }
                log.error((Object)("Unknown target type, please look the scan importer configuration: " + scanFileFieldMapping.getTargetType()));
            }
            log.error((Object)("Mulliple or no element(s) found for: " + scanFileFieldMapping.sourceXPath + " for " + xmlFile.getAbsolutePath()));
        }
        ArrayList<Blob> blobs = new ArrayList<Blob>();
        for (ScanFileBlobMapping blobMap : this.mappingDesc.getBlobMappings()) {
            List nodes = xmlDoc.selectNodes(blobMap.getSourceXPath());
            for (Object node : nodes) {
                File file;
                DefaultElement elem = (DefaultElement)node;
                String filePath = elem.attributeValue(blobMap.getSourcePathAttribute());
                String fileName = elem.attributeValue(blobMap.getSourceFilenameAttribute());
                if (filePath.startsWith("$TMP")) {
                    filePath = filePath.replace("$TMP", Framework.getProperty((String)"nuxeo.import.tmpdir"));
                }
                if ((file = new File(filePath)).exists()) {
                    Blob blob = Blobs.createBlob((File)file);
                    if (fileName != null) {
                        blob.setFilename(fileName);
                    } else {
                        blob.setFilename(file.getName());
                    }
                    String target = blobMap.getTargetXPath();
                    if (target == null) {
                        blobs.add(blob);
                        continue;
                    }
                    data.put(target, (Serializable)blob);
                    continue;
                }
                log.error((Object)("File " + file.getAbsolutePath() + " is referenced by " + xmlFile.getAbsolutePath() + " but was not found"));
            }
        }
        String string = this.getTargetLeafType();
        DocumentTypeMapper mapper = this.mappingDesc.getTargetLeafTypeMapper();
        if (mapper != null) {
            String string2 = mapper.getTargetDocumentType(xmlDoc, xmlFile);
        }
        return new ScanFileBlobHolder(blobs, data, (String)var6_11);
    }

    public ScanFileMappingDescriptor getMappingDesc() {
        return this.mappingDesc;
    }

    @Override
    public String getTargetContainerType() {
        if (this.mappingDesc == null) {
            return "Folder";
        }
        return this.mappingDesc.getTargetContainerType();
    }

    @Override
    public String getTargetLeafType() {
        if (this.mappingDesc == null) {
            return "File";
        }
        return this.mappingDesc.getTargetLeafType();
    }

    @Override
    public ImporterConfig getImporterConfig() {
        return this.config;
    }
}

