/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.importer.service;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.platform.importer.base.GenericMultiThreadedImporter;
import org.nuxeo.ecm.platform.importer.base.ImporterRunnerConfiguration;
import org.nuxeo.ecm.platform.importer.executor.AbstractImporterExecutor;
import org.nuxeo.ecm.platform.importer.executor.DefaultImporterExecutor;
import org.nuxeo.ecm.platform.importer.factories.DefaultDocumentModelFactory;
import org.nuxeo.ecm.platform.importer.factories.ImporterDocumentModelFactory;
import org.nuxeo.ecm.platform.importer.filter.EventServiceConfiguratorFilter;
import org.nuxeo.ecm.platform.importer.log.ImporterLogger;
import org.nuxeo.ecm.platform.importer.service.DefaultImporterService;
import org.nuxeo.ecm.platform.importer.source.FileSourceNode;
import org.nuxeo.ecm.platform.importer.source.SourceNode;

public class DefaultImporterServiceImpl
implements DefaultImporterService {
    private static Log log = LogFactory.getLog(DefaultImporterServiceImpl.class);
    private Class<? extends ImporterDocumentModelFactory> docModelFactoryClass;
    private Class<? extends SourceNode> sourceNodeClass;
    private ImporterDocumentModelFactory documentModelFactory;
    private String folderishDocType;
    private String leafDocType;
    private ImporterLogger importerLogger;
    private int transactionTimeout = 0;
    private String repositoryName;
    private boolean bulkMode = true;
    protected boolean enablePerfLogging = true;

    @Override
    public void importDocuments(String destinationPath, String sourcePath, boolean skipRootContainerCreation, int batchSize, int noImportingThreads) {
        SourceNode sourceNode = this.createNewSourceNodeInstanceForSourcePath(sourcePath);
        if (sourceNode == null) {
            log.error((Object)"Need to set a sourceNode to be used by this importer");
            return;
        }
        if (this.getDocumentModelFactory() == null) {
            log.error((Object)"Need to set a documentModelFactory to be used by this importer");
        }
        DefaultImporterExecutor executor = new DefaultImporterExecutor(this.repositoryName);
        executor.setFactory(this.getDocumentModelFactory());
        executor.setTransactionTimeout(this.transactionTimeout);
        executor.run(sourceNode, destinationPath, (Boolean)skipRootContainerCreation, (Integer)batchSize, (Integer)noImportingThreads, (Boolean)true);
    }

    @Override
    public String importDocuments(AbstractImporterExecutor executor, String destinationPath, String sourcePath, boolean skipRootContainerCreation, int batchSize, int noImportingThreads, boolean interactive) {
        SourceNode sourceNode = this.createNewSourceNodeInstanceForSourcePath(sourcePath);
        if (sourceNode == null) {
            log.error((Object)"Need to set a sourceNode to be used by this importer");
            return "Can not import";
        }
        if (this.getDocumentModelFactory() == null) {
            log.error((Object)"Need to set a documentModelFactory to be used by this importer");
        }
        ImporterRunnerConfiguration configuration = new ImporterRunnerConfiguration.Builder(sourceNode, destinationPath, executor.getLogger()).skipRootContainerCreation(skipRootContainerCreation).batchSize(batchSize).nbThreads(noImportingThreads).repository(this.repositoryName).build();
        GenericMultiThreadedImporter runner = new GenericMultiThreadedImporter(configuration);
        runner.setEnablePerfLogging(this.enablePerfLogging);
        runner.setTransactionTimeout(this.transactionTimeout);
        EventServiceConfiguratorFilter filter = new EventServiceConfiguratorFilter(false, false, false, false, this.bulkMode);
        runner.addFilter(filter);
        runner.setFactory(this.getDocumentModelFactory());
        return executor.run(runner, interactive);
    }

    @Override
    public String importDocuments(AbstractImporterExecutor executor, String leafType, String folderishType, String destinationPath, String sourcePath, boolean skipRootContainerCreation, int batchSize, int noImportingThreads, boolean interactive) {
        ImporterDocumentModelFactory docModelFactory = this.getDocumentModelFactory();
        if (docModelFactory instanceof DefaultDocumentModelFactory) {
            DefaultDocumentModelFactory defaultDocModelFactory = (DefaultDocumentModelFactory)docModelFactory;
            defaultDocModelFactory.setLeafType(leafType == null ? this.getLeafDocType() : leafType);
            defaultDocModelFactory.setFolderishType(folderishType == null ? this.getFolderishDocType() : folderishType);
        }
        this.setDocumentModelFactory(docModelFactory);
        executor.setTransactionTimeout(this.transactionTimeout);
        String res = this.importDocuments(executor, destinationPath, sourcePath, skipRootContainerCreation, batchSize, noImportingThreads, interactive);
        this.setDocumentModelFactory(null);
        return res;
    }

    @Override
    public void setDocModelFactoryClass(Class<? extends ImporterDocumentModelFactory> docModelFactoryClass) {
        this.docModelFactoryClass = docModelFactoryClass;
    }

    @Override
    public void setSourceNodeClass(Class<? extends SourceNode> sourceNodeClass) {
        this.sourceNodeClass = sourceNodeClass;
    }

    protected SourceNode createNewSourceNodeInstanceForSourcePath(String sourcePath) {
        SourceNode sourceNode = null;
        if (this.sourceNodeClass != null && FileSourceNode.class.isAssignableFrom(this.sourceNodeClass)) {
            try {
                sourceNode = this.sourceNodeClass.getConstructor(String.class).newInstance(sourcePath);
            }
            catch (ReflectiveOperationException e) {
                log.error((Object)e, (Throwable)e);
            }
        }
        return sourceNode;
    }

    protected ImporterDocumentModelFactory getDocumentModelFactory() {
        if (this.documentModelFactory == null && this.docModelFactoryClass != null) {
            try {
                if (DefaultDocumentModelFactory.class.isAssignableFrom(this.docModelFactoryClass)) {
                    this.setDocumentModelFactory(this.docModelFactoryClass.getConstructor(String.class, String.class).newInstance(this.getFolderishDocType(), this.getLeafDocType()));
                } else {
                    this.setDocumentModelFactory(this.docModelFactoryClass.getConstructor(new Class[0]).newInstance(new Object[0]));
                }
            }
            catch (ReflectiveOperationException e) {
                throw new NuxeoException((Throwable)e);
            }
        }
        return this.documentModelFactory;
    }

    protected void setDocumentModelFactory(ImporterDocumentModelFactory documentModelFactory) {
        this.documentModelFactory = documentModelFactory;
    }

    public String getFolderishDocType() {
        return this.folderishDocType;
    }

    @Override
    public void setFolderishDocType(String folderishDocType) {
        this.folderishDocType = folderishDocType;
    }

    public String getLeafDocType() {
        return this.leafDocType;
    }

    @Override
    public void setLeafDocType(String fileDocType) {
        this.leafDocType = fileDocType;
    }

    public ImporterLogger getImporterLogger() {
        return this.importerLogger;
    }

    @Override
    public void setImporterLogger(ImporterLogger importerLogger) {
        this.importerLogger = importerLogger;
    }

    @Override
    public void setTransactionTimeout(int transactionTimeout) {
        this.transactionTimeout = transactionTimeout;
    }

    @Override
    public Class<? extends SourceNode> getSourceNodeClass() {
        return this.sourceNodeClass;
    }

    @Override
    public Class<? extends ImporterDocumentModelFactory> getDocModelFactoryClass() {
        return this.docModelFactoryClass;
    }

    @Override
    public void setRepository(String repositoryName) {
        this.repositoryName = repositoryName;
    }

    @Override
    public void setBulkMode(boolean bulkMode) {
        this.bulkMode = bulkMode;
    }

    @Override
    public void setEnablePerfLogging(boolean enablePerfLogging) {
        this.enablePerfLogging = enablePerfLogging;
    }

    @Override
    public boolean getEnablePerfLogging() {
        return this.enablePerfLogging;
    }
}

