/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.importer.source;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.api.blobholder.SimpleBlobHolder;
import org.nuxeo.ecm.core.api.blobholder.SimpleBlobHolderWithProperties;
import org.nuxeo.ecm.platform.importer.random.DictionaryHolder;
import org.nuxeo.ecm.platform.importer.random.HunspellDictionaryHolder;
import org.nuxeo.ecm.platform.importer.random.RandomTextGenerator;
import org.nuxeo.ecm.platform.importer.source.SourceNode;

public class RandomTextSourceNode
implements SourceNode {
    private static final Log log = LogFactory.getLog(RandomTextSourceNode.class);
    protected static RandomTextGenerator gen;
    protected static int maxNode;
    protected static boolean nonUniformRepartition;
    public static final int MAX_DEPTH = 8;
    public static final int DEFAULT_NB_DATA_NODES_PER_FOLDER = 100;
    public static final int BIG_NB_NODES_FACTOR = 50;
    public static final int SMALL_NB_BODES_DIVIDER = 100;
    protected static int minGlobalFolders;
    protected static int minFoldersPerNode;
    protected static AtomicInteger nbNodes;
    protected static AtomicInteger nbFolders;
    protected static AtomicInteger nbVisitedFolders;
    protected static AtomicLong size;
    protected static final Random RANDOM;
    protected String name;
    protected boolean folderish;
    protected int level = 0;
    protected int idx = 0;
    protected static Integer blobSizeInKB;
    protected List<SourceNode> cachedChildren = null;
    protected static final boolean CACHE_CHILDREN = false;
    protected boolean onlyText = true;
    protected boolean withProperties = false;
    protected static final String[] DC_NATURE;
    protected static final String[] DC_SUBJECTS;
    protected static final String[] DC_RIGHTS;
    protected static final String[] DC_LANGUAGE;
    protected static final String[] DC_SOURCE;
    protected static final String[] DC_COVERAGE;

    public RandomTextSourceNode(boolean folderish, int level, int idx, boolean onlyText, boolean withProperties) {
        this.folderish = folderish;
        this.level = level;
        this.idx = idx;
        this.onlyText = onlyText;
        this.withProperties = withProperties;
    }

    public RandomTextSourceNode(boolean folderish, int level, int idx, boolean onlyText) {
        this(folderish, level, idx, onlyText, false);
    }

    public static RandomTextSourceNode init(int maxSize) {
        return RandomTextSourceNode.init(maxSize, null, true);
    }

    public static RandomTextSourceNode init(int maxSize, Integer blobSizeInKB, boolean onlyText) {
        return RandomTextSourceNode.init(maxSize, blobSizeInKB, onlyText, false, false, null);
    }

    public static RandomTextSourceNode init(int maxSize, Integer blobSizeInKB, boolean onlyText, boolean nonUniform, boolean withProperties, String lang) {
        return RandomTextSourceNode.init(maxSize, blobSizeInKB, onlyText, new HunspellDictionaryHolder(lang), nonUniform, withProperties);
    }

    public static RandomTextSourceNode init(int maxSize, Integer blobSizeInKB, boolean onlyText, DictionaryHolder dictionaryHolder, boolean nonUniform, boolean withProperties) {
        gen = new RandomTextGenerator(dictionaryHolder);
        gen.prefilCache();
        maxNode = maxSize;
        nbNodes = new AtomicInteger(0);
        nbFolders = new AtomicInteger(1);
        nbVisitedFolders = new AtomicInteger(0);
        size = new AtomicLong(0L);
        RandomTextSourceNode.blobSizeInKB = blobSizeInKB;
        minGlobalFolders = maxNode / 100;
        minFoldersPerNode = 1 + (int)Math.pow(minGlobalFolders, 0.125);
        nonUniformRepartition = nonUniform;
        return new RandomTextSourceNode(true, 0, 0, onlyText, withProperties);
    }

    protected String getBlobMimeType() {
        if (this.onlyText) {
            return "text/plain";
        }
        return "text/partial";
    }

    private String capitalize(String line) {
        return Character.toUpperCase(line.charAt(0)) + line.substring(1);
    }

    @Override
    public BlobHolder getBlobHolder() {
        String content = null;
        if (this.folderish) {
            if (this.withProperties) {
                return new SimpleBlobHolderWithProperties((Blob)null, this.getRandomProperties(content));
            }
            return null;
        }
        content = blobSizeInKB == null ? gen.getRandomText() : gen.getRandomText(blobSizeInKB);
        size.addAndGet(content.length());
        Blob blob = Blobs.createBlob((String)content, (String)this.getBlobMimeType(), null, (String)(this.getName() + ".txt"));
        if (this.withProperties) {
            return new SimpleBlobHolderWithProperties(blob, this.getRandomProperties(content));
        }
        return new SimpleBlobHolder(blob);
    }

    protected Map<String, Serializable> getRandomProperties(String content) {
        HashMap<String, Serializable> ret = new HashMap<String, Serializable>();
        ret.put("dc:title", (Serializable)((Object)this.capitalize(this.getName())));
        if (RANDOM.nextInt(10) == 1) {
            String description = content != null && !content.isEmpty() ? content.substring(0, content.indexOf(32, 40)) : gen.getRandomTitle(RANDOM.nextInt(5) + 1);
            ret.put("dc:description", (Serializable)((Object)this.capitalize(description)));
        }
        ret.put("dc:nature", (Serializable)((Object)this.getGaussian(DC_NATURE)));
        ret.put("dc:subjects", (Serializable)((Object)Arrays.asList(this.getGaussian(DC_SUBJECTS))));
        ret.put("dc:rights", (Serializable)((Object)this.getGaussian(DC_RIGHTS)));
        ret.put("dc:language", (Serializable)((Object)this.getGaussian(DC_LANGUAGE)));
        ret.put("dc:coverage", (Serializable)((Object)this.getGaussian(DC_COVERAGE)));
        ret.put("dc:source", (Serializable)((Object)this.getGaussian(DC_SOURCE)));
        return ret;
    }

    protected String getGaussian(String[] words) {
        double g = Math.abs(RANDOM.nextGaussian() / 4.0);
        g = Math.min(g, 1.0);
        int i = (int)Math.floor(g * (double)(words.length - 1));
        return words[i];
    }

    protected int getMidRandom(int target) {
        return 1 + target / 2 + RANDOM.nextInt(target);
    }

    protected int getNonUniform(int target, boolean folderish) {
        int res;
        int remainder = nbVisitedFolders.get() % 10;
        if (remainder == 8) {
            res = 1 + target / 100;
            if (log.isDebugEnabled()) {
                String nodeStr = folderish ? "folderish" : "data";
                log.debug((Object)String.format("### Small number of %s nodes: %d", nodeStr, res));
            }
        } else if (remainder == 9) {
            int factor = folderish ? 5 : 50;
            res = 1 + target * factor;
            if (log.isDebugEnabled()) {
                String nodeStr = folderish ? "folderish" : "data";
                log.debug((Object)String.format("### Big number of %s nodes: %d", nodeStr, res));
            }
        } else {
            res = this.getMidRandom(target);
        }
        return res;
    }

    protected int getMaxChildren() {
        if (maxNode < nbNodes.get()) {
            return 0;
        }
        int targetRemainingFolders = minGlobalFolders - nbFolders.get();
        if (targetRemainingFolders <= 0) {
            return 101;
        }
        int target = (maxNode - nbNodes.get()) / targetRemainingFolders;
        if (target <= 0) {
            return 0;
        }
        if (nonUniformRepartition) {
            return this.getNonUniform(target, false);
        }
        return this.getMidRandom(target);
    }

    protected int getMaxFolderish() {
        if (maxNode <= nbNodes.get()) {
            return 0;
        }
        if (nonUniformRepartition) {
            return this.getNonUniform(minFoldersPerNode, true);
        }
        return this.getMidRandom(minFoldersPerNode);
    }

    @Override
    public List<SourceNode> getChildren() {
        if (!this.folderish) {
            return null;
        }
        if (this.cachedChildren != null) {
            return this.cachedChildren;
        }
        ArrayList<SourceNode> children = new ArrayList<SourceNode>();
        if (nbNodes.get() > maxNode) {
            return children;
        }
        int nbChildren = this.getMaxChildren();
        for (int i = 0; i < nbChildren; ++i) {
            children.add(new RandomTextSourceNode(false, this.level, i, this.onlyText, this.withProperties));
        }
        nbNodes.addAndGet(nbChildren);
        if (log.isDebugEnabled()) {
            String nodeStr = nbChildren > 1 ? "nodes" : "node";
            log.debug((Object)String.format("Added %s data %s to %s; data node total count = %s", nbChildren, nodeStr, this.getName(), nbNodes));
        }
        if (!(this.level >= 8 || nonUniformRepartition && nbChildren <= 0)) {
            int nbFolderish = this.getMaxFolderish();
            for (int i = 0; i < nbFolderish; ++i) {
                children.add(new RandomTextSourceNode(true, this.level + 1, i, this.onlyText, this.withProperties));
            }
            nbFolders.addAndGet(nbFolderish);
            if (log.isDebugEnabled()) {
                String nodeStr = nbFolderish > 1 ? "nodes" : "node";
                log.debug((Object)String.format("Added %s folderish %s to %s; folderish node total count = %s", nbFolderish, nodeStr, this.getName(), nbFolders));
            }
        }
        nbVisitedFolders.incrementAndGet();
        if (log.isDebugEnabled()) {
            String folderStr = nbVisitedFolders.get() > 1 ? "folders" : "folder";
            log.debug((Object)String.format("Visited %s %s", nbVisitedFolders, folderStr));
        }
        return children;
    }

    @Override
    public String getName() {
        if (this.name == null) {
            if (this.withProperties) {
                this.name = gen.getRandomTitle(RANDOM.nextInt(3) + 1);
            } else {
                this.name = this.folderish ? "folder" : "file";
                this.name = this.level == 0 && this.folderish ? this.name + "-" + System.currentTimeMillis() % 10000L + RANDOM.nextInt(100) : this.name + "-" + this.level + "-" + this.idx;
            }
        }
        return this.name;
    }

    @Override
    public boolean isFolderish() {
        return this.folderish;
    }

    public static Integer getNbNodes() {
        return nbNodes.get();
    }

    public static Long getSize() {
        return size.get();
    }

    public int getLevel() {
        return this.level;
    }

    @Override
    public String getSourcePath() {
        return null;
    }

    static {
        maxNode = 10000;
        nonUniformRepartition = false;
        minGlobalFolders = 0;
        minFoldersPerNode = 0;
        RANDOM = new Random();
        DC_NATURE = new String[]{"article", "acknowledgement", "assessment", "application", "order", "contract", "quotation", "fax", "worksheet", "letter", "memo", "note", "notification", "procedure", "report", "internshipReport", "pressReview"};
        DC_SUBJECTS = new String[]{"art/architecture", "art/comics", "art/cinema", "art/culture", "art/danse", "art/music", "sciences/astronomy", "sciences/biology", "sciences/chemistry", "sciences/math", "sciences/physic", "society/ecology", "daily life/gastronomy", "daily life/gardening", "daily life/sport", "technology/it"};
        DC_RIGHTS = new String[]{"OpenContentL", "CC-BY-NC", "CC-BY-ND", "FreeArt", "ODbi", "GNUGPL", "FreeBSD", "CC0"};
        DC_LANGUAGE = new String[]{"IT", "DE", "FR", "US", "EN"};
        DC_SOURCE = new String[]{"internal", "external", "unknown"};
        DC_COVERAGE = new String[]{"europe/France", "europe/Germany", "europe/Italy", "europe/Spain", "oceania/Tonga", "africa/Mali", "asia/Japan", "north-america/United_States_of_America"};
    }
}

