/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.launcher.connect;

import java.io.IOException;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.connect.NuxeoConnectClient;
import org.nuxeo.connect.connector.NuxeoClientInstanceType;
import org.nuxeo.connect.data.ConnectProject;
import org.nuxeo.connect.identity.LogicalInstanceIdentifier;
import org.nuxeo.connect.registration.ConnectRegistrationService;
import org.nuxeo.connect.registration.RegistrationException;
import org.nuxeo.connect.registration.RegistrationHelper;
import org.nuxeo.launcher.config.ConfigurationException;

public class ConnectRegistrationBroker {
    private static final Log log = LogFactory.getLog(ConnectRegistrationBroker.class);

    protected static ConnectRegistrationService registration() {
        return NuxeoConnectClient.getConnectRegistrationService();
    }

    public void registerLocal(String strCLID, String description) throws IOException, ConfigurationException {
        try {
            ConnectRegistrationBroker.registration().localRegisterInstance(strCLID, description);
        }
        catch (LogicalInstanceIdentifier.InvalidCLID e) {
            log.debug((Object)e, (Throwable)e);
            throw new ConfigurationException("Instance registration failed.", (Throwable)e);
        }
    }

    public void registerRemote(String username, char[] password, String projectId, NuxeoClientInstanceType type, String description) throws IOException, ConfigurationException {
        String strCLID = RegistrationHelper.remoteRegisterInstance((String)username, (String)new String(password), (String)projectId, (NuxeoClientInstanceType)type, (String)description);
        this.registerLocal(strCLID, description);
    }

    public void remoteRenewRegistration() throws IOException, RegistrationException {
        try {
            ConnectRegistrationBroker.registration().remoteRenewRegistration();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RegistrationException("Instance registration failed. " + e.getMessage());
        }
    }

    public ConnectProject getProjectByName(String projectName, List<ConnectProject> availableProjects) {
        Stream projectStream = availableProjects.stream();
        Optional<ConnectProject> pkg = projectStream.filter(availProject -> projectName.equalsIgnoreCase(availProject.getSymbolicName())).findFirst();
        if (!pkg.isPresent()) {
            return null;
        }
        return pkg.get();
    }

    public List<ConnectProject> getAvailableProjects(String username, char[] password) throws ConfigurationException {
        List studioProjects = ConnectRegistrationBroker.registration().getAvailableProjectsForRegistration(username, new String(password));
        if (studioProjects.isEmpty()) {
            throw new ConfigurationException("Wrong login or password.");
        }
        return studioProjects;
    }
}

