/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.launcher.config;

import java.io.File;
import java.nio.file.Path;
import java.util.Collection;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.SystemUtils;
import org.assertj.core.api.Assertions;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;
import org.nuxeo.launcher.config.AbstractConfigurationTest;
import org.nuxeo.launcher.config.BackingServiceConfigurator;
import org.nuxeo.launcher.config.ConfigurationException;
import org.nuxeo.launcher.config.ConfigurationGenerator;
import org.nuxeo.launcher.config.FakeCheck;

public class BackingServiceConfiguratorTest
extends AbstractConfigurationTest {
    private File bundles;
    private BackingServiceConfigurator bsc;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        Assume.assumeFalse((boolean)SystemUtils.IS_OS_WINDOWS);
        FakeCheck.reset();
        FakeCheck.setReady(true);
        FileUtils.copyDirectory((File)this.getResourceFile("templates/jboss"), (File)new File(this.nuxeoHome, "templates"));
        this.bundles = new File(this.nuxeoHome, "nxserver/bundles");
        this.bundles.mkdirs();
        FileUtils.copyFileToDirectory((File)this.getResourceFile("versioned-1.0.jar"), (File)this.bundles);
        this.configGenerator = new ConfigurationGenerator();
        this.bsc = new BackingServiceConfigurator(this.configGenerator);
        Assertions.assertThat((boolean)this.configGenerator.init()).isTrue();
        this.configGenerator.setProperty("nuxeo.home", this.nuxeoHome.getAbsolutePath());
        this.configGenerator.setProperty("nuxeo.backing.check.retry.maxRetries", "5");
        this.configGenerator.setProperty("nuxeo.backing.check.retry.delayInMs", "20");
    }

    @Test
    public void canReferenceRelativePathInClasspathEntry() throws Exception {
        Collection jars = this.bsc.getJarsFromClasspathEntry(this.getTemplateParentPath("backing"), "lib");
        Assertions.assertThat((Iterable)jars).hasSize(2);
        jars = this.bsc.getJarsFromClasspathEntry(this.getTemplateParentPath("backing"), "lib/fake.jar");
        Assertions.assertThat((Iterable)jars).hasSize(1);
    }

    @Test
    public void canReferenceAbsolutePathInClassPathEntry() throws Exception {
        Collection jars = this.bsc.getJarsFromClasspathEntry(this.getTemplateParentPath("backing"), this.bundles.getAbsolutePath());
        Assertions.assertThat((Iterable)jars).hasSize(1);
    }

    @Test
    public void cannotReferenceAbsolutPathOutsideOfNuxeoHome() throws Exception {
        Collection jars = this.bsc.getJarsFromClasspathEntry(this.getTemplateParentPath("backing"), this.getResourceFile("versioned-1.0.jar").getParent());
        Assertions.assertThat((Iterable)jars).isEmpty();
    }

    @Test
    public void canReferenceGlobPatternInClasspathEntry() throws Exception {
        Collection jars = this.bsc.getJarsFromClasspathEntry(this.getTemplateParentPath("backing"), this.bundles.getAbsolutePath() + "/versioned-*.jar");
        Assertions.assertThat((Iterable)jars).hasSize(1);
        jars = this.bsc.getJarsFromClasspathEntry(this.getTemplateParentPath("backing"), this.bundles.getAbsolutePath() + "/other-*.jar");
        Assertions.assertThat((Iterable)jars).hasSize(0);
    }

    @Test
    public void canUseParametersInClasspath() throws Exception {
        this.configGenerator.setProperty("backing.check.classpath", "${nuxeo.home}/nxserver/bundles/versioned-*.jar");
        Assertions.assertThat((String)this.bsc.getClasspathForTemplate("backing")).isEqualTo(this.bundles.getAbsolutePath() + File.separator + "versioned-*.jar");
    }

    @Test
    public void backingCheckerAreCalled() throws Exception {
        this.configGenerator.setProperty("backing.check.class", "org.nuxeo.launcher.config.FakeCheck");
        Assertions.assertThat((int)FakeCheck.getCallCount()).isEqualTo(0);
        this.configGenerator.verifyInstallation();
        Assertions.assertThat((int)FakeCheck.getCallCount()).isEqualTo(1);
    }

    @Test
    public void checksAreRetried() throws Exception {
        this.configGenerator.setProperty("nuxeo.backing.check.retry.enabled", "true");
        FakeCheck.setReady(false);
        try {
            this.configGenerator.verifyInstallation();
        }
        catch (ConfigurationException configurationException) {
            // empty catch block
        }
        Assertions.assertThat((int)FakeCheck.getCallCount()).isEqualTo(6);
        this.configGenerator.setProperty("nuxeo.backing.check.retry.enabled", "false");
        FakeCheck.reset();
        try {
            this.configGenerator.verifyInstallation();
        }
        catch (ConfigurationException configurationException) {
            // empty catch block
        }
        Assertions.assertThat((int)FakeCheck.getCallCount()).isEqualTo(1);
    }

    protected Path getTemplateParentPath(String templateName) throws ConfigurationException {
        File conf = this.configGenerator.getTemplateConf("backing");
        return conf.getParentFile().toPath();
    }
}

