/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.launcher.config;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.file.Files;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.junit.After;
import org.junit.Before;
import org.nuxeo.launcher.config.ConfigurationGenerator;

public abstract class AbstractConfigurationTest {
    protected static final Logger log = LogManager.getLogger(AbstractConfigurationTest.class);
    protected static final String CUSTOM_ENVIRONMENT_SYSTEM_PROPERTY = "custom.environment";
    protected static final String DEFAULT_BUILD_DIRECTORY = "target";
    protected ConfigurationGenerator configGenerator;
    protected File nuxeoHome;
    protected File nuxeoBinDir;
    protected Map<String, String> originSystemProps = new HashMap<String, String>();

    public File getResourceFile(String resource) {
        URL url = this.getClass().getClassLoader().getResource(resource);
        try {
            return new File(URLDecoder.decode(url.getPath(), "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            log.error((Object)e);
            return null;
        }
    }

    @Before
    public void setUp() throws Exception {
        String buildDirectory = this.getBuildDirectory();
        this.nuxeoHome = new File(buildDirectory + "/launcher");
        Files.deleteIfExists(this.nuxeoHome.toPath());
        this.nuxeoHome.mkdirs();
        File nuxeoConf = this.getResourceFile("configurator/nuxeo.conf");
        FileUtils.copyFileToDirectory((File)nuxeoConf, (File)this.nuxeoHome);
        this.nuxeoBinDir = new File(this.nuxeoHome, "bin");
        this.nuxeoBinDir.mkdir();
        this.setSystemProperty("nuxeo.conf", new File(this.nuxeoHome, nuxeoConf.getName()).getPath());
        this.setSystemProperty("nuxeo.home", this.nuxeoHome.getPath());
        this.setSystemProperty("nuxeo.data.dir", new File(this.nuxeoHome, "data").getPath());
        this.setSystemProperty("nuxeo.log.dir", new File(this.nuxeoHome, "log").getPath());
    }

    @After
    public void tearDown() {
        FileUtils.deleteQuietly((File)this.nuxeoHome);
        this.originSystemProps.forEach((key, value) -> {
            if (value == null) {
                System.clearProperty(key);
            } else {
                System.setProperty(key, value);
            }
        });
        this.originSystemProps.clear();
    }

    protected void setSystemProperty(String key, String newValue) {
        this.originSystemProps.put(key, System.setProperty(key, newValue));
    }

    protected String getBuildDirectory() {
        String customEnvironment = System.getProperty(CUSTOM_ENVIRONMENT_SYSTEM_PROPERTY);
        return customEnvironment == null ? DEFAULT_BUILD_DIRECTORY : String.format("%s-%s", DEFAULT_BUILD_DIRECTORY, customEnvironment);
    }
}

