/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.launcher.config;

import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.Property;

public class LogCaptureAppender
extends AbstractAppender {
    protected final List<String> messages = new ArrayList<String>();
    protected final Level level;
    protected final String loggerName;

    public LogCaptureAppender(Level level, Class<?> loggerClass) {
        super(LogCaptureAppender.class.getName(), null, null, true, new Property[0]);
        this.level = level;
        this.loggerName = loggerClass.getName();
    }

    public void append(LogEvent event) {
        if (this.loggerName.equals(event.getLoggerName()) && this.level.equals((Object)event.getLevel())) {
            this.messages.add(event.getMessage().getFormattedMessage());
        }
    }

    public boolean isEmpty() {
        return this.messages.isEmpty();
    }

    public String get(int i) {
        return this.messages.get(i);
    }

    public int size() {
        return this.messages.size();
    }

    public void clear() {
        this.messages.clear();
    }
}

