/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.datasource;

import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.nuxeo.runtime.RuntimeServiceException;
import org.nuxeo.runtime.datasource.DataSourceDescriptor;
import org.nuxeo.runtime.datasource.DataSourceHelper;
import org.nuxeo.runtime.datasource.DataSourceLinkDescriptor;
import org.nuxeo.runtime.datasource.DataSourceRegistry;
import org.nuxeo.runtime.datasource.PooledDataSourceRegistry;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.DefaultComponent;

public class DataSourceComponent
extends DefaultComponent {
    private static final Logger log = LogManager.getLogger(DataSourceComponent.class);
    public static final String DATASOURCES_XP = "datasources";
    public static final String ENV_CTX_NAME = "java:comp/env/";
    protected PooledDataSourceRegistry poolRegistry;

    public int getApplicationStartedOrder() {
        return -1000;
    }

    public void start(ComponentContext context) {
        this.poolRegistry = new PooledDataSourceRegistry();
        DataSourceRegistry reg = (DataSourceRegistry)this.getExtensionPointRegistry(DATASOURCES_XP);
        reg.getDataSources().forEach(this::bindDataSource);
        reg.getDataSourceLinks().forEach(this::bindDataSourceLink);
    }

    public void stop(ComponentContext context) {
        this.poolRegistry = null;
    }

    protected void bindDataSource(DataSourceDescriptor descr) {
        Supplier[] supplierArray = new Supplier[1];
        supplierArray[0] = descr::getName;
        log.info("Registering datasource: {}", supplierArray);
        this.poolRegistry.registerPooledDataSource(descr.getName(), descr.getAllProperties());
    }

    protected void bindDataSourceLink(DataSourceLinkDescriptor descr) {
        DataSource ds;
        log.info("Registering DataSourceLink: {}", (Object)descr.name);
        try {
            ds = DataSourceHelper.getDataSource(descr.global, DataSource.class);
        }
        catch (NamingException e) {
            throw new RuntimeServiceException("Cannot find DataSourceLink '" + descr.name + "' in JNDI", (Throwable)e);
        }
        this.poolRegistry.createAlias(DataSourceHelper.relativize(descr.name), ds);
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter.isAssignableFrom(PooledDataSourceRegistry.class)) {
            return adapter.cast(this.poolRegistry);
        }
        return (T)super.getAdapter(adapter);
    }
}

