/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.datasource;

import javax.naming.NamingException;
import javax.sql.DataSource;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.datasource.PooledDataSourceRegistry;
import org.nuxeo.runtime.jtajca.NuxeoContainer;

public class DataSourceHelper {
    private DataSourceHelper() {
    }

    public static String getDataSourceJNDIName(String name) {
        return NuxeoContainer.nameOf((String)DataSourceHelper.relativize(name));
    }

    protected static String relativize(String name) {
        int idx = name.lastIndexOf("/");
        if (idx > 0) {
            name = name.substring(idx + 1);
        }
        return "jdbc/".concat(name);
    }

    public static DataSource getDataSource(String partialName) throws NamingException {
        return DataSourceHelper.getDataSource(partialName, DataSource.class, false);
    }

    public static DataSource getDataSource(String partialName, boolean noSharing) throws NamingException {
        return DataSourceHelper.getDataSource(partialName, DataSource.class, noSharing);
    }

    public static <T> T getDataSource(String name, Class<T> clazz) throws NamingException {
        return DataSourceHelper.getDataSource(name, clazz, false);
    }

    public static <T> T getDataSource(String name, Class<T> clazz, boolean noSharing) throws NamingException {
        PooledDataSourceRegistry pools = (PooledDataSourceRegistry)Framework.getService(PooledDataSourceRegistry.class);
        if (pools == null) {
            throw new NamingException("runtime datasource no installed");
        }
        T ds = pools.getDataSource(DataSourceHelper.relativize(name), clazz, noSharing);
        if (ds == null) {
            return (T)NuxeoContainer.lookup((String)name, clazz);
        }
        return ds;
    }
}

