/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.transaction;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.naming.NamingException;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.TransactionSynchronizationRegistry;
import javax.transaction.UserTransaction;
import javax.transaction.xa.XAResource;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.transaction.manager.TransactionImpl;
import org.nuxeo.runtime.jtajca.NuxeoContainer;
import org.nuxeo.runtime.transaction.TransactionRuntimeException;

public class TransactionHelper {
    private static final Log log = LogFactory.getLog(TransactionHelper.class);
    private static final Field GERONIMO_TRANSACTION_TIMEOUT_FIELD = FieldUtils.getField(TransactionImpl.class, (String)"timeout", (boolean)true);
    protected static final ExecutorService EXECUTOR = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 5L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());
    private static ThreadLocal<List<Exception>> suppressedExceptions = new ThreadLocal();

    private TransactionHelper() {
    }

    public static UserTransaction lookupUserTransaction() throws NamingException {
        UserTransaction ut = NuxeoContainer.getUserTransaction();
        if (ut == null) {
            throw new NamingException("tx manager not installed");
        }
        return ut;
    }

    public static int getTransactionStatus() {
        UserTransaction ut = NuxeoContainer.getUserTransaction();
        if (ut == null) {
            return -1;
        }
        try {
            return ut.getStatus();
        }
        catch (SystemException e) {
            throw new TransactionRuntimeException("Cannot get transaction status", e);
        }
    }

    public static String getUserTransactionJNDIName() {
        return NuxeoContainer.nameOf("UserTransaction");
    }

    public static TransactionManager lookupTransactionManager() throws NamingException {
        TransactionManager tm = NuxeoContainer.getTransactionManager();
        if (tm == null) {
            throw new NamingException("tx manager not installed");
        }
        return tm;
    }

    public static TransactionSynchronizationRegistry lookupSynchronizationRegistry() throws NamingException {
        TransactionSynchronizationRegistry synch = NuxeoContainer.getTransactionSynchronizationRegistry();
        if (synch == null) {
            throw new NamingException("tx manager not installed");
        }
        return synch;
    }

    public static boolean isNoTransaction() {
        int status = TransactionHelper.getTransactionStatus();
        return status == 6 || status == -1;
    }

    public static boolean isTransactionActive() {
        int status = TransactionHelper.getTransactionStatus();
        return status == 0;
    }

    public static boolean isTransactionMarkedRollback() {
        int status = TransactionHelper.getTransactionStatus();
        return status == 1;
    }

    public static boolean isTransactionActiveOrMarkedRollback() {
        int status = TransactionHelper.getTransactionStatus();
        return status == 0 || status == 1;
    }

    public static boolean isTransactionActiveOrPreparing() {
        int status = TransactionHelper.getTransactionStatus();
        return status == 0 || status == 7;
    }

    public static boolean isTransactionTimedOut() {
        TransactionManager tm = NuxeoContainer.getTransactionManager();
        if (tm == null) {
            return false;
        }
        try {
            Transaction tx = tm.getTransaction();
            if (tx == null || tx.getStatus() != 0) {
                return false;
            }
            if (tx instanceof TransactionImpl) {
                Long timeout = (Long)GERONIMO_TRANSACTION_TIMEOUT_FIELD.get(tx);
                return System.currentTimeMillis() > timeout;
            }
            return false;
        }
        catch (ReflectiveOperationException | SystemException e) {
            throw new RuntimeException(e);
        }
    }

    public static void checkTransactionTimeout() throws TransactionRuntimeException {
        if (TransactionHelper.isTransactionTimedOut()) {
            throw new TransactionRuntimeException("Transaction has timed out");
        }
    }

    public static boolean startTransaction() {
        UserTransaction ut = NuxeoContainer.getUserTransaction();
        if (ut == null) {
            return false;
        }
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Starting transaction");
            }
            ut.begin();
            return true;
        }
        catch (NotSupportedException | SystemException e) {
            log.error((Object)"Unable to start transaction", e);
            return false;
        }
    }

    @Deprecated(since="11.1")
    public static Transaction requireNewTransaction() {
        TransactionManager tm = NuxeoContainer.getTransactionManager();
        if (tm == null) {
            return null;
        }
        try {
            Transaction tx = tm.getTransaction();
            if (tx != null) {
                tx = tm.suspend();
            }
            tm.begin();
            return tx;
        }
        catch (NotSupportedException | SystemException e) {
            throw new TransactionRuntimeException("Cannot suspend tx", e);
        }
    }

    @Deprecated(since="11.1")
    public static Transaction suspendTransaction() {
        TransactionManager tm = NuxeoContainer.getTransactionManager();
        if (tm == null) {
            return null;
        }
        try {
            Transaction tx = tm.getTransaction();
            if (tx != null) {
                tx = tm.suspend();
            }
            return tx;
        }
        catch (SystemException e) {
            throw new TransactionRuntimeException("Cannot suspend tx", e);
        }
    }

    public static void resumeTransaction(Transaction tx) {
        TransactionManager tm = NuxeoContainer.getTransactionManager();
        if (tm == null) {
            return;
        }
        try {
            if (tm.getStatus() == 0) {
                tm.commit();
            }
            if (tx != null) {
                tm.resume(tx);
            }
        }
        catch (IllegalStateException | SecurityException | HeuristicMixedException | HeuristicRollbackException | InvalidTransactionException | RollbackException | SystemException e) {
            throw new TransactionRuntimeException("Cannot resume tx", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean startTransaction(int timeout) {
        TransactionManager tm;
        if (timeout < 0) {
            timeout = 0;
        }
        if ((tm = NuxeoContainer.getTransactionManager()) == null) {
            return false;
        }
        try {
            tm.setTransactionTimeout(timeout);
        }
        catch (SystemException e) {
            log.error((Object)("Unable to set transaction timeout: " + timeout), (Throwable)e);
            return false;
        }
        try {
            boolean bl = TransactionHelper.startTransaction();
            return bl;
        }
        finally {
            try {
                tm.setTransactionTimeout(0);
            }
            catch (SystemException e) {
                log.error((Object)"Unable to reset transaction timeout", (Throwable)e);
            }
        }
    }

    public static void commitOrRollbackTransaction() {
        block24: {
            UserTransaction ut = NuxeoContainer.getUserTransaction();
            if (ut == null) {
                return;
            }
            TransactionHelper.noteSuppressedExceptions();
            RuntimeException thrown = null;
            boolean isRollbackDuringCommit = false;
            try {
                int status = ut.getStatus();
                if (status == 0) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Committing transaction");
                    }
                    try {
                        ut.commit();
                        break block24;
                    }
                    catch (HeuristicMixedException | HeuristicRollbackException e) {
                        throw new TransactionRuntimeException(e.getMessage(), e);
                    }
                    catch (RollbackException e) {
                        String msg;
                        Throwable cause = e.getCause();
                        if (cause != null && "Transaction has timed out".equals(cause.getMessage())) {
                            msg = "Unable to commit: Transaction timeout";
                        } else {
                            isRollbackDuringCommit = true;
                            msg = e.getMessage();
                        }
                        log.debug((Object)"Unable to commit", (Throwable)e);
                        throw new TransactionRuntimeException(msg, e);
                    }
                }
                if (status == 1) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Cannot commit transaction because it is marked rollback only");
                    }
                    ut.rollback();
                } else if (log.isDebugEnabled()) {
                    log.debug((Object)("Cannot commit transaction with unknown status: " + status));
                }
            }
            catch (SystemException e) {
                thrown = new TransactionRuntimeException(e);
                throw thrown;
            }
            catch (RuntimeException e) {
                thrown = e;
                throw thrown;
            }
            finally {
                List<Exception> suppressed = TransactionHelper.getSuppressedExceptions();
                if (!suppressed.isEmpty()) {
                    RuntimeException e;
                    if (thrown == null) {
                        e = new TransactionRuntimeException("Exception during commit");
                    } else if (isRollbackDuringCommit && suppressed.get(0) instanceof RuntimeException) {
                        thrown = null;
                        e = (RuntimeException)suppressed.remove(0);
                    } else {
                        e = thrown;
                    }
                    suppressed.forEach(s -> e.addSuppressed((Throwable)s));
                    if (thrown == null) {
                        throw e;
                    }
                }
            }
        }
    }

    protected static void noteSuppressedExceptions() {
        suppressedExceptions.set(new ArrayList());
    }

    public static void noteSuppressedException(Exception e) {
        List<Exception> exceptions = suppressedExceptions.get();
        if (exceptions != null) {
            exceptions.add(e);
        }
    }

    protected static List<Exception> getSuppressedExceptions() {
        List<Exception> exceptions = suppressedExceptions.get();
        suppressedExceptions.remove();
        return exceptions == null ? Collections.emptyList() : exceptions;
    }

    public static boolean setTransactionRollbackOnly() {
        UserTransaction ut;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Setting transaction as rollback only");
            if (log.isTraceEnabled()) {
                log.trace((Object)"Rollback stack trace", new Throwable("Rollback stack trace"));
            }
        }
        if ((ut = NuxeoContainer.getUserTransaction()) == null) {
            return false;
        }
        try {
            ut.setRollbackOnly();
            return true;
        }
        catch (IllegalStateException | SystemException cause) {
            log.error((Object)"Could not mark transaction as rollback only", cause);
            return false;
        }
    }

    public static boolean setTransactionRollbackOnlyIfTimedOut() {
        if (TransactionHelper.isTransactionTimedOut()) {
            return TransactionHelper.setTransactionRollbackOnly();
        }
        return false;
    }

    public static void registerSynchronization(Synchronization handler) {
        if (!TransactionHelper.isTransactionActiveOrPreparing()) {
            throw new TransactionRuntimeException("Cannot register Synchronization if transaction is not active");
        }
        try {
            NuxeoContainer.getTransactionManager().getTransaction().registerSynchronization(handler);
        }
        catch (IllegalStateException | RollbackException | SystemException cause) {
            throw new RuntimeException("Cannot register synch handler in current tx", cause);
        }
    }

    public static void enlistResource(XAResource xaRes) {
        if (!TransactionHelper.isTransactionActiveOrMarkedRollback()) {
            throw new TransactionRuntimeException("Cannot enlist XA resource if transaction is not active");
        }
        try {
            NuxeoContainer.getTransactionManager().getTransaction().enlistResource(xaRes);
        }
        catch (IllegalStateException | RollbackException | SystemException cause) {
            throw new RuntimeException("Cannot enlist XA resource in current tx", cause);
        }
    }

    public static void runWithoutTransaction(Runnable runnable) {
        TransactionHelper.runWithoutTransaction(() -> {
            runnable.run();
            return null;
        });
    }

    public static <R> R runWithoutTransaction(Supplier<R> supplier) {
        return (R)TransactionHelper.runWithoutTransactionInternal(() -> TransactionHelper.runAndCleanupTransactionContext(supplier));
    }

    public static void runInNewTransaction(Runnable runnable) {
        TransactionHelper.runInNewTransaction(() -> {
            runnable.run();
            return null;
        });
    }

    public static <R> R runInNewTransaction(Supplier<R> supplier) {
        return (R)TransactionHelper.runWithoutTransaction(() -> TransactionHelper.runInTransaction(supplier));
    }

    public static void runInTransaction(Runnable runnable) {
        TransactionHelper.runInTransaction(() -> {
            runnable.run();
            return null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <R> R runInTransaction(Supplier<R> supplier) {
        boolean startTransaction;
        boolean bl = startTransaction = !TransactionHelper.isTransactionActiveOrMarkedRollback();
        if (startTransaction && !TransactionHelper.startTransaction()) {
            throw new TransactionRuntimeException("Cannot start transaction");
        }
        boolean completedAbruptly = true;
        try {
            R result = supplier.get();
            completedAbruptly = false;
            R r = result;
            return r;
        }
        finally {
            try {
                if (completedAbruptly) {
                    TransactionHelper.setTransactionRollbackOnly();
                }
            }
            finally {
                if (startTransaction) {
                    TransactionHelper.commitOrRollbackTransaction();
                }
            }
        }
    }

    protected static <R> R runWithoutTransactionInternal(Supplier<R> supplier) {
        if (TransactionHelper.isNoTransaction()) {
            return supplier.get();
        }
        try {
            return (R)EXECUTOR.submit(() -> supplier.get()).get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new RuntimeException(cause);
        }
    }

    protected static <R> R runAndCleanupTransactionContext(Supplier<R> supplier) {
        try {
            R r = supplier.get();
            return r;
        }
        finally {
            if (!TransactionHelper.isNoTransaction()) {
                try {
                    TransactionHelper.commitOrRollbackTransaction();
                }
                catch (TransactionRuntimeException e) {
                    log.error((Object)"Failed to commit/rollback", (Throwable)e);
                }
            }
        }
    }
}

