/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.metrics;

import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.graphite.Graphite;
import com.codahale.metrics.graphite.GraphiteReporter;
import com.codahale.metrics.jmx.JmxReporter;
import com.codahale.metrics.jvm.BufferPoolMetricSet;
import com.codahale.metrics.jvm.FileDescriptorRatioGauge;
import com.codahale.metrics.jvm.GarbageCollectorMetricSet;
import com.codahale.metrics.jvm.JmxAttributeGauge;
import com.codahale.metrics.jvm.MemoryUsageGaugeSet;
import com.codahale.metrics.jvm.ThreadStatesGaugeSet;
import com.codahale.metrics.log4j2.InstrumentedAppender;
import com.readytalk.metrics.StatsDReporter;
import java.io.File;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.commons.logging.LogFactory;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeList;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.management.ServerLocator;
import org.nuxeo.runtime.metrics.CsvReporter;
import org.nuxeo.runtime.metrics.MetricsServiceImpl;

@XObject(value="metrics")
public class MetricsDescriptor
implements Serializable {
    private static final long serialVersionUID = 7833869486922092460L;
    @XNode(value="graphiteReporter")
    public GraphiteDescriptor graphiteReporter = new GraphiteDescriptor();
    @XNode(value="csvReporter")
    public CsvDescriptor csvReporter = new CsvDescriptor();
    @XNode(value="statsDReporter")
    public StatsDDescriptor statsDReporter = new StatsDDescriptor();
    @XNode(value="log4jInstrumentation")
    public Log4jInstrumentationDescriptor log4jInstrumentation = new Log4jInstrumentationDescriptor();
    @XNode(value="tomcatInstrumentation")
    public TomcatInstrumentationDescriptor tomcatInstrumentation = new TomcatInstrumentationDescriptor();
    @XNode(value="jvmInstrumentation")
    public JvmInstrumentationDescriptor jvmInstrumentation = new JvmInstrumentationDescriptor();
    protected JmxReporter jmxReporter;

    public MetricsDescriptor() {
        this.graphiteReporter = new GraphiteDescriptor();
        this.csvReporter = new CsvDescriptor();
        this.tomcatInstrumentation = new TomcatInstrumentationDescriptor();
        this.log4jInstrumentation = new Log4jInstrumentationDescriptor();
    }

    public void enable(MetricRegistry registry) {
        this.jmxReporter = JmxReporter.forRegistry((MetricRegistry)registry).build();
        this.jmxReporter.start();
        this.graphiteReporter.enable(registry);
        this.csvReporter.enable(registry);
        this.log4jInstrumentation.enable(registry);
        this.tomcatInstrumentation.enable(registry);
        this.jvmInstrumentation.enable(registry);
        this.statsDReporter.enable(registry);
    }

    public void disable(MetricRegistry registry) {
        try {
            this.graphiteReporter.disable(registry);
            this.csvReporter.disable(registry);
            this.log4jInstrumentation.disable(registry);
            this.tomcatInstrumentation.disable(registry);
            this.jvmInstrumentation.disable(registry);
            this.statsDReporter.enable(registry);
            this.jmxReporter.stop();
        }
        finally {
            this.jmxReporter = null;
        }
    }

    @XObject(value="jvmInstrumentation")
    public static class JvmInstrumentationDescriptor {
        public static final String ENABLED_PROPERTY = "metrics.jvm.enabled";
        @XNode(value="@enabled")
        protected boolean enabled = Boolean.parseBoolean(Framework.getProperty((String)"metrics.jvm.enabled", (String)"true"));

        public void enable(MetricRegistry registry) {
            if (!this.enabled) {
                return;
            }
            registry.register("jvm.memory", (Metric)new MemoryUsageGaugeSet());
            registry.register("jvm.garbage", (Metric)new GarbageCollectorMetricSet());
            registry.register("jvm.threads", (Metric)new ThreadStatesGaugeSet());
            registry.register("jvm.files", (Metric)new FileDescriptorRatioGauge());
            registry.register("jvm.buffers", (Metric)new BufferPoolMetricSet(((ServerLocator)Framework.getService(ServerLocator.class)).lookupServer()));
        }

        public void disable(MetricRegistry registry) {
            if (!this.enabled) {
                return;
            }
            registry.removeMatching((name, metric) -> name.startsWith("jvm."));
        }
    }

    @XObject(value="tomcatInstrumentation")
    public static class TomcatInstrumentationDescriptor {
        public static final String ENABLED_PROPERTY = "metrics.tomcat.enabled";
        @XNode(value="@enabled")
        protected boolean enabled = Boolean.parseBoolean(Framework.getProperty((String)"metrics.tomcat.enabled", (String)"false"));

        public String toString() {
            return String.format("tomcatInstrumentation %s", this.enabled ? "enabled" : "disabled");
        }

        protected void registerTomcatGauge(String mbean, String attribute, MetricRegistry registry, String name) {
            try {
                registry.register(MetricRegistry.name((String)"tomcat", (String[])new String[]{name}), (Metric)new JmxAttributeGauge(new ObjectName(mbean), attribute));
            }
            catch (IllegalArgumentException | MalformedObjectNameException e) {
                throw new UnsupportedOperationException("Cannot compute object name of " + mbean, e);
            }
        }

        public void enable(MetricRegistry registry) {
            if (!this.enabled) {
                return;
            }
            LogFactory.getLog(MetricsServiceImpl.class).info((Object)this);
            String pool = "org.nuxeo.ecm.core.management.jtajca:type=ConnectionPoolMonitor,name=jdbc/nuxeo";
            String connector = String.format("Catalina:type=ThreadPool,name=\"http-nio-%s-%s\"", Framework.getProperty((String)"nuxeo.bind.address", (String)"0.0.0.0"), Framework.getProperty((String)"nuxeo.bind.port", (String)"8080"));
            String requestProcessor = String.format("Catalina:type=GlobalRequestProcessor,name=\"http-nio-%s-%s\"", Framework.getProperty((String)"nuxeo.bind.address", (String)"0.0.0.0"), Framework.getProperty((String)"nuxeo.bind.port", (String)"8080"));
            String manager = "Catalina:type=Manager,host=localhost,context=/nuxeo";
            this.registerTomcatGauge(pool, "ConnectionCount", registry, "jdbc-numActive");
            this.registerTomcatGauge(pool, "IdleConnectionCount", registry, "jdbc-numIdle");
            this.registerTomcatGauge(connector, "currentThreadCount", registry, "currentThreadCount");
            this.registerTomcatGauge(connector, "currentThreadsBusy", registry, "currentThreadBusy");
            this.registerTomcatGauge(requestProcessor, "errorCount", registry, "errorCount");
            this.registerTomcatGauge(requestProcessor, "requestCount", registry, "requestCount");
            this.registerTomcatGauge(requestProcessor, "processingTime", registry, "processingTime");
            this.registerTomcatGauge(requestProcessor, "bytesReceived", registry, "bytesReceived");
            this.registerTomcatGauge(requestProcessor, "bytesSent", registry, "bytesSent");
            this.registerTomcatGauge(manager, "activeSessions", registry, "activeSessions");
        }

        public void disable(MetricRegistry registry) {
            registry.remove("tomcat.jdbc-numActive");
            registry.remove("tomcat.jdbc-numIdle");
            registry.remove("tomcat.currentThreadCount");
            registry.remove("tomcat.currentThreadBusy");
            registry.remove("tomcat.errorCount");
            registry.remove("tomcat.requestCount");
            registry.remove("tomcat.processingTime");
            registry.remove("tomcat.activeSessions");
        }
    }

    @XObject(value="log4jInstrumentation")
    public static class Log4jInstrumentationDescriptor {
        public static final String ENABLED_PROPERTY = "metrics.log4j.enabled";
        @XNode(value="@enabled")
        protected boolean enabled = Boolean.parseBoolean(Framework.getProperty((String)"metrics.log4j.enabled", (String)"false"));
        private InstrumentedAppender appender;

        public String toString() {
            return String.format("log4jInstrumentation %s", this.enabled ? "enabled" : "disabled");
        }

        public void enable(MetricRegistry registry) {
            if (!this.enabled) {
                return;
            }
            LogFactory.getLog(MetricsServiceImpl.class).info((Object)this);
            InstrumentedAppender appender = new InstrumentedAppender(registry, null, null, false);
            appender.start();
            LoggerContext context = (LoggerContext)LogManager.getContext((boolean)false);
            Configuration config = context.getConfiguration();
            config.getLoggerConfig("").addAppender((Appender)appender, Level.INFO, null);
            context.updateLoggers(config);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void disable(MetricRegistry registry) {
            if (this.appender == null) {
                return;
            }
            try {
                LoggerContext context = (LoggerContext)LogManager.getContext((boolean)false);
                Configuration config = context.getConfiguration();
                config.getLoggerConfig("").removeAppender(this.appender.getName());
                context.updateLoggers(config);
            }
            finally {
                this.appender = null;
            }
        }
    }

    @XObject(value="statsDReporter")
    public static class StatsDDescriptor {
        public static final String ENABLED_PROPERTY = "metrics.statsd.enabled";
        public static final String HOST_PROPERTY = "metrics.statsd.host";
        public static final String PORT_PROPERTY = "metrics.statsd.port";
        public static final String PERIOD_PROPERTY = "metrics.statsd.period";
        public static final String PREFIX_PROPERTY = "metrics.statsd.prefix";
        public static final String ALLOWED_METRICS_PROPERTY = "metrics.statsd.allowedMetrics";
        public static final String DENIED_METRICS_PROPERTY = "metrics.statsd.deniedMetrics";
        public static final String DEFAULT_ALLOWED_METRICS = "nuxeo.cache.user-entry-cache,nuxeo.cache.group-entry-cache,nuxeo.directories.userDirectory,nuxeo.directories.groupDirectory";
        public static final String DEFAULT_DENIED_METRICS = "nuxeo.cache,nuxeo.directories";
        public static final String ALL_METRICS = "ALL";
        @XNode(value="@enabled")
        protected Boolean enabled = Boolean.valueOf(Framework.getProperty((String)"metrics.statsd.enabled", (String)"false"));
        @XNode(value="@host")
        public String host = Framework.getProperty((String)"metrics.statsd.host", (String)"127.0.0.1");
        @XNode(value="@port")
        public Integer port = Integer.valueOf(Framework.getProperty((String)"metrics.statsd.port", (String)"8125"));
        @XNode(value="@periodInSecond")
        public Integer period = Integer.valueOf(Framework.getProperty((String)"metrics.statsd.period", (String)"10"));
        @XNode(value="@prefix")
        public String prefix = this.getPrefix();
        @XNodeList(value="allowedMetrics/metric", type=ArrayList.class, componentType=String.class)
        public List<String> allowedMetrics = Arrays.asList(Framework.getProperty((String)"metrics.statsd.allowedMetrics", (String)"nuxeo.cache.user-entry-cache,nuxeo.cache.group-entry-cache,nuxeo.directories.userDirectory,nuxeo.directories.groupDirectory").split(","));
        @XNodeList(value="deniedMetrics/metric", type=ArrayList.class, componentType=String.class)
        public List<String> deniedMetrics = Arrays.asList(Framework.getProperty((String)"metrics.statsd.deniedMetrics", (String)"nuxeo.cache,nuxeo.directories").split(","));
        protected StatsDReporter reporter;

        public String getPrefix() {
            String hostname;
            if (this.prefix == null) {
                this.prefix = Framework.getProperty((String)PREFIX_PROPERTY, (String)"servers.${hostname}.nuxeo");
            }
            try {
                hostname = InetAddress.getLocalHost().getHostName().split("\\.")[0];
            }
            catch (UnknownHostException e) {
                hostname = "unknown";
            }
            return this.prefix.replace("${hostname}", hostname);
        }

        public boolean filter(String name) {
            return this.allowedMetrics.stream().anyMatch(f -> ALL_METRICS.equals(f) || name.startsWith((String)f)) || this.deniedMetrics.stream().noneMatch(f -> ALL_METRICS.equals(f) || name.startsWith((String)f));
        }

        public String toString() {
            return String.format("statdReporter %s prefix: %s, host: %s, port: %d, period: %d", this.enabled != false ? "enabled" : "disabled", this.prefix, this.host, this.port, this.period);
        }

        public void enable(MetricRegistry registry) {
            if (!this.enabled.booleanValue()) {
                return;
            }
            this.reporter = StatsDReporter.forRegistry((MetricRegistry)registry).build(this.host, this.port.intValue());
            this.reporter.start((long)this.period.intValue(), TimeUnit.SECONDS);
        }

        public void disable(MetricRegistry registry) {
            if (this.reporter == null) {
                return;
            }
            try {
                this.reporter.stop();
            }
            finally {
                this.reporter = null;
            }
        }
    }

    @XObject(value="csvReporter")
    public static class CsvDescriptor {
        public static final String ENABLED_PROPERTY = "metrics.csv.enabled";
        public static final String PERIOD_PROPERTY = "metrics.csv.period";
        public static final String OUTPUT_PROPERTY = "metrics.csv.output";
        @XNode(value="@output")
        public File outputDir = this.outputDir();
        @XNode(value="@periodInSecond")
        public Integer period = 10;
        @XNode(value="@enabled")
        public boolean enabled = Framework.isBooleanPropertyTrue((String)"metrics.csv.enabled");
        protected CsvReporter reporter;

        public int getPeriod() {
            if (this.period == null) {
                this.period = Integer.valueOf(Framework.getProperty((String)PERIOD_PROPERTY, (String)"10"));
            }
            return this.period;
        }

        protected File outputDir() {
            String path = Framework.getProperty((String)OUTPUT_PROPERTY, (String)Framework.getProperty((String)"nuxeo.log.dir"));
            SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd-HHmmss");
            Date today = Calendar.getInstance().getTime();
            this.outputDir = new File(path, "metrics-" + df.format(today));
            return this.outputDir;
        }

        public String toString() {
            return String.format("csvReporter %s, outputDir: %s, period: %d", this.enabled ? "enabled" : "disabled", this.outputDir().toString(), this.getPeriod());
        }

        public void enable(MetricRegistry registry) {
            if (!this.enabled) {
                return;
            }
            File parentDir = this.outputDir.getParentFile();
            if (parentDir.exists() && parentDir.isDirectory()) {
                this.outputDir.mkdir();
                this.reporter = CsvReporter.forRegistry(registry).build(this.outputDir);
                this.reporter.start(this.period.intValue(), TimeUnit.SECONDS);
            } else {
                this.enabled = false;
                LogFactory.getLog(MetricsServiceImpl.class).error((Object)("Invalid output directory, disabling: " + this));
            }
        }

        public void disable(MetricRegistry registry) {
            if (this.reporter == null) {
                return;
            }
            try {
                this.reporter.stop();
            }
            finally {
                this.reporter = null;
            }
        }
    }

    @XObject(value="graphiteReporter")
    public static class GraphiteDescriptor {
        public static final String ENABLED_PROPERTY = "metrics.graphite.enabled";
        public static final String HOST_PROPERTY = "metrics.graphite.host";
        public static final String PORT_PROPERTY = "metrics.graphite.port";
        public static final String PERIOD_PROPERTY = "metrics.graphite.period";
        public static final String PREFIX_PROPERTY = "metrics.graphite.prefix";
        public static final String ALLOWED_METRICS_PROPERTY = "metrics.graphite.allowedMetrics";
        public static final String DENIED_METRICS_PROPERTY = "metrics.graphite.deniedMetrics";
        public static final String DEFAULT_ALLOWED_METRICS = "nuxeo.cache.user-entry-cache,nuxeo.cache.group-entry-cache,nuxeo.directories.userDirectory,nuxeo.directories.groupDirectory";
        public static final String DEFAULT_DENIED_METRICS = "nuxeo.cache,nuxeo.directories";
        public static final String ALL_METRICS = "ALL";
        @XNode(value="@enabled")
        protected Boolean enabled = Boolean.valueOf(Framework.getProperty((String)"metrics.graphite.enabled", (String)"false"));
        @XNode(value="@host")
        public String host = Framework.getProperty((String)"metrics.graphite.host", (String)"0.0.0.0");
        @XNode(value="@port")
        public Integer port = Integer.valueOf(Framework.getProperty((String)"metrics.graphite.port", (String)"2030"));
        @XNode(value="@periodInSecond")
        public Integer period = Integer.valueOf(Framework.getProperty((String)"metrics.graphite.period", (String)"10"));
        @XNode(value="@prefix")
        public String prefix = this.getPrefix();
        @XNodeList(value="allowedMetrics/metric", type=ArrayList.class, componentType=String.class)
        public List<String> allowedMetrics = Arrays.asList(Framework.getProperty((String)"metrics.graphite.allowedMetrics", (String)"nuxeo.cache.user-entry-cache,nuxeo.cache.group-entry-cache,nuxeo.directories.userDirectory,nuxeo.directories.groupDirectory").split(","));
        @XNodeList(value="deniedMetrics/metric", type=ArrayList.class, componentType=String.class)
        public List<String> deniedMetrics = Arrays.asList(Framework.getProperty((String)"metrics.graphite.deniedMetrics", (String)"nuxeo.cache,nuxeo.directories").split(","));
        protected GraphiteReporter reporter;

        public String getPrefix() {
            String hostname;
            if (this.prefix == null) {
                this.prefix = Framework.getProperty((String)PREFIX_PROPERTY, (String)"servers.${hostname}.nuxeo");
            }
            try {
                hostname = InetAddress.getLocalHost().getHostName().split("\\.")[0];
            }
            catch (UnknownHostException e) {
                hostname = "unknown";
            }
            return this.prefix.replace("${hostname}", hostname);
        }

        public boolean filter(String name) {
            return this.allowedMetrics.stream().anyMatch(f -> ALL_METRICS.equals(f) || name.startsWith((String)f)) || this.deniedMetrics.stream().noneMatch(f -> ALL_METRICS.equals(f) || name.startsWith((String)f));
        }

        public String toString() {
            return String.format("graphiteReporter %s prefix: %s, host: %s, port: %d, period: %d", this.enabled != false ? "enabled" : "disabled", this.prefix, this.host, this.port, this.period);
        }

        public void enable(MetricRegistry registry) {
            if (!this.enabled.booleanValue()) {
                return;
            }
            InetSocketAddress address = new InetSocketAddress(this.host, (int)this.port);
            Graphite graphite = new Graphite(address);
            this.reporter = GraphiteReporter.forRegistry((MetricRegistry)registry).convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.MICROSECONDS).prefixedWith(this.getPrefix()).filter((name, metric) -> this.filter(name)).build(graphite);
            this.reporter.start((long)this.period.intValue(), TimeUnit.SECONDS);
        }

        public void disable(MetricRegistry registry) {
            if (this.reporter == null) {
                return;
            }
            try {
                this.reporter.stop();
            }
            finally {
                this.reporter = null;
            }
        }
    }
}

