/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.metrics;

import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.metrics.MetricsReporter;

public abstract class AbstractMetricsReporter
implements MetricsReporter {
    protected Map<String, String> options;
    protected long pollInterval;

    @Override
    public void init(long pollInterval, Map<String, String> options) {
        this.options = options;
        this.pollInterval = pollInterval;
    }

    protected String getCurrentHostname() {
        try {
            return InetAddress.getLocalHost().getHostName().split("\\.")[0];
        }
        catch (UnknownHostException e) {
            return "unknown";
        }
    }

    protected long getPollInterval() {
        return this.pollInterval;
    }

    protected String getHostnameFromNuxeoUrl() {
        try {
            String url = Framework.getProperty((String)"nuxeo.url");
            if (StringUtils.isBlank((CharSequence)url)) {
                return "";
            }
            URI uri = new URI(url);
            String domain = uri.getHost();
            if (StringUtils.isBlank((CharSequence)domain)) {
                return "";
            }
            return domain.startsWith("www.") ? domain.substring(4) : domain;
        }
        catch (URISyntaxException e) {
            return "";
        }
    }

    protected String getOption(String name, String defaultValue) {
        String value = this.options.get(name);
        if (StringUtils.isBlank((CharSequence)value)) {
            return defaultValue;
        }
        return value;
    }

    protected String requireOption(String name) {
        return this.requireOption(name, null);
    }

    protected String requireOption(String name, String errorMessage) {
        String value = this.options.get(name);
        if (StringUtils.isBlank((CharSequence)value)) {
            throw new IllegalArgumentException("Metric Reporter configuration requires option: " + name + (String)(StringUtils.isBlank((CharSequence)errorMessage) ? "" : " " + errorMessage));
        }
        return value;
    }

    protected int getOptionAsInt(String name, int defaultValue) {
        String value = this.options.get(name);
        if (StringUtils.isBlank((CharSequence)value)) {
            return defaultValue;
        }
        return Integer.valueOf(value);
    }

    protected boolean getOptionAsBoolean(String name, boolean defaultValue) {
        String value = this.options.get(name);
        if (StringUtils.isBlank((CharSequence)value)) {
            return defaultValue;
        }
        return Boolean.valueOf(value);
    }
}

