/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.metrics.reporter;

import io.dropwizard.metrics5.MetricAttribute;
import io.dropwizard.metrics5.MetricFilter;
import io.dropwizard.metrics5.MetricRegistry;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.coursera.metrics.datadog.DefaultMetricNameFormatter;
import org.coursera.metrics.datadog.MetricNameFormatter;
import org.coursera.metrics.datadog.transport.HttpTransport;
import org.coursera.metrics.datadog.transport.Transport;
import org.coursera.metrics.datadog.transport.UdpTransport;
import org.nuxeo.runtime.metrics.AbstractMetricsReporter;
import org.nuxeo.runtime.metrics.reporter.patch.NuxeoDatadogReporter;

public class DatadogReporter
extends AbstractMetricsReporter {
    private static final Logger log = LogManager.getLogger(DatadogReporter.class);
    protected NuxeoDatadogReporter reporter;
    protected String hostname;
    protected List<String> tags;

    @Override
    public void init(long pollInterval, Map<String, String> options) {
        super.init(pollInterval, options);
        this.hostname = this.getHostname();
        this.tags = this.getTags();
    }

    private String getHostname() {
        String value = (String)this.options.get("hostname");
        if (!StringUtils.isBlank((CharSequence)value)) {
            return value;
        }
        value = this.getHostnameFromNuxeoUrl();
        if (!StringUtils.isBlank((CharSequence)value)) {
            return value;
        }
        return this.getCurrentHostname();
    }

    @Override
    public void start(MetricRegistry registry, MetricFilter filter, Set<MetricAttribute> deniedExpansions) {
        HttpTransport transport;
        if (this.getOptionAsBoolean("udp", false)) {
            String host = this.requireOption("host", "when using UDP");
            int port = this.getOptionAsInt("port", 8125);
            log.warn("Connecting using UDP {}:{} reporting every {}s from {}", (Object)host, (Object)port, (Object)this.pollInterval, (Object)this.hostname);
            transport = new UdpTransport.Builder().withStatsdHost(host).withPort(port).withRetryingLookup(true).build();
        } else {
            String apiKey = this.requireOption("apiKey", "when using HTTP");
            transport = new HttpTransport.Builder().withApiKey(apiKey).build();
            log.warn("Connecting using HTTP transport using apiKey reporting every {}s from {}", (Object)this.pollInterval, (Object)this.hostname);
        }
        this.reporter = NuxeoDatadogReporter.forRegistry(registry).withHost(this.hostname).withTags(this.tags).withTransport((Transport)transport).withExpansions(this.getExpansions(deniedExpansions)).filter(filter).withMetricNameFormatter((MetricNameFormatter)new DefaultMetricNameFormatter()).build();
        this.reporter.start(this.getPollInterval(), TimeUnit.SECONDS);
    }

    protected List<String> getTags() {
        String value = this.getOption("tags", "nuxeo");
        return Arrays.asList(value.split(","));
    }

    protected EnumSet<NuxeoDatadogReporter.Expansion> getExpansions(Set<MetricAttribute> deniedExpansions) {
        if (deniedExpansions.isEmpty()) {
            return NuxeoDatadogReporter.Expansion.ALL;
        }
        return NuxeoDatadogReporter.Expansion.ALL.stream().filter(e -> {
            switch (e) {
                case MAX: {
                    return !deniedExpansions.contains(MetricAttribute.MAX);
                }
                case MIN: {
                    return !deniedExpansions.contains(MetricAttribute.MIN);
                }
                case MEAN: {
                    return !deniedExpansions.contains(MetricAttribute.MEAN);
                }
                case MEDIAN: {
                    return !deniedExpansions.contains(MetricAttribute.P50);
                }
                case P75: {
                    return !deniedExpansions.contains(MetricAttribute.P75);
                }
                case P95: {
                    return !deniedExpansions.contains(MetricAttribute.P95);
                }
                case P98: {
                    return !deniedExpansions.contains(MetricAttribute.P98);
                }
                case P99: {
                    return !deniedExpansions.contains(MetricAttribute.P99);
                }
                case P999: {
                    return !deniedExpansions.contains(MetricAttribute.P999);
                }
                case COUNT: {
                    return !deniedExpansions.contains(MetricAttribute.COUNT);
                }
                case STD_DEV: {
                    return !deniedExpansions.contains(MetricAttribute.STDDEV);
                }
                case RATE_MEAN: {
                    return !deniedExpansions.contains(MetricAttribute.MEAN_RATE);
                }
                case RATE_1_MINUTE: {
                    return !deniedExpansions.contains(MetricAttribute.M1_RATE);
                }
                case RATE_5_MINUTE: {
                    return !deniedExpansions.contains(MetricAttribute.M5_RATE);
                }
                case RATE_15_MINUTE: {
                    return !deniedExpansions.contains(MetricAttribute.M15_RATE);
                }
            }
            return false;
        }).collect(Collectors.toCollection(() -> EnumSet.noneOf(NuxeoDatadogReporter.Expansion.class)));
    }

    @Override
    public void stop() {
        log.debug("Stop reporting");
        this.reporter.stop();
    }
}

