/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.metrics;

import io.dropwizard.metrics5.Metric;
import io.dropwizard.metrics5.MetricAttribute;
import io.dropwizard.metrics5.MetricFilter;
import io.dropwizard.metrics5.MetricName;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeList;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.common.xmap.registry.XEnable;
import org.nuxeo.common.xmap.registry.XRegistry;

@XObject(value="configuration")
@XRegistry(compatWarnOnMerge=true)
public class MetricsConfigurationDescriptor
implements MetricFilter {
    protected static final String ALL_METRICS = "ALL";
    @XEnable
    @XNode(value="@enable", fallback="@enabled")
    protected boolean isEnabled = true;
    @XNodeList(value="instrument", type=ArrayList.class, componentType=InstrumentDescriptor.class)
    protected List<InstrumentDescriptor> instruments = new ArrayList<InstrumentDescriptor>();
    @XNode(value="filter")
    protected FilterDescriptor filter = new FilterDescriptor();

    public static String expandName(MetricName metric) {
        if (metric.getTags().isEmpty()) {
            return metric.getKey();
        }
        String name = metric.getKey();
        for (Map.Entry entry : metric.getTags().entrySet()) {
            String key = "." + (String)entry.getKey() + ".";
            String keyAndValue = key + (String)entry.getValue() + ".";
            name = name.replace(key, keyAndValue);
        }
        return name;
    }

    public boolean matches(MetricName name, Metric metric) {
        String expandedName = MetricsConfigurationDescriptor.expandName(name);
        return this.filter.allowedPrefix.stream().anyMatch(f -> ALL_METRICS.equals(f) || expandedName.startsWith((String)f)) || this.filter.deniedPrefix.stream().noneMatch(f -> ALL_METRICS.equals(f) || expandedName.startsWith((String)f));
    }

    public Set<MetricAttribute> getDeniedExpansions() {
        return this.filter.getDeniedExpansions();
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public List<InstrumentDescriptor> getInstruments() {
        return this.instruments;
    }

    @XObject(value="filter")
    public static class FilterDescriptor {
        @XNodeList(value="allow/prefix", type=ArrayList.class, componentType=String.class)
        protected List<String> allowedPrefix = new ArrayList<String>();
        @XNodeList(value="deny/prefix", type=ArrayList.class, componentType=String.class)
        protected List<String> deniedPrefix = new ArrayList<String>();
        @XNodeList(value="deny/expansion", type=ArrayList.class, componentType=String.class)
        protected List<String> deniedExpansions = new ArrayList<String>();

        public List<String> getAllowedPrefix() {
            return Collections.unmodifiableList(this.allowedPrefix);
        }

        public List<String> getDeniedPrefix() {
            return Collections.unmodifiableList(this.deniedPrefix);
        }

        public Set<MetricAttribute> getDeniedExpansions() {
            if (this.deniedExpansions.isEmpty()) {
                return Collections.emptySet();
            }
            return this.deniedExpansions.stream().map(expansion -> MetricAttribute.valueOf((String)expansion.toUpperCase().strip())).collect(Collectors.toSet());
        }
    }

    @XObject(value="instrument")
    public static class InstrumentDescriptor {
        @XNode(value="@name")
        protected String name;
        @XNode(value="@enabled")
        protected boolean isEnabled = true;

        public String getId() {
            return this.name;
        }

        public boolean isEnabled() {
            return this.isEnabled;
        }
    }
}

