/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.metrics.reporter;

import io.dropwizard.metrics5.MetricAttribute;
import io.dropwizard.metrics5.MetricFilter;
import io.dropwizard.metrics5.MetricRegistry;
import io.opencensus.common.Duration;
import io.opencensus.exporter.trace.stackdriver.StackdriverTraceConfiguration;
import io.opencensus.exporter.trace.stackdriver.StackdriverTraceExporter;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.common.utils.DurationUtils;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.metrics.AbstractMetricsReporter;

public class StackdriverTraceReporter
extends AbstractMetricsReporter {
    private static final Logger log = LogManager.getLogger(StackdriverTraceReporter.class);
    public static final String GCP_PROJECT_ID_ENV_PROP = "GCP_PROJECT_ID";
    public static final String GCP_PROJECT_ID_OPTION_PROP = "gcpProjectId";
    protected boolean activated;

    @Override
    public void start(MetricRegistry registry, MetricFilter filter, Set<MetricAttribute> deniedExpansions) {
        log.warn("Creating Stackdriver trace reporter");
        Duration timeout = Duration.create((long)DurationUtils.parsePositive((String)((String)this.options.get("timeout")), (java.time.Duration)DEFAULT_TIMEOUT).getSeconds(), (int)0);
        String projectId = StackdriverTraceReporter.getGcpProjectId(this.options);
        StackdriverTraceConfiguration configuration = StackdriverTraceConfiguration.builder().setDeadline(timeout).setProjectId(projectId).build();
        try {
            StackdriverTraceExporter.createAndRegister((StackdriverTraceConfiguration)configuration);
        }
        catch (IOException e) {
            log.error("Fail to create a Stackdriver trace reporter", (Throwable)e);
            return;
        }
        this.activated = true;
        this.enableTracing();
    }

    protected static String getGcpProjectId(Map<String, String> options) {
        return (String)StringUtils.defaultIfBlank((CharSequence)options.get(GCP_PROJECT_ID_OPTION_PROP), (CharSequence)Framework.getProperty((String)GCP_PROJECT_ID_ENV_PROP));
    }

    @Override
    public void stop() {
        log.debug("Stop reporting");
        if (this.activated) {
            StackdriverTraceExporter.unregister();
            this.activated = false;
        }
    }
}

