/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.migration;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.nuxeo.runtime.migration.MigrationDescriptor;
import org.nuxeo.runtime.migration.MigrationService;
import org.nuxeo.runtime.migration.MigrationStep;

public class Migration {
    protected final String id;
    protected final String description;
    protected final String descriptionLabel;
    protected final MigrationService.MigrationStatus status;
    protected final List<MigrationStep> steps;

    protected Migration(String id, String description, String label, MigrationService.MigrationStatus status, List<MigrationStep> steps) {
        this.id = id;
        this.description = description;
        this.descriptionLabel = label;
        this.steps = steps;
        this.status = status;
    }

    public static Migration from(MigrationDescriptor descriptor, MigrationService.MigrationStatus status) {
        return new Migration(descriptor.getId(), descriptor.getDescription(), descriptor.getDescriptionLabel(), status, Migration.getAvailableSteps(descriptor, status));
    }

    protected static List<MigrationStep> getAvailableSteps(MigrationDescriptor descriptor, MigrationService.MigrationStatus status) {
        return descriptor.getSteps().values().stream().filter(s -> s.getFromState().equals(status.getState())).map(MigrationStep::from).collect(Collectors.toUnmodifiableList());
    }

    public String getId() {
        return this.id;
    }

    public String getDescription() {
        return this.description;
    }

    public String getDescriptionLabel() {
        return this.descriptionLabel;
    }

    public MigrationService.MigrationStatus getStatus() {
        return this.status;
    }

    public List<MigrationStep> getSteps() {
        return this.steps;
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, (String[])new String[0]);
    }

    public String toString() {
        return "Migration [id=" + this.id + ", description=" + this.description + ", descriptionLabel=" + this.descriptionLabel + ", status=" + this.status + ", steps=" + this.steps + "]";
    }
}

