/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.mongodb;

import com.mongodb.client.MongoClient;
import java.io.IOException;
import java.net.URL;
import org.nuxeo.osgi.BundleImpl;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.StreamRef;
import org.nuxeo.runtime.model.URLStreamRef;
import org.nuxeo.runtime.mongodb.IgnoreNoMongoDB;
import org.nuxeo.runtime.mongodb.MongoDBConnectionHelper;
import org.nuxeo.runtime.test.runner.ConditionalIgnoreRule;
import org.nuxeo.runtime.test.runner.Deploy;
import org.nuxeo.runtime.test.runner.Deploys;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.FeaturesRunner;
import org.nuxeo.runtime.test.runner.RunnerFeature;
import org.nuxeo.runtime.test.runner.RuntimeFeature;
import org.nuxeo.runtime.test.runner.RuntimeHarness;

@Features(value={RuntimeFeature.class})
@Deploys(value={@Deploy(value={"org.nuxeo.runtime.mongodb"}), @Deploy(value={"org.nuxeo.runtime.mongodb.test"})})
@ConditionalIgnoreRule.Ignore(condition=IgnoreNoMongoDB.class, cause="Needs a MongoDB server!")
public class MongoDBFeature
implements RunnerFeature {
    public static final String MONGODB_SERVER_PROPERTY = "nuxeo.test.mongodb.server";
    public static final String MONGODB_DBNAME_PROPERTY = "nuxeo.test.mongodb.dbname";
    public static final String DEFAULT_MONGODB_SERVER = "localhost:27017";
    public static final String DEFAULT_MONGODB_DBNAME = "unittests";

    protected static String defaultProperty(String name, String def) {
        String value = System.getProperty(name);
        if (value == null || value.equals("") || value.equals("${" + name + "}")) {
            value = def;
        }
        Framework.getProperties().setProperty(name, value);
        return value;
    }

    public void start(FeaturesRunner runner) {
        String server = MongoDBFeature.defaultProperty(MONGODB_SERVER_PROPERTY, DEFAULT_MONGODB_SERVER);
        String dbname = MongoDBFeature.defaultProperty(MONGODB_DBNAME_PROPERTY, DEFAULT_MONGODB_DBNAME);
        try {
            RuntimeHarness harness = ((RuntimeFeature)runner.getFeature(RuntimeFeature.class)).getHarness();
            BundleImpl bundle = harness.getOSGiAdapter().getRegistry().getBundle("org.nuxeo.runtime.mongodb.test");
            URL url = bundle.getEntry("OSGI-INF/mongodb-test-contrib.xml");
            harness.getContext().deploy((StreamRef)new URLStreamRef(url));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        try (MongoClient client = MongoDBConnectionHelper.newMongoClient((String)server);){
            MongoDBConnectionHelper.getDatabase((MongoClient)client, (String)dbname).drop();
        }
    }
}

