/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.pubsub;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.runtime.pubsub.AbstractPubSubBroker;
import org.nuxeo.runtime.pubsub.SerializableAccumulableInvalidations;

public abstract class AbstractPubSubInvalidationsAccumulator<T extends SerializableAccumulableInvalidations>
extends AbstractPubSubBroker<T> {
    private static final Log log = LogFactory.getLog(AbstractPubSubInvalidationsAccumulator.class);
    protected volatile T bufferedInvalidations;

    public abstract T newInvalidations();

    @Override
    public void initialize(String topic, String discriminator) {
        this.bufferedInvalidations = this.newInvalidations();
        super.initialize(topic, discriminator);
    }

    @Override
    public void close() {
        super.close();
        this.bufferedInvalidations = this.newInvalidations();
    }

    public void sendInvalidations(T invalidations) {
        this.sendMessage(invalidations);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void receivedMessage(T invalidations) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Received invalidations: " + invalidations));
        }
        AbstractPubSubInvalidationsAccumulator abstractPubSubInvalidationsAccumulator = this;
        synchronized (abstractPubSubInvalidationsAccumulator) {
            this.bufferedInvalidations.add((SerializableAccumulableInvalidations)invalidations);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T receiveInvalidations() {
        T invalidations;
        T newInvalidations = this.newInvalidations();
        AbstractPubSubInvalidationsAccumulator abstractPubSubInvalidationsAccumulator = this;
        synchronized (abstractPubSubInvalidationsAccumulator) {
            invalidations = this.bufferedInvalidations;
            this.bufferedInvalidations = newInvalidations;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("Received invalidations: " + invalidations));
        }
        return invalidations;
    }
}

